{******************************************************************************}
{                                                                              }
{  eWriteNames.dpr                                                             }
{                                                                              }
{  Demonstrates how to use the LJM_eWriteNames function.                       }
{                                                                              }
{******************************************************************************}

program eWriteNames;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  ErrorAddress: Integer;
  NumFrames: Integer;
  aNames: array [0..1] of AnsiString;
  aValues: array [0..1] of Double;
begin
  Handle := 0;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Call LJM_eWriteNames to write multiple values to the LabJack. }
  NumFrames := 2;
  aNames[0] := 'DAC0';
  aNames[1] := 'TEST_UINT16';
  aValues[0] := 2.5; { V }
  aValues[1] := 12345;
  ErrorAddress := -1;
  Error := LJM_eWriteNames(Handle, NumFrames, @aNames, @aValues, ErrorAddress);
  ErrorHandler('LJM_eWriteNames', Error, ErrorAddress);

  Writeln('LJM_eWriteNames:');
  for i := 0 to NumFrames-1 do
  begin
    Writeln('  Name = ' + aNames[i] + ' , Value = ' + FloatToStr(aValues[i]));
  end;

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
