{******************************************************************************}
{                                                                              }
{  ReadDeviceNameString.dpr                                                    }
{                                                                              }
{  Demonstrates how to read the device name string from a LabJack.             }
{                                                                              }
{******************************************************************************}

program ReadDeviceNameString;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  Handle: Integer;
  Error: Integer;
  DeviceName: array [0..LJM_MAX_NAME_SIZE-1] of AnsiChar;
begin
  Handle := 0;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Reading LabJack's device name string. }
  Error := LJM_eReadNameString(Handle, 'DEVICE_NAME_DEFAULT', DeviceName);
  ErrorHandler('LJM_eReadNameString', Error);

  Writeln('Device name : ' + AnsiString(DeviceName));

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
