{******************************************************************************}
{                                                                              }
{  WriteDeviceNameString.dpr                                                   }
{                                                                              }
{  Demonstrates how to set the device name string on a LabJack.                }
{                                                                              }
{******************************************************************************}

program WriteDeviceNameString;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  Handle: Integer;
  Error: Integer;
  DeviceName: AnsiString;
begin
  Handle := 0;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Set the LabJack's device name string. }
  DeviceName := 'LJTest';
  Error := LJM_eWriteNameString(Handle, 'DEVICE_NAME_DEFAULT',
    Pointer(DeviceName));
  { Will work as well }
  { Error := LJM_eWriteNameString(Handle, 'DEVICE_NAME_DEFAULT', 'LJTest'); }
  ErrorHandler('LJM_eWriteNameString', Error);

  Writeln('Set device name = ' + DeviceName);

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
