{******************************************************************************}
{                                                                              }
{  WritePowerConfig.dpr                                                        }
{                                                                              }
{  Demonstrates how to configure default power settings on a LabJack.          }
{                                                                              }
{******************************************************************************}

program WritePowerConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  ErrorAddress: Integer;
  NumFrames: Integer;
  aNames: array [0..3] of AnsiString;
  aValues: array [0..3] of Double;
begin
  Handle := 0;
  ErrorAddress := -1;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Setup and call LJM_eWriteNames to write configuration values to the
    LabJack. }
  NumFrames := 4;
  aNames[0] := 'POWER_ETHERNET_DEFAULT';
  aNames[1] := 'POWER_WIFI_DEFAULT';
  aNames[2] := 'POWER_AIN_DEFAULT';
  aNames[3] := 'POWER_LED_DEFAULT';
  aValues[0] := 1; { Ethernet on }
  aValues[1] := 0; { WiFi off }
  aValues[2] := 1; { AIN on }
  aValues[3] := 1; { LED on }
  Error := LJM_eWriteNames(Handle, NumFrames, @aNames, @aValues, ErrorAddress);
  ErrorHandler('LJM_eWriteNames', Error, ErrorAddress);

  Writeln('Set configuration settings:');
  for i := 0 to NumFrames-1 do
  begin
    Writeln('  ' + aNames[i] + ' : ' + FloatToStr(aValues[i]));
  end;

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
