{******************************************************************************}
{                                                                              }
{  SingleDIORead.dpr                                                           }
{                                                                              }
{  Demonstrates how to read a single digital input/output.                     }
{                                                                              }
{******************************************************************************}

program SingleDIORead;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  Handle: Integer;
  Error: Integer;
  Name: AnsiString;
  Value: Double;
begin
  Handle := 0;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Setup and call LJM_eReadName to read the DIO state. }
  if GetDeviceType(Handle) = LJM_dtT4 then
  begin
    { Reading FIO4 on the LabJack T4. FIO0-FIO3 are reserved for AIN0-AIN3. }
    Name := 'FIO4';
  end
  else
  begin
    { Reading FIO0 on the LabJack T7 and other devices. }
    Name := 'FIO0';
  end;
  Value := 0; { State : 0 = low, 1 = high}
  Error := LJM_eReadName(Handle, PAnsiChar(Name), Value);
  ErrorHandler('LJM_eReadName', Error);

  Writeln(Name + ' state : ' + FloatToStr(Value));

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
