{******************************************************************************}
{                                                                              }
{  WriteEthernetConfig.dpr                                                     }
{                                                                              }
{  Demonstrates how to set ethernet configuration settings on a LabJack.       }
{                                                                              }
{******************************************************************************}

program WriteEthernetConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  ErrorAddress: Integer;
  NumFrames: Integer;
  aNames: array[0..3] of AnsiString;
  aValues: array[0..3] of Double;
  IPValue: Cardinal;
  IPStr: array [0..LJM_IPv4_STRING_SIZE-1] of AnsiChar;
begin
  Handle := 0;
  ErrorAddress := -1;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Setup and call LJM_eWriteNames to set the ethernet configuration on
    the LabJack. }
  NumFrames := 4;
  aNames[0] := 'ETHERNET_IP_DEFAULT';
  aNames[1] := 'ETHERNET_SUBNET_DEFAULT';
  aNames[2] := 'ETHERNET_GATEWAY_DEFAULT';
  aNames[3] := 'ETHERNET_DHCP_ENABLE_DEFAULT';
  { ETHERNET_IP_DEFAULT }
  Error := LJM_IPToNumber('192.168.1.207', IPValue);
  ErrorHandler('LJM_IPToNumber(0)', Error);
  aValues[0] := IPValue;
  { ETHERNET_SUBNET_DEFAULT }
  Error := LJM_IPToNumber('255.255.255.0', IPValue);
  ErrorHandler('LJM_IPToNumber(1)', Error);
  aValues[1] := IPValue;
  { ETHERNET_GATEWAY_DEFAULT }
  Error := LJM_IPToNumber('192.168.1.1', IPValue);
  ErrorHandler('LJM_IPToNumber(2)', Error);
  aValues[2] := IPValue;
  { ETHERNET_DHCP_ENABLE_DEFAULT }
  aValues[3] := 1; { 1 = Enable, 0 = Disable}
  error := LJM_eWriteNames(Handle, NumFrames, @aNames, @aValues, ErrorAddress);
  ErrorHandler('LJM_eWriteNames', Error, ErrorAddress);

  Writeln('Set Ethernet Configuration:');
  for i := 0 to NumFrames-1 do
  begin
    if AnsiCompareStr(aNames[i], 'ETHERNET_DHCP_ENABLE_DEFAULT') = 0 then
    begin
      Writeln('  ' + aNames[i] + ' : ' + FloatToStr(aValues[i]));
    end
    else
    begin
      Error := LJM_NumberToIP(Cardinal(Trunc(aValues[i])), IPStr);
      ErrorHandler('LJM_NumberToIP(' + IntToStr(i) + ' )', Error);
      Writeln('  ' + aNames[i] + ' : ' + AnsiString(IPStr) + '  (' +
        FloatToStr(aValues[i]) + ')');
    end;
  end;

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
