{******************************************************************************}
{                                                                              }
{  WriteWatchdogConfig.dpr                                                     }
{                                                                              }
{  Demonstrates how to configure the Watchdog on a LabJack.                    }
{                                                                              }
{******************************************************************************}

program WriteWatchdogConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  ErrorAddress: Integer;
  NumFrames: Integer;
  aNames: array [0..15] of AnsiString;
  aValues: array [0..15] of Double;
begin
  Handle := 0;
  ErrorAddress := -1;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Setup and call LJM_eWriteNames to configure the Watchdog on a LabJack.
    Disable the Watchdog first before any other configuration. }
  NumFrames := 16;
  aNames[0] := 'WATCHDOG_ENABLE_DEFAULT';
  aNames[1] := 'WATCHDOG_ADVANCED_DEFAULT';
  aNames[2] := 'WATCHDOG_TIMEOUT_S_DEFAULT';
  aNames[3] := 'WATCHDOG_STARTUP_DELAY_S_DEFAULT';
  aNames[4] := 'WATCHDOG_STRICT_ENABLE_DEFAULT';
  aNames[5] := 'WATCHDOG_STRICT_KEY_DEFAULT';
  aNames[6] := 'WATCHDOG_RESET_ENABLE_DEFAULT';
  aNames[7] := 'WATCHDOG_DIO_ENABLE_DEFAULT';
  aNames[8] := 'WATCHDOG_DIO_STATE_DEFAULT';
  aNames[9] := 'WATCHDOG_DIO_DIRECTION_DEFAULT';
  aNames[10] := 'WATCHDOG_DIO_INHIBIT_DEFAULT';
  aNames[11] := 'WATCHDOG_DAC0_ENABLE_DEFAULT';
  aNames[12] := 'WATCHDOG_DAC0_DEFAULT';
  aNames[13] := 'WATCHDOG_DAC1_ENABLE_DEFAULT';
  aNames[14] := 'WATCHDOG_DAC1_DEFAULT';
  aNames[15] := 'WATCHDOG_ENABLE_DEFAULT';
  aValues[0] := 0;
  aValues[1] := 0;
  aValues[2] := 20;
  aValues[3] := 0;
  aValues[4] := 0;
  aValues[5] := 0;
  aValues[6] := 1;
  aValues[7] := 0;
  aValues[8] := 0;
  aValues[9] := 0;
  aValues[10] := 0;
  aValues[11] := 0;
  aValues[12] := 0;
  aValues[13] := 0;
  aValues[14] := 0;
  aValues[15] := 0; { Set WATCHDOG_ENABLE_DEFAULT to 1 to enable }
  Error := LJM_eWriteNames(Handle, NumFrames, @aNames, @aValues, ErrorAddress);
  ErrorHandler('LJM_eWriteNames', Error, ErrorAddress);

  Writeln('Set Watchdog Configuration:');
  for i := 0 to NumFrames-1 do
    Writeln('  ' + aNames[i] + ' = ' + FloatToStr(aValues[i]));

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
