{******************************************************************************}
{                                                                              }
{  ReadWiFIMAC.dpr                                                             }
{                                                                              }
{  Demonstrates how to read the WiFi MAC from a LabJack.                       }
{                                                                              }
{******************************************************************************}

program ReadWiFiMAC;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  ErrorAddress: Integer;
  aBytes: array [0..7] of Byte;
  MACUint: Uint64;
  MACStr: array[0..LJM_MAC_STRING_SIZE-1] of AnsiChar;
begin
  Handle := 0;
  ErrorAddress := -1;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  if GetDeviceType(Handle) = LJM_dtT4 then
  begin
    Writeln('The LabJack T4 does not support WiFi.');
    LJM_Close(Handle); { Close the handle. }
    WaitForUser('Press Enter to exit.');
    Halt;
  end;

  { Call LJM_eReadAddressByteArray to read the WiFi MAC (address 60024) from
    the LabJack. We are reading a byte array which is the big endian binary
    representation of the 64-bit MAC. }
  Error := LJM_eReadAddressByteArray(Handle, 60024, 8, @aBytes, ErrorAddress);
  ErrorHandler('LJM_eReadAddressByteArray', Error, ErrorAddress);

  { Convert big endian byte array to a 64-bit unsigned integer value. }
  MACUint := 0;
  for i := 0 to 7 do
    MACUint := MACUint + (Uint64(aBytes[i]) shl ((7-i)*8));

  { Convert the MAC value to its string representation. }
  LJM_NumberToMAC(MACUint, @MACStr);
  Writeln('Read WiFi MAC : ' + AnsiString(MACStr) + '  (' + IntToStr(MACUint) +
    ')' );

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
