{******************************************************************************}
{                                                                              }
{  ReadWiFiRSSI.dpr                                                            }
{                                                                              }
{  Demonstrates how to read the WiFI RSSI from a LabJack.                      }
{                                                                              }
{******************************************************************************}

program ReadWiFiRSSI;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  Handle: Integer;
  Error: Integer;
  Value: Double;
begin
  Handle := 0;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  if GetDeviceType(Handle) = LJM_dtT4 then
  begin
    Writeln('The LabJack T4 does not support WiFi.');
    LJM_Close(Handle); { Close the handle. }
    WaitForUser('Press Enter to exit.');
    Halt;
  end;

  { Setup and call LJM_eReadName to read the WiFi RSSI from the LabJack. }
  Error := LJM_eReadName(Handle, 'WIFI_RSSI', Value);
  ErrorHandler('LJM_eReadName', Error);

  Writeln('WiFi RSSI = ' + FloatToStr(Value));

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
