{******************************************************************************}
{                                                                              }
{  eReadAddresses.dpr                                                          }
{                                                                              }
{  Demonstrates how to use the LJM_eReadAddresses function.                    }
{                                                                              }
{******************************************************************************}

program eReadAddresses;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  NumFrames: Integer;
  aAddresses: array [0..2] of Integer;
  aDataTypes: array [0..2] of Integer;
  aValues: array [0..2] of Double;
  ErrorAddress: Integer;
begin
  Handle := 0;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Call LJM_eReadAddresses to read multiple values from the LabJack. }
  NumFrames := 3;
  aAddresses[0] := 60028; { SERIAL_NUMBER }
  aAddresses[1] := 60000; { PRODUCT_ID }
  aAddresses[2] := 60004; { FIRMWARE_VERSION }
  aDataTypes[0] := LJM_UINT32;
  aDataTypes[1] := LJM_FLOAT32;
  aDataTypes[2] := LJM_FLOAT32;
  aValues[0] := 0;
  aValues[1] := 0;
  aValues[2] := 0;
  ErrorAddress := -1;
  Error := LJM_eReadAddresses(Handle, NumFrames, @aAddresses, @aDataTypes,
    @aValues, ErrorAddress);
  ErrorHandler('LJM_eReadAddresses', Error, ErrorAddress);

  Writeln('LJM_eReadAddresses:');
  for i := 0 to NumFrames-1 do
  begin
    Writeln('  Address = ' + IntToStr(aAddresses[i]) + ', Value = ' +
    FormatFloat('0.####', aValues[i]));
  end;

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
