{******************************************************************************}
{                                                                              }
{  eReadNames.dpr                                                              }
{                                                                              }
{  Demonstrates how to use the LJM_eReadNames function.                        }
{                                                                              }
{******************************************************************************}

program eReadNames;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  ErrorAddress: Integer;
  NumFrames: Integer;
  aNames: array [0..2] of AnsiString;
  aValues: array [0..2] of Double;
begin
  Handle := 0;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Call LJM_eReadNames to read multiple values from the LabJack. }
  NumFrames := 3;
  aNames[0] := 'SERIAL_NUMBER';
  aNames[1] := 'PRODUCT_ID';
  aNames[2] := 'FIRMWARE_VERSION';
  aValues[0] := 0;
  aValues[1] := 0;
  aValues[2] := 0;
  ErrorAddress := -1;
  Error := LJM_eReadNames(Handle, NumFrames, @aNames, @aValues, ErrorAddress);
  ErrorHandler('LJM_eReadNames', Error, ErrorAddress);

  Writeln('LJM_eReadNames:');
  for i := 0 to NumFrames-1 do
  begin
    Writeln('  Name = ' + aNames[i] + ' , Value = ' +
      FormatFloat('0.####', aValues[i]));
  end;

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
