{******************************************************************************}
{                                                                              }
{  SingleAINWithConfig.dpr                                                     }
{                                                                              }
{  Demonstrates configuring and reading a single analog input (AIN) with a     }
{  LabJack.                                                                    }
{                                                                              }
{******************************************************************************}
program SingleAINWithConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  ErrorAddress: Integer;
  NumFrames: Integer;
  aNames: array of AnsiString;
  aValues: array of Double;
  Name: AnsiString;
  Value: Double;
begin
  Handle := 0;
  ErrorAddress := -1;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Setup and call eWriteNames to configure AIN0 on the LabJack. }
  if GetDeviceType(Handle) = LJM_dtT4 then
  begin
    { LabJack T4 configuration. }

    { AIN0:
        Range = +/-10 V (10.0). Only AIN0-AIN3 can support +/-10 V range.
        Resolution index = 0 (default)
        Settling = 0 (auto) }
    NumFrames := 3;
    SetLength(aNames, NumFrames);
    aNames[0] := 'AIN0_RANGE';
    aNames[1] := 'AIN0_RESOLUTION_INDEX';
    aNames[2] := 'AIN0_SETTLING_US';
    SetLength(aValues, NumFrames);
    aValues[0] := 10;
    aValues[1] := 0;
    aValues[2] := 0;
  end
  else
  begin
    { LabJack T7 and other devices configuration. }

    { AIN0:
        Negative Channel = 199 (Single-ended)
        Range = +/-10 V (10.0)
        Resolution index = 0 (default)
        Settling = 0 (auto) }
    NumFrames := 4;
    SetLength(aNames, NumFrames);
    aNames[0] := 'AIN0_NEGATIVE_CH';
    aNames[1] := 'AIN0_RANGE';
    aNames[2] := 'AIN0_RESOLUTION_INDEX';
    aNames[3] := 'AIN0_SETTLING_US';
    SetLength(aValues, NumFrames);
    aValues[0] := 199;
    aValues[1] := 10;
    aValues[2] := 0;
    aValues[3] := 0;
  end;
  Error := LJM_eWriteNames(Handle, NumFrames, Pointer(aNames), Pointer(aValues),
    ErrorAddress);
  ErrorHandler('LJM_eWriteNames (Configuration)', Error, ErrorAddress);

  Writeln('Configuration:');
  for i := 0 to NumFrames-1 do
  begin
    Writeln('  ' + aNames[i] + ' = ' + FloatToStr(aValues[i]));
  end;

  { Setup and call eReadName to read AIN0 from the LabJack. }
  Name := 'AIN0';
  Value := 0;
  Error := LJM_eReadName(Handle, PAnsiChar(Name), Value);
  ErrorHandler('LJM_eReadName (Reading)', Error);

  Writeln('');
  Writeln(Name + ' reading = ' + FormatFloat('0.00000', Value) + ' V');

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
