{******************************************************************************}
{                                                                              }
{  ReadConfig.dpr                                                              }
{                                                                              }
{  Demonstrates how to read configuration settings on a LabJack.               }
{                                                                              }
{******************************************************************************}

program ReadConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer = 0;
  ErrorAddress: Integer = -1;
  NumFrames: Integer;
  aNames: array of AnsiString;
  aValues: array of Double;
begin
  Handle := 0;
  ErrorAddress := -1;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Setup and call LJM_eReadNames to read configuration values from the
    LabJack. }
  if GetDeviceType(Handle) = LJM_dtT4 then
  begin
    { LabJack T4 configuration to read. }
    NumFrames := 8;
    SetLength(aNames, NumFrames);
    aNames[0] := 'PRODUCT_ID';
    aNames[1] := 'HARDWARE_VERSION';
    aNames[2] := 'FIRMWARE_VERSION';
    aNames[3] := 'BOOTLOADER_VERSION';
    aNames[4] := 'SERIAL_NUMBER';
    aNames[5] := 'POWER_ETHERNET_DEFAULT';
    aNames[6] := 'POWER_AIN_DEFAULT';
    aNames[7] := 'POWER_LED_DEFAULT';
  end
  else
  begin
    { LabJack T7 and other devices configuration to read. }
    NumFrames := 10;
    SetLength(aNames, NumFrames);
    aNames[0] := 'PRODUCT_ID';
    aNames[1] := 'HARDWARE_VERSION';
    aNames[2] := 'FIRMWARE_VERSION';
    aNames[3] := 'BOOTLOADER_VERSION';
    aNames[4] := 'WIFI_VERSION';
    aNames[5] := 'SERIAL_NUMBER';
    aNames[6] := 'POWER_ETHERNET_DEFAULT';
    aNames[7] := 'POWER_WIFI_DEFAULT';
    aNames[8] := 'POWER_AIN_DEFAULT';
    aNames[9] := 'POWER_LED_DEFAULT';
  end;
  SetLength(aValues, NumFrames);
  Error := LJM_eReadNames(Handle, NumFrames, Pointer(aNames), Pointer(aValues),
    ErrorAddress);
  ErrorHandler('LJM_eReadNames', Error, ErrorAddress);

  Writeln('Configuration settings:');
  for i := 0 to NumFrames-1 do
  begin
    Writeln('  ' + aNames[i] + ' : ' + FormatFloat('0.####', aValues[i]));
  end;

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
