{******************************************************************************}
{                                                                              }
{  SingleDIOWrite.dpr                                                          }
{                                                                              }
{  Demonstrates how to set a single digital state on a LabJack.                }
{                                                                              }
{******************************************************************************}

program SingleDIOWrite;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  Handle: Integer;
  Error: Integer;
  Name: AnsiString;
  Value: Double;
begin
  Handle := 0;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Setup and call LJM_eWriteName to set the DIO state. }
  if GetDeviceType(Handle) = LJM_dtT4 then
  begin
    { Setting FIO4 on the LabJack T4. FIO0-FIO3 are reserved for AIN0-AIN3. }
    Name := 'FIO4';

    { If the FIO/EIO line is an analog input, it needs to first be changed to a
      digital I/O by reading from the line or setting it to digital I/O with
      the DIO_ANALOG_ENABLE register. }

    { Reading from the digital line in case it was previously an analog input. }
    Value := 0;
    Error := LJM_eReadName(Handle, PAnsiChar(Name), Value);
    ErrorHandler('LJM_eReadName', Error);
  end
  else
  begin
    { Setting FIO0 on the LabJack T7 and other devices. }
    Name := 'FIO0';
  end;
  Value := 0; { State : 0 = low, 1 = high }
  Error := LJM_eWriteName(Handle, PAnsiChar(Name), Value);
  ErrorHandler('LJM_eWriteName', Error);

  Writeln('Set ' + Name + ' state to ' + FloatToStr(Value));

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
