{******************************************************************************}
{                                                                              }
{  ReadEthernetConfig.dpr                                                      }
{                                                                              }
{  Demonstrates how to read the ethernet configuration settings from a         }
{  LabJack.                                                                    }
{                                                                              }
{******************************************************************************}

program ReadEthernetConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  StrUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  ErrorAddress: Integer;
  NumFrames: Integer;
  aNames: array [0..7] of AnsiString;
  aValues: array [0..7] of Double;
  IPStr: array [0..LJM_IPv4_STRING_SIZE-1] of AnsiChar;
begin
  Handle := 0;
  ErrorAddress := -1;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Read ethernet configuration settings }
  NumFrames := 8;
  aNames[0] := 'ETHERNET_IP';
  aNames[1] := 'ETHERNET_SUBNET';
  aNames[2] := 'ETHERNET_GATEWAY';
  aNames[3] := 'ETHERNET_IP_DEFAULT';
  aNames[4] := 'ETHERNET_SUBNET_DEFAULT';
  aNames[5] := 'ETHERNET_GATEWAY_DEFAULT';
  aNames[6] := 'ETHERNET_DHCP_ENABLE';
  aNames[7] := 'ETHERNET_DHCP_ENABLE_DEFAULT';
  Error := LJM_eReadNames(Handle, NumFrames, @aNames, @aValues, ErrorAddress);
  ErrorHandler('LJM_eReadNames', Error, ErrorAddress);

  Writeln('Read Ethernet Configuration:');
  for i := 0 to numFrames-1 do
  begin
    if AnsiStartsStr('ETHERNET_DHCP_ENABLE', aNames[i]) then
    begin
      Writeln('  ' + aNames[i] + ' : ' + FloatToStr(aValues[i]));
    end
    else
    begin
      Error := LJM_NumberToIP(Cardinal(Trunc(aValues[i])), IPStr);
      ErrorHandler('LJM_NumberToIP(' + IntToStr(i) + ' )', Error);
      Writeln('  ' + aNames[i] + ' : ' + AnsiString(IPStr) + '  (' +
        FloatToStr(aValues[i]) + ')');
    end;
  end;

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
