{******************************************************************************}
{                                                                              }
{  LisAll.dpr                                                                  }
{                                                                              }
{  Demonstrates usage of the LJM_ListAll function which scans for LabJack      }
{  devices and returns information describing the found devices. This will     }
{  only find LabJack devices supported by the LJM library.                     }
{                                                                              }
{******************************************************************************}

program ListAll;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  NumFound: Integer;
  aDeviceTypes: array [0..LJM_LIST_ALL_SIZE-1] of Integer;
  aConnectionTypes: array [0..LJM_LIST_ALL_SIZE-1] of Integer;
  aSerialNumbers: array [0..LJM_LIST_ALL_SIZE-1] of Integer;
  aIPAddresses: array [0..LJM_LIST_ALL_SIZE-1] of Integer;
  Error: Integer;
  i: Integer;
  DevStr: String;
  ConStr: String;
  IPStr: array [0..LJM_IPv4_STRING_SIZE-1] of AnsiChar;
begin
  { Find and display LabJack devices with LJM_ListAllS. }
  Error := LJM_ListAllS('ANY', 'ANY', NumFound, @aDeviceTypes,
    @aConnectionTypes, @aSerialNumbers, @aIPAddresses);
  ErrorHandler('LJM_ListAllS', Error);
  Writeln('ListAllS found ' + IntToStr(NumFound) + ' LabJacks:');

  { Find and display LabJack devices with LJM_ListAll. }
  { Error := LJM_ListAll(LJM_dtANY, LJM_ctANY, NumFound, @aDeviceTypes,
      @aConnectionTypes, @aSerialNumbers, @aIPAddresses);
    ErrorHandler('LJM_ListAll', Error);
    Writeln('ListAll found ' + IntToStr(NumFound) + ' LabJacks:'); }

  Writeln('');
  Writeln(Format('%-18s %-18s %-18s %-18s',
    ['Device Type', 'Connection Type', 'Serial Number', 'IP Address']));
  for i := 0 to NumFound-1 do
  begin
    DevStr := NumberToDeviceType(aDeviceTypes[i]);
    DevStr := StringReplace(DevStr, 'LJM_dt', '', []); { Remove 'LJM_dt'. }
    if AnsiCompareStr(DevStr, 'Unknown device type') = 0 then
    begin
      DevStr := IntToStr(aDeviceTypes[i]);
    end;
    ConStr := NumberToConnectionType(aConnectionTypes[i]);
    ConStr := StringReplace(ConStr, 'LJM_ct', '', []); { Remove 'LJM_ct'. }
    if AnsiCompareStr(ConStr, 'Unknown connection type') = 0 then
    begin
      ConStr := IntToStr(aConnectionTypes[i]);
    end;
    IPStr := '';
    LJM_NumberToIP(aIPAddresses[i], @IPStr);
    Writeln(Format('%-18s %-18s %-18d %-18s',
      [devStr, ConStr, aSerialNumbers[i], AnsiString(IPStr)]));
  end;

  WaitForUser('Press Enter to exit.');
end.
