{******************************************************************************}
{                                                                              }
{  ReadWatchdogConfig.dpr                                                      }
{                                                                              }
{  Demonstrates how to read the Watchdog configuration from a LabJack.         }
{                                                                              }
{******************************************************************************}

program ReadWatchdogConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  ErrorAddress: Integer;
  NumFrames: Integer;
  aNames: array [0..14] of AnsiString;
  aValues: array [0..14] of Double;
begin
  Handle := 0;
  ErrorAddress := -1;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Read the Watchdog configuration. }
  NumFrames := 15;
  aNames[0] := 'WATCHDOG_ENABLE_DEFAULT';
  aNames[1] := 'WATCHDOG_ADVANCED_DEFAULT';
  aNames[2] := 'WATCHDOG_TIMEOUT_S_DEFAULT';
  aNames[3] := 'WATCHDOG_STARTUP_DELAY_S_DEFAULT';
  aNames[4] := 'WATCHDOG_STRICT_ENABLE_DEFAULT';
  aNames[5] := 'WATCHDOG_STRICT_KEY_DEFAULT';
  aNames[6] := 'WATCHDOG_RESET_ENABLE_DEFAULT';
  aNames[7] := 'WATCHDOG_DIO_ENABLE_DEFAULT';
  aNames[8] := 'WATCHDOG_DIO_STATE_DEFAULT';
  aNames[9] := 'WATCHDOG_DIO_DIRECTION_DEFAULT';
  aNames[10] := 'WATCHDOG_DIO_INHIBIT_DEFAULT';
  aNames[11] := 'WATCHDOG_DAC0_ENABLE_DEFAULT';
  aNames[12] := 'WATCHDOG_DAC0_DEFAULT';
  aNames[13] := 'WATCHDOG_DAC1_ENABLE_DEFAULT';
  aNames[14] := 'WATCHDOG_DAC1_DEFAULT';
  Error := LJM_eReadNames(Handle, NumFrames, @aNames, @aValues, ErrorAddress);
  ErrorHandler('LJM_eReadNames', Error, ErrorAddress);

  Writeln('Read Watchdog Configuration:');
  for i := 0 to NumFrames-1 do
    Writeln('  ' + aNames[i] + ' = ' + FloatToStr(aValues[i]));

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
