{******************************************************************************}
{                                                                              }
{  WriteWiFiConfig.dpr                                                         }
{                                                                              }
{  Demonstrates how to configure the WiFi settings on a LabJack.               }
{                                                                              }
{******************************************************************************}

program WriteWiFiConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  ErrorAddress: Integer;
  Value: Double;
  NumFrames: Integer;
  aNames: array [0..2] of AnsiString;
  aValues: array [0..2] of Double;
  IPValue: Cardinal;
  IPStr: array [0..LJM_IPv4_STRING_SIZE-1] of AnsiChar;
  SSIDStr: AnsiString;
  PasswordStr: AnsiString;
begin
  Handle := 0;
  ErrorAddress := -1;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_Open', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  if GetDeviceType(Handle) = LJM_dtT4 then
  begin
    Writeln('The LabJack T4 does not support WiFi.');
    LJM_Close(Handle); { Close the handle. }
    WaitForUser('Press Enter to exit.');
    Halt;
  end;

  { Setup and call LJM_eWriteNames to configure WiFi default settings on the
    LabJack. }
  NumFrames := 3;
  aNames[0] := 'WIFI_IP_DEFAULT';
  aNames[1] := 'WIFI_SUBNET_DEFAULT';
  aNames[2] := 'WIFI_GATEWAY_DEFAULT';
  { WIFI_IP_DEFAULT }
  Error := LJM_IPToNumber('192.168.1.207', IPValue);
  ErrorHandler('LJM_IPToNumber(0)', Error);
  aValues[0] := IPValue;
  { WIFI_SUBNET_DEFAULT }
  Error := LJM_IPToNumber('255.255.255.0', IPValue);
  ErrorHandler('LJM_IPToNumber(1)', Error);
  aValues[1] := IPValue;
  { WIFI_GATEWAY_DEFAULT }
  Error := LJM_IPToNumber('192.168.1.1', IPValue);
  ErrorHandler('LJM_IPToNumber(2)', Error);
  aValues[2] := IPValue;
  Error := LJM_eWriteNames(Handle, NumFrames, @aNames, @aValues, ErrorAddress);
  ErrorHandler('LJM_eWriteNames (configuration)', Error, ErrorAddress);
  Writeln('Set WiFi Configuration:');
  for i := 0 to NumFrames-1 do
  begin
    Error := LJM_NumberToIP(Cardinal(Trunc(aValues[i])), IPStr);
    ErrorHandler('LJM_NumberToIP (' + IntToStr(i) + ')', Error);
    Writeln('  ' + aNames[i] + ' : ' + AnsiString(IPStr) + '  (' +
      FloatToStr(aValues[i]) + ')');
  end;

  { Setup and call LJM_eWriteNameString to configure the default WiFi SSID on
    the LabJack. }
  SSIDStr := 'LJOpen';
  Error := LJM_eWriteNameString(handle, 'WIFI_SSID_DEFAULT', @SSIDStr);
  ErrorHandler('LJM_eWriteNameString (SSID)', Error);
  Writeln('  WIFI_SSID_DEFAULT: ' + SSIDStr);

  { Setup and call LJM_eWriteNameString to configure the default WiFi password
    on the LabJack.}
  PasswordStr := 'none';
  Error := LJM_eWriteNameString(Handle, 'WIFI_PASSWORD_DEFAULT', @PasswordStr);
  ErrorHandler('LJM_eWriteNameString (password)', Error);
  Writeln('  WIFI_PASSWORD_DEFAULT: ' + PasswordStr);

  { Setup and call LJM_eWriteName to apply the new WiFi configuration on the
    LabJack. }
  Value := 1;
  Error := LJM_eWriteName(Handle, 'WIFI_APPLY_SETTINGS', Value);
  ErrorHandler('LJM_eWriteName (apply)', Error);
  Writeln('  WIFI_APPLY_SETTINGS: ' + FloatToStr(Value));

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
