VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "main"
   ClientHeight    =   4275
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9195
   LinkTopic       =   "Form1"
   ScaleHeight     =   4275
   ScaleWidth      =   9195
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox TXTA0 
      BackColor       =   &H80000004&
      Height          =   495
      Left            =   6600
      TabIndex        =   14
      Top             =   240
      Width           =   1815
   End
   Begin VB.CommandButton Cmd2Off 
      Caption         =   "Off"
      Height          =   495
      Left            =   1440
      TabIndex        =   11
      Top             =   2640
      Width           =   855
   End
   Begin VB.CommandButton Cmd2On 
      Caption         =   "On"
      Height          =   495
      Left            =   1440
      TabIndex        =   10
      Top             =   2040
      Width           =   855
   End
   Begin VB.CommandButton Cmd3Off 
      Caption         =   "Off"
      Height          =   495
      Left            =   360
      TabIndex        =   9
      Top             =   2640
      Width           =   855
   End
   Begin VB.CommandButton CmD3On 
      Caption         =   "On"
      Height          =   495
      Left            =   360
      TabIndex        =   8
      Top             =   2040
      Width           =   855
   End
   Begin VB.Timer Timer1 
      Interval        =   200
      Left            =   7200
      Top             =   2280
   End
   Begin VB.Shape Shape4 
      Height          =   1815
      Left            =   1320
      Top             =   1440
      Width           =   1095
   End
   Begin VB.Shape Shape3 
      Height          =   1815
      Left            =   240
      Top             =   1440
      Width           =   1095
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      Caption         =   "Output 2"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1440
      TabIndex        =   13
      Top             =   1560
      Width           =   855
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      Caption         =   "Output 3"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   360
      TabIndex        =   12
      Top             =   1560
      Width           =   855
   End
   Begin VB.Label LblError 
      Caption         =   "Error displayed here if any"
      Height          =   375
      Left            =   1920
      TabIndex        =   7
      Top             =   3480
      Width           =   2895
   End
   Begin VB.Label Label8 
      Alignment       =   1  'Right Justify
      Caption         =   "channel 0 is"
      Height          =   255
      Left            =   3840
      TabIndex        =   6
      Top             =   2400
      Width           =   1695
   End
   Begin VB.Label Label2 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5880
      TabIndex        =   5
      Top             =   2520
      Width           =   735
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "channel 1 is"
      Height          =   255
      Left            =   3720
      TabIndex        =   4
      Top             =   1800
      Width           =   1815
   End
   Begin VB.Label Label6 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   5880
      TabIndex        =   3
      Top             =   1800
      Width           =   735
   End
   Begin VB.Label LblA1 
      Height          =   375
      Left            =   6720
      TabIndex        =   2
      Top             =   960
      Width           =   1575
   End
   Begin VB.Shape BarA1 
      FillColor       =   &H0000C000&
      FillStyle       =   0  'Solid
      Height          =   135
      Left            =   3120
      Top             =   960
      Width           =   3255
   End
   Begin VB.Shape BarA0 
      FillColor       =   &H000000FF&
      FillStyle       =   0  'Solid
      Height          =   135
      Left            =   3120
      Top             =   360
      Width           =   3255
   End
   Begin VB.Shape Shape2 
      Height          =   375
      Left            =   3000
      Top             =   840
      Width           =   3495
   End
   Begin VB.Shape Shape1 
      Height          =   375
      Left            =   3000
      Top             =   240
      Width           =   3495
   End
   Begin VB.Label Label5 
      Caption         =   "Analog input A1"
      Height          =   375
      Left            =   1560
      TabIndex        =   1
      Top             =   840
      Width           =   1335
   End
   Begin VB.Label Label4 
      Caption         =   "Analog input Ao"
      Height          =   375
      Left            =   1560
      TabIndex        =   0
      Top             =   240
      Width           =   1335
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This example calls EDigitalIn, EDigitalOut, EAnalogeIn, and GetErrorString,
'directly from the LabJack U12 DLL, rather than using the
'ActiveX control.

'If you have installed the LabJack software distribution
'or drivers_only, ljackuw.dll should have been put in
'your system directory, where VB will be able to find it.

Option Explicit

Private Declare Function EAnalogIn Lib "ljackuw.dll" _
    (ByRef lpIDNum As Long, _
     ByVal lngDemo As Long, _
     ByVal alngChannel As Long, _
     ByVal alngGain As Long, _
     ByRef lngOverVoltage As Long, _
     ByRef asngVoltages As Single) As Long
 '================================
Private Declare Function EDigitalIn Lib "ljackuw.dll" _
    (ByRef lpIDNum As Long, _
     ByVal lngDemo As Long, _
     ByVal alngChannel As Long, _
     ByVal alngReadD As Long, _
     ByRef lngState As Long) As Long

'===================================
Private Declare Function EDigitalOut Lib "ljackuw.dll" _
    (ByRef lpIDNum As Long, _
     ByVal lngDemo As Long, _
     ByVal alngChannel As Long, _
     ByVal alngWriteD As Long, _
     ByVal lngState As Long) As Long
'================================

Private Declare Sub GetErrorString Lib "ljackuw.dll" _
    (ByVal lngErrorcode As Long, _
     ByVal lpErrorString As String)
    
'Note that Strings are passed ByVal since they are inherently
'pointers.  Also, functions with no return value, are called
'a "Sub" in VB, rather than a "Function", and when you call
'a "Sub" you don't put parentheses around the parameters.


Private Sub CMD2OFF_Click()
    Dim ChannelSelected, stateD, lngErrorcode As Long
    'set channel 2 OFF
    ChannelSelected = 2 '0=IO0 , 1=IO1, 2=IO2, 3=IO3
    stateD = 0
    lngErrorcode = EDigitalOut(-1, 0, ChannelSelected, 0, stateD)
End Sub

Private Sub CMD2ON_Click()
    Dim ChannelSelected, stateD, lngErrorcode As Long
    'set channel 2 ON
    ChannelSelected = 2 '0=IO0 , 1=IO1, 2=IO2, 3=IO3
    stateD = 1
    lngErrorcode = EDigitalOut(-1, 0, ChannelSelected, 0, stateD)
End Sub

Private Sub CMD3OFF_Click()
    Dim ChannelSelected, stateD, lngErrorcode As Long
    'set channel 3 OFF
    ChannelSelected = 3 '0=IO0 , 1=IO1, 2=IO2, 3=IO3
    stateD = 0
    lngErrorcode = EDigitalOut(-1, 0, ChannelSelected, 0, stateD)
End Sub

Private Sub CMD3ON_Click()
    Dim ChannelSelected, stateD, lngErrorcode As Long
    'set channel 3 ON
    ChannelSelected = 3 '0=IO0 , 1=IO1, 2=IO2, 3=IO3
    stateD = 1
    lngErrorcode = EDigitalOut(-1, 0, ChannelSelected, 0, stateD)
End Sub


Private Sub Timer1_Timer()

    Dim lngErrorcode As Long
    Dim strError As String * 50
    Dim overvoltage As Long
    Dim VoltageAI0 As Single
    Dim VoltageAI1 As Single
    Dim ChannelSelected As Long
    Dim stateD As Long
    Dim BarWidth As Single
   
  
    ' read analogue input A0.  Value will be stored in voltageA0
    ChannelSelected = 0
    lngErrorcode = EAnalogIn(-1, 0, ChannelSelected, 0, overvoltage, VoltageAI0)
    ' read analogue input A1.  Value will be stored in voltageA1
    ChannelSelected = 1
    lngErrorcode = EAnalogIn(-1, 0, ChannelSelected, 0, overvoltage, VoltageAI1)
    '++++++++++++++++++++++++++++++++++++++++++

    'decipher error code if any and set appropriate textbox
    GetErrorString lngErrorcode, strError
    LblError.Caption = strError
    
    'Set bargraph displays
    ' max width from properties is 3255. Decided by
    ' drawing the full length of bar then checking the
    ' width property.The code below prevents the
    ' barwidth becomming zero or less
    
    BarWidth = Int((VoltageAI0 / 5) * 3255)
    If BarWidth < 1 Then
            BarA0.Width = 1
        Else
            BarA0.Width = BarWidth
    End If
    
    TXTA0.Text = Str(VoltageAI0) + "   Volts "  'using text box for display
    
    
    BarWidth = Int((VoltageAI1 / 5) * 3255)
    If BarWidth < 1 Then
            BarA1.Width = 1
        Else
            BarA1.Width = BarWidth
    End If
    
    LblA1.Caption = VoltageAI1    'using label for display
    '++++++++++++++++++++++++++++++
    
    'read state of channel 1 and store in stateD
    
    ChannelSelected = 1 ' 0=IO-0 , 1=IO-1, 2=IO-2, 3=IO-3
    
    lngErrorcode = EDigitalIn(-1, 0, ChannelSelected, 0, stateD)
    
    ' display sate of channel 1
    
    If stateD = 0 Then Label6.Caption = "OFF" Else Label6.Caption = "ON"

    '++++++++++++++++++++++++++++++++
     
    'read state of channel 0 and store in stateD
     
    ChannelSelected = 0 ' 0=IO-0 , 1=IO-1, 2=IO-2, 3=IO-3
    
    lngErrorcode = EDigitalIn(-1, 0, ChannelSelected, 0, stateD)
    
    ' display sate of channel 1
    
    If stateD = 0 Then Label2.Caption = "OFF" Else Label2.Caption = "ON"
    
    '+++++++++++++++++++++++++++++++++
    ' if an error occurs when accessing the labjack
    ' it can be displayed using the two lines below
    'GetErrorString lngErrorcode, strError
    'Label7.Caption = strError

End Sub


