#include <ansi_c.h>
#include <cvirte.h>		
#include <userint.h>
#include "labj2.h"
#include "ljackuw.h"

int CheckJack(float *dvers, float *fware, long *idnum);
int PlotData(void);

float dvers, fware;
char mess[100];

long 	channel = 0,
		gain = 0,
		idnum = -1,
		demo = 0,
		overvolt;

int ploton = 1;		
double hLimit = 5.0, lLimit = 0.0;

		

static int panelHandle;

int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "labj2.uir", PANEL)) < 0)
		return -1;
	
	CheckJack(&dvers, &fware, &idnum);
	
	sprintf (mess, "Driver version = %f\n"
	"Firmware version = %f\n"
	"Ljack usb ID = %d\n", dvers, fware, idnum);
	
	MessagePopup("Driver data", mess);
	
	SetAxisScalingMode (panelHandle, PANEL_GRAPH, VAL_LEFT_YAXIS,
							VAL_MANUAL, lLimit, hLimit);
		
	DisplayPanel (panelHandle);              
	
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}

int CVICALLBACK Exit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			QuitUserInterface (0);
			break;
		}
	return 0;
}


int CheckJack(float *dvers, float *fware, long *idnum) {

   int err = 0;
   
   *dvers = GetDriverVersion();     
   *fware = GetFirmwareVersion(idnum);
   
   return err;
}

int CVICALLBACK Plot (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_TIMER_TICK:
		
		if(ploton) PlotData();

			break;
		}
	return 0;
}


int PlotData(void) {

	
	int err = 0;
	float volt;
	double data;
	
	
		
		EAnalogIn(
			&idnum,
			demo,
			channel,
			gain,
			&overvolt,
			&volt );
					
		data = volt;

   PlotStripChartPoint (panelHandle, PANEL_GRAPH, data);
   SetCtrlVal(panelHandle, PANEL_VOLT, data);

   return err;
}

int CVICALLBACK SetChannel (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:

		GetCtrlVal(panelHandle, PANEL_CHANNEL, &channel);

			break;
		}
	return 0;
}

int CVICALLBACK Rescale (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	double dummy;
	
	switch (event)
		{
		case EVENT_COMMIT:

		GetCtrlVal(panelHandle, PANEL_MIN, &lLimit);
		GetCtrlVal(panelHandle, PANEL_MAX, &hLimit);
		
		if(lLimit > hLimit) {dummy = lLimit; lLimit = hLimit; hLimit = dummy;}
		
		SetAxisScalingMode (panelHandle, PANEL_GRAPH, VAL_LEFT_YAXIS,
							VAL_MANUAL, lLimit, hLimit);
		

			break;
		}
	return 0;
}
