/***************************************************************

	Simple Testprogram for Labjack driver functions.
	
Instructions for using the Labjack U12 driver functions with 
NI Labwindows CVI (nowadays part of the NI Measurement Studio).

1. After installing the Labjack U12 device and software you will have the files

	ljackuw.h
	ljackuw.dll

on your computer.

2. Copy ljackuw.h to your working CVI directory (I use for instance D:\cvi). Create a new 
CVI-project save it as e.g. ljack.prj. Create a new source and save it as ljack.c and add
it to the ljack-project. Add also ljackuw.h to the project and open it. Insert the line
	
	#include <windows.h>

into ljackuw.h before the function declarations and save it. This ensures the CVI compiler will
understands "WINAPI". With ljackuw.h open go to the menu item "Options" --> "Generate DLL 
import library". The program will then ask for the location of the ljackuw.dll file and
create a ljackuw.lib file from it (it may show "errors" while creating this but they
are typically of no concern as far as they refer to functions that are not meant
to be exported). Add this new ljackuw.lib to your ljack project. Insert also the line 

	#include "ljackuw.h"

into your source code ljack.c (here ljackuw.h is the one w/ the new line inserted). 
	
3. Now the driver functions listed and explained in the Labjack manual should
be accessible in your project. A very simple test example is provided with the ljack 
project example included. It reads and writes voltages from Ch 0 to the screen. 
For this to work you have to make the ljackuw.lib as explained above and maybe change
the paths of the files in the project.

4. When you got ljack project working you might try ljack2 project w/ a graphical display
of the input from a chosen channel.


Frank Borg (borgbros@netti.fi)	
	
	
	
	
*********************************************************************/	


#include "ljackuw.h"
#include <ansi_c.h>
#include <utility.h>  // needed for KeyHit()

int main() {

	float vers = 0;
	long idnum = -1;
	long channel = 0,
		demo = 0,
		gain = 0,
		overvolt = 0;
	
	float volt;
	

	vers = GetDriverVersion();

	printf("Version = %f\n", vers);
	
	vers = GetFirmwareVersion(&idnum);
	
	printf("Firmware vers = %f\t idnum = %d\n", vers, idnum);
	
	printf("Sampling volts from channel %d  ..... \n", channel);
	
	while(!KeyHit()) {
	
		EAnalogIn(
					&idnum,
					demo,
					channel,
					gain,
					&overvolt,
					&volt );
					
					
		printf("%f\n", volt);			
	}
	
	return 0;

}
