/********************************************************************************************************************************/
// AIStreamClear
// 
// This function stops the continuous acquisition.  It should be called once when finished with the stream.  The sequence of calls 
// for a typical stream operation is: AIStreamStart, AIStreamRead, AIStremRead, AIStreamRead, ...,AIStreamClear.
//
// MATLAB Syntax:
//		[errorcode] = AIStreamClear(localID)
//
// Inputs:
//		localID - Send the local ID from AIStreamStart/Read
//
// Ouputs:
//		errorcode = LabJack error codes or 0 for no error.
//
// 
/********************************************************************************************************************************/

#include "mex.h"
#include "matrix.h"
#include <wtypes.h>
#include "ljackuw.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double  inp1, *out1;
  int i, m, n;
  long idnum, errorcode;

  /* Check for proper number of arguments. */
  if(nrhs != 1) 
  {
    mexErrMsgTxt("Input Error --> (idnum)");
  } 
  else if(nlhs > 1) 
  {
    mexErrMsgTxt("Output Error --> [errorcode]");
  }

  /* Get dimensions of inputs */
  for (i=0;i<=0;i++)
  {
	 m = mxGetM(prhs[i]);
	 n = mxGetN(prhs[i]);
	 
	 if(m*n != 1)
	 {
		 mexErrMsgTxt("Input must to be scalar");
	 }
  }

  /* Retrive Matlab input values from function call. */
  inp1 = mxGetScalar(prhs[0]);

  /* Create matrix for the return arguments. */;
  plhs[0]= mxCreateDoubleMatrix(1,1,mxREAL);

  /* Get pointer to real part of return argument */
  out1 = mxGetPr(plhs[0]);

  /* Recast Matlab inputs */
  idnum = long(inp1);

  /* Call the AIStreamClear function. */
  errorcode = AIStreamClear(idnum);
  
  /* Set Matlab outputs equal to returned LJ values */
  out1[0] = (double)errorcode;

}
