/********************************************************************************************************************************/
// GetErrorString
//
// Converts a LabJack error code, returned by another function, into a string describing the error.
//
// Matlab Syntax:
//		[errorstring] - GetErrorString(errorcode)
//
// Inputs:
//		errorcode - LabJack error code.	
//
// Outputs:
//		errorstring - Character string describing error.
//
/********************************************************************************************************************************/

#include "mex.h"
#include "matrix.h"
#include <wtypes.h>
#include "ljackuw.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double  *out1;
  int i, m, n;
  int dims[2] = {0,0};
  double inp1;
  long errorcode;
  char error_string[50], *strng_out[50];

  /* Check for proper number of arguments. */
  if(nrhs != 1) 
  {
    mexErrMsgTxt("Input Error --> (errorcode)");
  } 
  else if(nlhs > 1) 
  {
    mexErrMsgTxt("Output Error --> [error_string]");
  }

  /* Get dimensions of inputs */
  for (i=0;i<=0;i++)
  {
	 m = mxGetM(prhs[i]);
	 n = mxGetN(prhs[i]);
	 
	 if(m*n != 1)
	 {
		 mexErrMsgTxt("Input must to be scalar");
	 }
  }

  /* Retrive Matlab input values from function call. */
  inp1 = mxGetScalar(prhs[0]);

  /* Recast Matlab inputs */
  errorcode = long(inp1);

  /* Call the GetErrorString function. */
  GetErrorString(errorcode, error_string);
  
  /* Populate array of pointer for mxCreateCharMarixFromStrings */
  for (i=0;i<=49;i++)
	{
		strng_out[i] = &error_string[i];
	}
  
  /* Create matrix for the return arguments. */;
  plhs[0]= mxCreateCharMatrixFromStrings(1, (const char **)strng_out);

}
