/******************************************************************************************************************************/
// ListAll
//
// Searches the USB for all LabJacks, and returns the serial number and local ID for each.
//
//
// MATLAB Syntax:
//		[serialnumList localIDList numberFound errorcode] = ListAll
//
// Input:
//		none
//
// Output:
//		serialnumList - Array where serial numbers are returned.
//		localIDList - Array were local ID numbers are returned. 
//		numberFound - Number of LabJacks found on the USB.
//		fcddMaxSize - Max size of fcdd.
//		hvcMinSize - Max size of hvc.
//		errorcode - Labjack error codes or 0 for no error.
//
//
/********************************************************************************************************************************/

#include "mex.h"
#include <wtypes.h>
#include "ljackuw.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double  *out1,*out2,*out3,*out4,*out5,*out6;
  int i, j, m, n, cnt;
  long productIDList[127] = {0};
  long serialnumList[127] = {0};
  long localIDList[127] = {0};
  long powerList[127] = {0};
  long calMatrix[127][20] = {0};
  long errorcode, fcddMaxSize, hvcMinSize, numberFound;


  /* Check for proper number of arguments. */
  if(nrhs != 0) 
  {
    mexErrMsgTxt("Input Error --> This function does not require inputs");
  } 
  else if(nlhs > 6) 
  {
    mexErrMsgTxt("Output Error --> [serialnumList localIDList numberFound errorcode]");
  }


  /* Call the ListAll function. */
  errorcode = ListAll(productIDList, serialnumList, localIDList, powerList, calMatrix, &numberFound, &fcddMaxSize, &hvcMinSize);
  
  /* Create matrix for the return arguments based upon the number of LabJacks present */
  plhs[0] = mxCreateDoubleMatrix((int)numberFound,1, mxREAL);
  plhs[1] = mxCreateDoubleMatrix((int)numberFound,1, mxREAL);
  plhs[2] = mxCreateDoubleMatrix(1,1, mxREAL);
  plhs[3] = mxCreateDoubleMatrix(1,1, mxREAL);

  /* Get pointer to real part of return argument */
  out1 = mxGetPr(plhs[0]);
  out2 = mxGetPr(plhs[1]);
  out3 = mxGetPr(plhs[2]);
  out4 = mxGetPr(plhs[3]); 
   
  /* Set Matlab outputs equal to returned LJ values */
  for(i=0;i<=(int)numberFound-1;i++)
  {
	 out1[i] = (double)serialnumList[i];
	 out2[i] = (double)localIDList[i];
  }
  
  out3[0] = (double)numberFound;
  out4[0] = (double)errorcode;
}
