/*************************************************************************************************/
// EAnalogOut
//
// Easy function.  This is a simplified version of AOUpdate. Sets the voltage of both analog outputs.  
// Execution time for this function is 50 milliseconds or less.
//
// MATLAB Syntax:
//		[Errorcode Idnum] = EAnlaogOut(Idnum, demo, analogOut0, analogOut1)
//
// Inputs:
//		Idnum - Local Id, serial number, or -1 for first LJ found
//		demo - 0 for normal operation, >0 for demo mode.  Demo mode allows this function to be 
//		called without a LabJack.
//		analogOut0 - Voltage from 0.0 to 5.0 for AO0
//		analogOut1 - Voltage from 0.0 to 5.0 for AO1
//
// Outputs:
//		idnum - Local ID number of Labjack, or -1 if no LabJack is found. 
//		errorcode - LabJack error codes or 0 for no error.
//
// 
/**************************************************************************************************/

#include "mex.h"
#include <wtypes.h>
#include "ljackuw.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double  inp1,inp2,inp3,inp4,inp5,*out1,*out2,*out3,*out4;
  int i, m, n;
  long idnum, demo, errorcode;
  float analogOut0, analogOut1; 

  /* Check for proper number of arguments. */
  if(nrhs != 4) 
  {
    mexErrMsgTxt("Input Error --> (Idnum, demo, channel, gain)");
  } 
  else if(nlhs > 2) 
  {
    mexErrMsgTxt("Output Error --> [Voltage, Idnum, OverVoltage, Errorcode]");
  }

   /* Get dimensions of inputs */
  for (i=0;i<=3;i++)
  {
	 m = mxGetM(prhs[i]);
	 n = mxGetN(prhs[i]);
	 
	 if(m*n != 1)
	 {
		 mexErrMsgTxt("Inputs must to be scalar");
	 }
  }
  
  /* Create matrix for the return arguments. */
  plhs[0] = mxCreateDoubleMatrix(1,1, mxREAL);
  plhs[1] = mxCreateDoubleMatrix(1,1, mxREAL);
  
  /* Retrive Matlab input values from function call. */
  inp1 = mxGetScalar(prhs[0]);
  inp2 = mxGetScalar(prhs[1]);
  inp3 = mxGetScalar(prhs[2]);
  inp4 = mxGetScalar(prhs[3]);

  /* Get pointer to real part of return argument */
  out1 = mxGetPr(plhs[0]);
  out2 = mxGetPr(plhs[1]);
  
  /* Recast Matlab inputs */
  idnum = (long)inp1;
  demo = (long)inp2;
  analogOut0 = (float)inp3;
  analogOut1 = (float)inp4;

  /* Call the EAnalogOut function. */
  errorcode = EAnalogOut(&idnum, demo, analogOut0, analogOut1);
  
  /* Set Matlab outputs equal to returned LJ values */
  out1[0] = (double)idnum;
  out2[0] = (double)errorcode;


}
