/****************************************************************************************/
// GetFirmwareVersion
//
// Retrieves the firmware version from the LabJack's processor.
//
// MATLAB Syntax:
//		[version idnum] = GetFirmwareVersion(idnum)
//
// Inputs:
//		idnum - Local Id, serial number, or -1 for first LJ found
//
// Outputs:
//		version - Version number of the LabJack firmware or 0 for error.
//		idnum - Local ID, serial number, or -1 for first found.
// 
/****************************************************************************************/
#include "mex.h"
#include <wtypes.h>
#include "ljackuw.h"



void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double  inp1, *out1, *out2;
  float version;
  long idnum;
  int m, n;
  
  /* Get dimensions of inputs */
	 m = mxGetM(prhs[0]);
	 n = mxGetN(prhs[0]);

	 if(m*n != 1)
	 {
		 mexErrMsgTxt("Inputs must to be scalar");
	 }

  /* Check for proper number of arguments. */
  if(nrhs != 1) 
  {
    mexErrMsgTxt("Input Error --> (Idnum)");
  } 
  else if(nlhs > 2) 
  {
    mexErrMsgTxt("Output Error --> [Firmware Version Number]");
  }
  
  /* Retrive Matlab input values from function call. */
  inp1 = mxGetScalar(prhs[0]);

  /* Create matrix for the return arguments. */
  plhs[0] = mxCreateDoubleMatrix(1,1, mxREAL);
  plhs[1] = mxCreateDoubleMatrix(1,1, mxREAL);
  
  /* Assign pointers to each input and output. */
  inp1 = mxGetScalar(prhs[0]);
  
  /* Get pointer to real part of return argument */
  out1 = mxGetPr(plhs[0]);
  out2 = mxGetPr(plhs[1]);


  /* Recast Matlab input */
  idnum = (long)inp1;

  /* Call the GetFirmwareVersion function. */
  version = GetFirmwareVersion(&idnum);

  /* Set Matlab outputs equal to returned LJ values */
  out1[0] = (double)version;
  out2[0] = (double)idnum;

}
