/********************************************************************************************************************************/
// GetWinVersion
//
// Uses a Windows API function to get the OS version
//
// Matlab Syntax ->  [majorVersion minorVersion buildNumber platformID servicePackMajor servicePackMinor errorcode] = GetWinVersion
//
//		Input:
//			none	
//
//		Output:
//								Platform	Major	Minor	Build
//			Windows 3.1			0			-		-		-
//			Windows 95			1			4		0		950
//			Windows 95 OSRS		1			4		0		1111
//			Windows 98			1			4		10		1998
//			Windows 98 SE		1			4		10		2222
//			Windows ME			1			4		90		3000
//			Windows NT4 3.51	2			3		51		-
//			Windows NT 4.0		2			4		0		1381
//			Windows 2000		2			5		0		2195
//			Whistler			2			5		1		-
//
//			errorcode - LabJack error codes or 0 for no error.
// 
/********************************************************************************************************************************/

#include "mex.h"
#include <wtypes.h>
#include "ljackuw.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double  *out1,*out2,*out3,*out4,*out5,*out6,*out7;
  int i, m, n;
  unsigned long errorcode, majorVersion, minorVersion, buildNumber, platformID, servicePackMajor, servicePackMinor;

  /* Check for proper number of arguments. */
  if(nrhs != 0) 
  {
    mexErrMsgTxt("Input Error --> This function does not require inputs");
  } 
  else if(nlhs > 7) 
  {
    mexErrMsgTxt("Output Error --> [majorVersion minorVersion buildNumber platformID servicePackMajor servicePackMinor errorcode]");
  }

  /* Create matrix for the return arguments. */;
  plhs[0]= mxCreateDoubleMatrix(1,1,mxREAL);
  plhs[1]= mxCreateDoubleMatrix(1,1,mxREAL);
  plhs[2]= mxCreateDoubleMatrix(1,1,mxREAL);
  plhs[3]= mxCreateDoubleMatrix(1,1,mxREAL);
  plhs[4]= mxCreateDoubleMatrix(1,1,mxREAL);
  plhs[5]= mxCreateDoubleMatrix(1,1,mxREAL);
  plhs[6]= mxCreateDoubleMatrix(1,1,mxREAL);

  /* Get pointer to real part of return argument */
  out1 = mxGetPr(plhs[0]);
  out2 = mxGetPr(plhs[1]);
  out3 = mxGetPr(plhs[2]);
  out4 = mxGetPr(plhs[3]);
  out5 = mxGetPr(plhs[4]);
  out6 = mxGetPr(plhs[5]);
  out7 = mxGetPr(plhs[6]);

  /* Call the GetWinVersion function. */
  errorcode = GetWinVersion(&majorVersion, &minorVersion, &buildNumber, &platformID, &servicePackMajor, &servicePackMinor);
  
  /* Set Matlab outputs equal to returned LJ values */
  out1[0] = (double)majorVersion;
  out2[0] = (double)minorVersion;
  out3[0] = (double)buildNumber;
  out4[0] = (double)platformID;
  out5[0] = (double)servicePackMajor;
  out6[0] = (double)servicePackMinor;
  out7[0] = (double)errorcode;


}
