/******************************************************************************************************************************/
// PulseOutCalc:
//
//				This function can be used to calculate the cycle times
//				for PulseOut or PulseOutStart.
//
//MATLAB Syntax:
//		[errorcode frequency timeB timeC] = PulseOutCalc(frequency, timeB, timeC)
//
//	Returns:	LabJack errorcodes or 0 for no error (I32).
//	Inputs:		*frequency	-Desired frequency in Hz (SGL).
//	Outputs:	*frequency	-Actual best frequency found in Hz (SGL).
//				*timeB		-B value for first and second half cycle (I32).
//				*timeC		-C value for first and second half cycle (I32).
//		
/********************************************************************************************************************************/

#include "mex.h"
#include <wtypes.h>
#include "ljackuw.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double  inp1,*inp2,*inp3;
  double  *out1,*out2,*out3,*out4;
  int i, m, n;
  long  timeB, timeC, errorcode;
  float frequency;

  /* Check for proper number of arguments. */
  if(nrhs != 3) 
  {
    mexErrMsgTxt("Input Error --> (frequency, timeB, timeC)");
  } 
  else if(nlhs > 4) 
  {
    mexErrMsgTxt("Output Error --> [errorcode frequency timeB timeC]");
  }

  /* Get dimensions of inputs */
  for (i=0;i<3;i++)
  {
	 m = mxGetM(prhs[i]);
	 n = mxGetN(prhs[i]);
	 
	 if(m*n != 1)
	 {
		 mexErrMsgTxt("Inputs must be scalar:");
	 }
  }
	
  /* Retrive Matlab input values from function call. */
  inp1 = mxGetScalar(prhs[0]);
  inp2 = mxGetPr(prhs[1]);
  inp3 = mxGetPr(prhs[2]);

  /* Create matrix for the return arguments. */
  plhs[0] = mxCreateDoubleMatrix(1,1, mxREAL);
  plhs[1] = mxCreateDoubleMatrix(1,1, mxREAL);
  plhs[2] = mxCreateDoubleMatrix(1,1, mxREAL);
  plhs[3] = mxCreateDoubleMatrix(1,1, mxREAL);

  /* Get pointer to real part of return argument */
  out1 = mxGetPr(plhs[0]);
  out2 = mxGetPr(plhs[1]);
  out3 = mxGetPr(plhs[2]);
  out4 = mxGetPr(plhs[3]);

  /* Recast Matlab inputs */
  frequency = (float)inp1;
  timeB = (long)inp2;
  timeC = (long)inp3;

  /* Call the PulseOutCalc function. */
 errorcode = PulseOutCalc(&frequency, &timeB, &timeC);

  /* Matlab outputs equal to returned LJ values */

	  out1[0] = (double)errorcode;
	  out2[0] = (double)frequency;	
	  out3[0] = (long)timeB;
	  out4[0] = (long)timeC;
}
