/******************************************************************************************************************************/
// SHTCRC:		Checks the CRC on a SHT1X communication.  Last byte of
//				datarx is the CRC.  Returns 0 if CRC is good, or
//				SHT1X_CRC_ERROR_LJ if CRC is bad.

//MATLAB Syntax:
//		[errorcode] = SHTCRC(statusReg, numWrite, numRead, datatx, datarx)
//  
//  Returns:	Labjack errorcodes or 0 for no error (I32).
//
//	Inputs:		statusReg	-Current value of the SHT1X status register.
//				numWrite	-Number of bytes that were written (0-4).
//				numRead		-Number of bytes that were read (1-4).
//				*datatx		-Array of 0-4 bytes that were sent.
//				*datarx		-Array of 1-4 bytes that were read.
//
/********************************************************************************************************************************/

#include "mex.h"
#include <wtypes.h>
#include "ljackuw.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  double  inp1,inp2,inp3,*inp4,*inp5;
  double  *out1;
  int i, m, n;
  long  statusReg, numWrite, numRead, errorcode;
  unsigned char datatx[4] = {0};
  unsigned char datarx[4] = {0};

  /* Check for proper number of arguments. */
  if(nrhs != 5) 
  {
    mexErrMsgTxt("Input Error --> (statusReg, numWrite, numRead, datatx, datarx)");
  } 
  else if(nlhs > 1) 
  {
    mexErrMsgTxt("Output Error --> [errorcode]");
  }

  /* Get dimensions of inputs */
  for (i=0;i<3;i++)
  {
	 m = mxGetM(prhs[i]);
	 n = mxGetN(prhs[i]);
	 
	 if(m*n != 1)
	 {
		 mexErrMsgTxt("Inputs must be scalar:");
	 }
  }
	
  /* Retrive Matlab input values from function call. */
  inp1 = mxGetScalar(prhs[0]);
  inp2 = mxGetScalar(prhs[1]);
  inp3 = mxGetScalar(prhs[2]);
  inp4 = mxGetPr(prhs[3]);
  inp5 = mxGetPr(prhs[4]);

  /* Create matrix for the return arguments. */
  plhs[0] = mxCreateDoubleMatrix(1,1, mxREAL);

  /* Get pointer to real part of return argument */
  out1 = mxGetPr(plhs[0]);

  /* Recast Matlab inputs */
  statusReg = (long)inp1;
  numWrite = (long)inp2;
  numRead = (long)inp3;

  /* Make sure no more than 4 bytes are read/written */
  if (numWrite > 4 || numRead >4)
	{
		mexErrMsgTxt("Can only read / write 4 bytes.");
	}

  for(i=0;i<inp2;i++)
	{
		datatx[i] = (long)*inp4;	//Fill data array
		inp4++;						//Increment pointer to data array from Matlab
	}
  for(i=0;i<inp3;i++)
	{
		datarx[i] = (long)*inp5;	//Fill data array
		inp5++;						//Increment pointer to data array from Matlab
	}



  /* Call the SHTCRC function. */
 errorcode = SHTCRC(statusReg, numWrite, numRead, datatx, datarx);

  /* Matlab outputs equal to returned LJ values */

	  out1[0] = (double)errorcode;

}
