VERSION 5.00
Object = "{E46BCC02-8469-11D5-B00B-00008654A834}#1.0#0"; "ljackuwx.ocx"
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Begin VB.Form Form1 
   Caption         =   "LabJack U12 VB Example"
   ClientHeight    =   8055
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8730
   LinkTopic       =   "Form1"
   ScaleHeight     =   8055
   ScaleWidth      =   8730
   StartUpPosition =   3  'Windows Default
   Begin MSFlexGridLib.MSFlexGrid MSFlexGrid1 
      Height          =   3495
      Left            =   2760
      TabIndex        =   22
      Top             =   4200
      Width           =   5175
      _ExtentX        =   9128
      _ExtentY        =   6165
      _Version        =   393216
      Rows            =   4097
      Cols            =   5
      FixedCols       =   0
   End
   Begin VB.TextBox txtNumScans 
      Height          =   285
      Left            =   1320
      TabIndex        =   20
      Text            =   "1024"
      Top             =   3000
      Width           =   855
   End
   Begin VB.TextBox txtScanRate 
      Height          =   285
      Left            =   120
      TabIndex        =   18
      Text            =   "2048"
      Top             =   3000
      Width           =   855
   End
   Begin VB.TextBox txtStateIO 
      BackColor       =   &H8000000B&
      Height          =   495
      Left            =   2640
      TabIndex        =   16
      Top             =   1920
      Width           =   5415
   End
   Begin VB.CommandButton cmdBurst 
      Caption         =   "Do Burst"
      Height          =   495
      Left            =   120
      TabIndex        =   15
      Top             =   3600
      Width           =   1215
   End
   Begin VB.ComboBox cboGainD 
      Height          =   315
      ItemData        =   "main.frx":0000
      Left            =   1320
      List            =   "main.frx":001C
      Style           =   2  'Dropdown List
      TabIndex        =   14
      Top             =   2160
      Width           =   735
   End
   Begin VB.ComboBox cboGainC 
      Height          =   315
      ItemData        =   "main.frx":003B
      Left            =   1320
      List            =   "main.frx":0057
      Style           =   2  'Dropdown List
      TabIndex        =   13
      Top             =   1560
      Width           =   735
   End
   Begin VB.ComboBox cboGainB 
      Height          =   315
      ItemData        =   "main.frx":0076
      Left            =   1320
      List            =   "main.frx":0092
      Style           =   2  'Dropdown List
      TabIndex        =   12
      Top             =   960
      Width           =   735
   End
   Begin VB.ComboBox cboGainA 
      Height          =   315
      ItemData        =   "main.frx":00B1
      Left            =   1320
      List            =   "main.frx":00CD
      Style           =   2  'Dropdown List
      TabIndex        =   9
      Top             =   360
      Width           =   735
   End
   Begin VB.ComboBox cboChannelD 
      Height          =   315
      ItemData        =   "main.frx":00EC
      Left            =   120
      List            =   "main.frx":0114
      Style           =   2  'Dropdown List
      TabIndex        =   8
      Top             =   2160
      Width           =   1095
   End
   Begin VB.ComboBox cboChannelC 
      Height          =   315
      ItemData        =   "main.frx":0170
      Left            =   120
      List            =   "main.frx":0198
      Style           =   2  'Dropdown List
      TabIndex        =   7
      Top             =   1560
      Width           =   1095
   End
   Begin VB.ComboBox cboChannelB 
      Height          =   315
      ItemData        =   "main.frx":01F4
      Left            =   120
      List            =   "main.frx":021C
      Style           =   2  'Dropdown List
      TabIndex        =   6
      Top             =   960
      Width           =   1095
   End
   Begin VB.ComboBox cboChannelA 
      Height          =   315
      ItemData        =   "main.frx":0278
      Left            =   120
      List            =   "main.frx":02A0
      Style           =   2  'Dropdown List
      TabIndex        =   5
      Top             =   360
      Width           =   1095
   End
   Begin VB.TextBox txtError 
      BackColor       =   &H8000000B&
      Height          =   495
      Left            =   3120
      TabIndex        =   3
      Top             =   2880
      Width           =   3615
   End
   Begin LJACKUWXLib.Ljackuwx Ljackuwx1 
      Height          =   735
      Left            =   0
      TabIndex        =   2
      Top             =   4440
      Visible         =   0   'False
      Width           =   1575
      _Version        =   65536
      _ExtentX        =   2778
      _ExtentY        =   1296
      _StockProps     =   0
   End
   Begin VB.TextBox txtBurstData 
      BackColor       =   &H8000000B&
      Height          =   1095
      Left            =   2640
      TabIndex        =   0
      Top             =   360
      Width           =   5415
   End
   Begin VB.Label Label4 
      Caption         =   "Readings"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   375
      Left            =   4440
      TabIndex        =   23
      Top             =   3840
      Width           =   1455
   End
   Begin VB.Label Label3 
      Caption         =   "Number of Scans"
      Height          =   495
      Left            =   1320
      TabIndex        =   21
      Top             =   2760
      Width           =   1455
   End
   Begin VB.Label Label2 
      Caption         =   "Scan Rate"
      Height          =   495
      Left            =   120
      TabIndex        =   19
      Top             =   2760
      Width           =   1215
   End
   Begin VB.Label Label1 
      Caption         =   "StateIO String"
      Height          =   495
      Left            =   2640
      TabIndex        =   17
      Top             =   1680
      Width           =   1215
   End
   Begin VB.Label lblGain 
      Caption         =   "Gain"
      Height          =   495
      Left            =   1320
      TabIndex        =   11
      Top             =   120
      Width           =   735
   End
   Begin VB.Label lblChannel 
      Caption         =   "Channel"
      Height          =   495
      Left            =   120
      TabIndex        =   10
      Top             =   120
      Width           =   1095
   End
   Begin VB.Label LabelAIError 
      Caption         =   "AIBurst Error Message"
      Height          =   495
      Left            =   3120
      TabIndex        =   4
      Top             =   2640
      Width           =   2175
   End
   Begin VB.Label LabelAOError 
      Caption         =   "AIBurst Data String"
      Height          =   495
      Left            =   2640
      TabIndex        =   1
      Top             =   120
      Width           =   2175
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False


Private Sub cmdBurst_Click()

    Dim lngErrorcode As Long
    Dim lngIDNum As Long
    Dim lngOV As Long
    Dim lngCP As Long
    Dim lngGP As Long
    Dim sngScanRate As Single
    Dim lngNumScans As Long
    Dim strBurstData As String
    Dim strStateIO As String
        
    'new stuff...............
    Dim voltages(4096, 4) As Single
    Dim portData(4096) As Long
    Dim numChans As Long
    ' end of new stuff
    
    lngIDNum = -1
    numChans = 4 'new
    
    sngScanRate = Val(txtScanRate)
    lngNumScans = Val(txtNumScans)
    lngCP = Ljackuwx1.FourPack(cboChannelA.ListIndex, cboChannelB.ListIndex, cboChannelC.ListIndex, cboChannelD.ListIndex)
    lngGP = Ljackuwx1.FourPack(cboGainA.ListIndex, cboGainB.ListIndex, cboGainC.ListIndex, cboGainD.ListIndex)
    'note "4" replaced by numChans in next line
    lngErrorcode = Ljackuwx1.AIBurstX(lngIDNum, numChans, lngCP, lngGP, sngScanRate, 0, 0, lngNumScans, 1, strBurstData, strStateIO, lngOV, 2)
    txtError = Ljackuwx1.GetErrorStringX(lngErrorcode)
    txtBurstData = strBurstData
    txtStateIO = strStateIO
    
' NEW STUFF VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV

    'parse the Voltage string
    For ns = 0 To lngNumScans - 1
      For nc = 0 To numChans - 1
        volts$ = Mid$(strBurstData, (ns * 13 * numChans) + (nc * 13) + 1, 13)
        'strip leading zeros
        While Left$(volts$, 1) = "0"
          volts$ = Right$(volts$, Len(volts$) - 1)
        Wend
        'store it in array
        voltages(ns, nc) = Val(volts$)
      Next nc
    Next ns
        
    'parse the Digital string
    For s = 0 To 4095
      Port$ = Mid$(strStateIO, s * 10 + 1, 10)
      'strip leading zeros
      While Left(Port$, 1) = "0"
          Port$ = Right(Port$, Len(Port$) - 1)
      Wend
       'store in array
       portData(s) = Val(Port$)
    Next s
  
  
  'display the Analog Readings in a FlexGrid
  'NOTE if you don't have the FlexGrid OCX loaded this won't work!
  
  'set header row
  MSFlexGrid1.Row = 0
  For c = 0 To 3
    MSFlexGrid1.Col = c
    MSFlexGrid1.Text = "A" & c
  Next c
    
  'display the readings
  For r = 0 To lngNumScans - 1
    For c = 0 To numChans - 1
      MSFlexGrid1.Row = r + 1
      MSFlexGrid1.Col = c
      MSFlexGrid1.Text = Str$(voltages(r, c))
    Next c
  Next r
  
      
    'now display the Digital Readings in the grid
    MSFlexGrid1.Row = 0
    MSFlexGrid1.Col = 4
    MSFlexGrid1.Text = "Digital"
    For r = 0 To 4095
      MSFlexGrid1.Row = r + 1
      MSFlexGrid1.Text = Str$(portData(r))
    Next r
    
' END OF NEW STUFF VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV

End Sub

Private Sub Form_Load()
    cboChannelA.ListIndex = 0
    cboChannelB.ListIndex = 1
    cboChannelC.ListIndex = 2
    cboChannelD.ListIndex = 3
    cboGainA.ListIndex = 0
    cboGainB.ListIndex = 0
    cboGainC.ListIndex = 0
    cboGainD.ListIndex = 0
End Sub



