VERSION 5.00
Object = "{E46BCC02-8469-11D5-B00B-00008654A834}#1.0#0"; "ljackuwx.ocx"
Begin VB.Form Form1 
   Caption         =   "LabJack U12 VB Example"
   ClientHeight    =   4890
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8625
   LinkTopic       =   "Form1"
   ScaleHeight     =   4890
   ScaleWidth      =   8625
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtVoltsA 
      Height          =   285
      Left            =   2640
      TabIndex        =   9
      Text            =   "0.00"
      Top             =   2280
      Width           =   975
   End
   Begin VB.TextBox txtVoltsB 
      Height          =   285
      Left            =   4560
      TabIndex        =   8
      Text            =   "0.00"
      Top             =   2280
      Width           =   975
   End
   Begin VB.TextBox txtError 
      BackColor       =   &H8000000B&
      Height          =   495
      Left            =   2640
      TabIndex        =   7
      Top             =   4080
      Width           =   5415
   End
   Begin LJACKUWXLib.Ljackuwx Ljackuwx1 
      Height          =   735
      Left            =   240
      TabIndex        =   6
      Top             =   2280
      Width           =   1575
      _Version        =   65536
      _ExtentX        =   2778
      _ExtentY        =   1296
      _StockProps     =   0
   End
   Begin VB.TextBox txtStateIO 
      BackColor       =   &H8000000B&
      Height          =   495
      Left            =   2640
      TabIndex        =   4
      Top             =   3120
      Width           =   5415
   End
   Begin VB.CommandButton cmdStream 
      Caption         =   "Start Stream"
      Height          =   495
      Left            =   240
      TabIndex        =   3
      Top             =   840
      Width           =   1215
   End
   Begin VB.TextBox txtStreamData 
      BackColor       =   &H8000000B&
      Height          =   1095
      Left            =   2640
      TabIndex        =   0
      Top             =   360
      Width           =   5415
   End
   Begin VB.Label Label2 
      Caption         =   "First samples from each stream read displayed here:"
      Height          =   255
      Left            =   2640
      TabIndex        =   12
      Top             =   1680
      Width           =   3735
   End
   Begin VB.Label LabelAO0 
      Caption         =   "Channel A Voltage"
      Height          =   495
      Left            =   2640
      TabIndex        =   11
      Top             =   2040
      Width           =   1455
   End
   Begin VB.Label Label3 
      Caption         =   "Channel B Voltage"
      Height          =   495
      Left            =   4560
      TabIndex        =   10
      Top             =   2040
      Width           =   1575
   End
   Begin VB.Label Label1 
      Caption         =   "StateIO String"
      Height          =   495
      Left            =   2640
      TabIndex        =   5
      Top             =   2880
      Width           =   1215
   End
   Begin VB.Label LabelAIError 
      Caption         =   "Error Message"
      Height          =   495
      Index           =   0
      Left            =   2640
      TabIndex        =   2
      Top             =   3840
      Width           =   2175
   End
   Begin VB.Label LabelAOError 
      Caption         =   "Data String"
      Height          =   495
      Left            =   2640
      TabIndex        =   1
      Top             =   120
      Width           =   2175
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False


Private Sub cmdStream_Click()

    Dim lngErrorcode As Long
    Dim lngIDNum As Long
    Dim lngNumChannels As Long
    Dim lngOV As Long
    Dim lngBacklog As Long
    Dim lngCP As Long
    Dim lngGP As Long
    Dim sngScanRate As Single
    Dim lngNumScans As Long
    Dim lngNumReads As Long
    Dim strStreamData As String
    Dim strStateIO As String
    Dim intLoopIndex As Integer
    Dim arrayVoltages(4096, 4) As Single
    Dim arrayIOStates(4096) As Long
            
    lngIDNum = -1

    lngNumChannels = 2
    sngScanRate = 256
    lngNumScans = 128
    lngNumReads = 5
    
    'Single ended channel AI2 and differential channel #8 (AI0-AI1)
    lngCP = Ljackuwx1.FourPack(2, 8, 0, 0)
    'Gain index of 2 on differential channel for G=4 and +/-5 volt range.
    lngGP = Ljackuwx1.FourPack(0, 2, 0, 0)
    lngOptionBits = Ljackuwx1.BuildOptionBits(0, 1, 0, 0, 0, 0)
    lngErrorcode = Ljackuwx1.AIStreamStartX(lngIDNum, lngNumChannels, lngCP, lngGP, sngScanRate, lngOptionBits, 0)
    For intLoopIndex = 1 To lngNumReads
        If lngErrorcode = 0 Then
            lngErrorcode = Ljackuwx1.AIStreamReadX(lngIDNum, lngNumScans, 3, strStreamData, strStateIO, lngBacklog, lngOV)
            txtStreamData = strStreamData
            txtStateIO = strStateIO
            
            'Parse the Voltage string
            For ns = 0 To lngNumScans - 1
              For nc = 0 To lngNumChannels - 1
                volts$ = Mid$(strStreamData, (ns * 13 * lngNumChannels) + (nc * 13) + 1, 13)
                'strip leading zeros
                While Left$(volts$, 1) = "0"
                  volts$ = Right$(volts$, Len(volts$) - 1)
                Wend
                'store it in array
                arrayVoltages(ns, nc) = Val(volts$)
              Next nc
            Next ns
                
            'Display the first row of data from the array.
            txtVoltsA = Str(arrayVoltages(0, 0))
            txtVoltsB = Str(arrayVoltages(0, 1))
                
            'parse the Digital string
            For s = 0 To 4095
              Port$ = Mid$(strStateIO, s * 10 + 1, 10)
              'strip leading zeros
              While Left(Port$, 1) = "0"
                  Port$ = Right(Port$, Len(Port$) - 1)
              Wend
               'store in array
               arrayIOStates(s) = Val(Port$)
            Next s
            
            'This next statement releases the processor so it will
            'update the indicators on the screen.
            DoEvents
            
            'The next statements empty the string buffers.  Without
            'these you will eat up all memory in Windows until
            'it complains and gives up or crashes.
            strStreamData = ""
            strStateIO = ""

        End If
    Next intLoopIndex
    If lngErrorcode = 0 Then
        lngErrorcode = Ljackuwx1.AIStreamClearX(lngIDNum)
    Else: Ljackuwx1.AIStreamClearX (lngIDNum)
    End If
    txtError = Ljackuwx1.GetErrorStringX(lngErrorcode)

End Sub

