VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "LabJack U12 VB Example (DLL)"
   ClientHeight    =   4110
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8430
   LinkTopic       =   "Form1"
   ScaleHeight     =   4110
   ScaleWidth      =   8430
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox chkLED 
      Caption         =   "Status LED"
      Height          =   495
      Left            =   4680
      TabIndex        =   41
      Top             =   0
      Value           =   1  'Checked
      Width           =   1575
   End
   Begin VB.ComboBox cboGainD 
      Height          =   315
      ItemData        =   "main.frx":0000
      Left            =   5880
      List            =   "main.frx":001C
      Style           =   2  'Dropdown List
      TabIndex        =   40
      Top             =   2640
      Width           =   735
   End
   Begin VB.ComboBox cboGainC 
      Height          =   315
      ItemData        =   "main.frx":003B
      Left            =   5880
      List            =   "main.frx":0057
      Style           =   2  'Dropdown List
      TabIndex        =   39
      Top             =   2040
      Width           =   735
   End
   Begin VB.ComboBox cboGainB 
      Height          =   315
      ItemData        =   "main.frx":0076
      Left            =   5880
      List            =   "main.frx":0092
      Style           =   2  'Dropdown List
      TabIndex        =   38
      Top             =   1440
      Width           =   735
   End
   Begin VB.ComboBox cboGainA 
      Height          =   315
      ItemData        =   "main.frx":00B1
      Left            =   5880
      List            =   "main.frx":00CD
      Style           =   2  'Dropdown List
      TabIndex        =   35
      Top             =   840
      Width           =   735
   End
   Begin VB.ComboBox cboChannelD 
      Height          =   315
      ItemData        =   "main.frx":00EC
      Left            =   4680
      List            =   "main.frx":0114
      Style           =   2  'Dropdown List
      TabIndex        =   34
      Top             =   2640
      Width           =   1095
   End
   Begin VB.ComboBox cboChannelC 
      Height          =   315
      ItemData        =   "main.frx":0170
      Left            =   4680
      List            =   "main.frx":0198
      Style           =   2  'Dropdown List
      TabIndex        =   33
      Top             =   2040
      Width           =   1095
   End
   Begin VB.ComboBox cboChannelB 
      Height          =   315
      ItemData        =   "main.frx":01F4
      Left            =   4680
      List            =   "main.frx":021C
      Style           =   2  'Dropdown List
      TabIndex        =   32
      Top             =   1440
      Width           =   1095
   End
   Begin VB.ComboBox cboChannelA 
      Height          =   315
      ItemData        =   "main.frx":0278
      Left            =   4680
      List            =   "main.frx":02A0
      Style           =   2  'Dropdown List
      TabIndex        =   31
      Top             =   840
      Width           =   1095
   End
   Begin VB.TextBox txtAIError 
      BackColor       =   &H8000000B&
      Height          =   495
      Left            =   4680
      TabIndex        =   29
      Top             =   3360
      Width           =   3615
   End
   Begin VB.TextBox txtVoltsA 
      Height          =   285
      Left            =   6840
      TabIndex        =   24
      Top             =   840
      Width           =   975
   End
   Begin VB.TextBox txtVoltsB 
      Height          =   285
      Left            =   6840
      TabIndex        =   23
      Top             =   1440
      Width           =   975
   End
   Begin VB.TextBox txtVoltsC 
      Height          =   285
      Left            =   6840
      TabIndex        =   22
      Top             =   2040
      Width           =   975
   End
   Begin VB.TextBox txtVoltsD 
      Height          =   285
      Left            =   6840
      TabIndex        =   21
      Top             =   2640
      Width           =   975
   End
   Begin VB.CheckBox chkSet2 
      Caption         =   "Set IO2"
      Height          =   495
      Left            =   1920
      TabIndex        =   20
      Top             =   2160
      Width           =   975
   End
   Begin VB.CheckBox chkSet3 
      Caption         =   "Set IO3"
      Height          =   495
      Left            =   1920
      TabIndex        =   19
      Top             =   2520
      Width           =   975
   End
   Begin VB.CheckBox chkTris2 
      Caption         =   "IO2 Output/(Input)"
      Height          =   495
      Left            =   120
      TabIndex        =   18
      Top             =   2160
      Width           =   1815
   End
   Begin VB.CheckBox chkTris3 
      Caption         =   "IO3 Output/(Input)"
      Height          =   495
      Left            =   120
      TabIndex        =   17
      Top             =   2520
      Width           =   1815
   End
   Begin VB.CheckBox chkRead2 
      Caption         =   "IO2 Read"
      Height          =   495
      Left            =   3000
      TabIndex        =   16
      Top             =   2160
      Width           =   1215
   End
   Begin VB.CheckBox chkRead3 
      Caption         =   "IO3 Read"
      Height          =   495
      Left            =   3000
      TabIndex        =   15
      Top             =   2520
      Width           =   1215
   End
   Begin VB.CheckBox chkRead1 
      Caption         =   "IO1 Read"
      Height          =   495
      Left            =   3000
      TabIndex        =   14
      Top             =   1800
      Width           =   1215
   End
   Begin VB.CheckBox chkRead0 
      Caption         =   "IO0 Read"
      Height          =   495
      Left            =   3000
      TabIndex        =   13
      Top             =   1440
      Width           =   1215
   End
   Begin VB.CheckBox chkTris1 
      Caption         =   "IO1 Output/(Input)"
      Height          =   495
      Left            =   120
      TabIndex        =   12
      Top             =   1800
      Width           =   1815
   End
   Begin VB.CheckBox chkTris0 
      Caption         =   "IO0 Output/(Input)"
      Height          =   495
      Left            =   120
      TabIndex        =   11
      Top             =   1440
      Width           =   1815
   End
   Begin VB.CheckBox chkResetCount 
      Caption         =   "Reset Counter"
      Height          =   495
      Left            =   2280
      TabIndex        =   10
      Top             =   720
      Width           =   1575
   End
   Begin VB.CheckBox chkSet1 
      Caption         =   "Set IO1"
      Height          =   495
      Left            =   1920
      TabIndex        =   9
      Top             =   1800
      Width           =   975
   End
   Begin VB.CheckBox chkSet0 
      Caption         =   "Set IO0"
      Height          =   495
      Left            =   1920
      TabIndex        =   8
      Top             =   1440
      Width           =   975
   End
   Begin VB.TextBox txtCount 
      Height          =   285
      Left            =   2280
      TabIndex        =   6
      Top             =   360
      Width           =   1695
   End
   Begin VB.TextBox txtAO1 
      Height          =   285
      Left            =   120
      TabIndex        =   4
      Text            =   "0.00"
      Top             =   960
      Width           =   975
   End
   Begin VB.TextBox txtAOError 
      BackColor       =   &H8000000B&
      Height          =   495
      Left            =   120
      TabIndex        =   1
      Top             =   3360
      Width           =   3615
   End
   Begin VB.Timer Timer1 
      Interval        =   200
      Left            =   3960
      Top             =   3360
   End
   Begin VB.TextBox txtAO0 
      Height          =   285
      Left            =   120
      TabIndex        =   0
      Text            =   "0.00"
      Top             =   360
      Width           =   975
   End
   Begin VB.Label lblGain 
      Caption         =   "Gain"
      Height          =   495
      Left            =   5880
      TabIndex        =   37
      Top             =   600
      Width           =   735
   End
   Begin VB.Label lblChannel 
      Caption         =   "Channel"
      Height          =   495
      Left            =   4680
      TabIndex        =   36
      Top             =   600
      Width           =   1095
   End
   Begin VB.Label LabelAIError 
      Caption         =   "AISample Error Message"
      Height          =   495
      Left            =   4680
      TabIndex        =   30
      Top             =   3120
      Width           =   2175
   End
   Begin VB.Label LabelAIA 
      Caption         =   "Voltage A"
      Height          =   495
      Left            =   6840
      TabIndex        =   28
      Top             =   600
      Width           =   1215
   End
   Begin VB.Label LabelAIB 
      Caption         =   "Voltage B"
      Height          =   495
      Left            =   6840
      TabIndex        =   27
      Top             =   1200
      Width           =   1215
   End
   Begin VB.Label LabelAIC 
      Caption         =   "Voltage C"
      Height          =   495
      Left            =   6840
      TabIndex        =   26
      Top             =   1800
      Width           =   1215
   End
   Begin VB.Label LabelAID 
      Caption         =   "Voltage D"
      Height          =   495
      Left            =   6840
      TabIndex        =   25
      Top             =   2400
      Width           =   1215
   End
   Begin VB.Label LabelCount 
      Caption         =   "Count"
      Height          =   495
      Left            =   2280
      TabIndex        =   7
      Top             =   120
      Width           =   1215
   End
   Begin VB.Label Label3 
      Caption         =   "AO1 Voltage"
      Height          =   495
      Left            =   120
      TabIndex        =   5
      Top             =   720
      Width           =   1215
   End
   Begin VB.Label LabelAOError 
      Caption         =   "AOUpdate Error Message"
      Height          =   495
      Left            =   120
      TabIndex        =   3
      Top             =   3120
      Width           =   2175
   End
   Begin VB.Label LabelAO0 
      Caption         =   "AO0 Voltage"
      Height          =   495
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   1215
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This example calls AOUpdate, AISample, and GetErrorString,
'directly from the LabJack U12 DLL, rather than using the
'ActiveX control.  This method is not recommended.  Rather,
'we recommed VB6 users call functions from the ActiveX OCX
'as demonstrated in the other examples.

'If you have installed the LabJack software distribution
'or drivers_only, ljackuw.dll should have been put in
'your system directory, where VB will be able to find it.

Private Declare Function AOUpdate Lib "ljackuw.dll" _
    (ByRef lpIDNum As Long, _
    ByVal lngDemo As Long, _
    ByVal lngTrisD As Long, _
    ByVal lngTrisIO As Long, _
    ByRef lpStateD As Long, _
    ByRef lpStateIO As Long, _
    ByVal lngUpdateDigital As Long, _
    ByVal lngResetCounter As Long, _
    ByRef lngCount As Long, _
    ByVal sngAnalogOut0 As Single, _
    ByVal sngAnalogOut1 As Single) As Long
'Note that Count is actually an unsigned long (0-4294967295), but
'VB does not have a ULong so we define it as a Long.  This means
'that if the value of Count is over 31 bits (2147483648), it will
'become a negative number (2's complement).

    
Private Declare Function AISample Lib "ljackuw.dll" _
    (ByRef lpIDNum As Long, _
    ByVal lngDemo As Long, _
    ByRef lpStateIO As Long, _
    ByVal lngUpdateIO As Long, _
    ByVal lngLEDOn As Long, _
    ByVal lngNumChannels As Long, _
    ByRef alngChannels As Any, _
    ByRef alngGains As Any, _
    ByVal lngDisableCal As Long, _
    ByRef lngOverVoltage As Long, _
    ByRef asngVoltages As Any) As Long
'Note that the arrays are handled by passing the address of
'the first element.  This probably will not work for arrays
'greater than 64 kb in size.


Private Declare Sub GetErrorString Lib "ljackuw.dll" _
    (ByVal lngErrorcode As Long, _
    ByVal lpErrorString As String)
'Note that Strings are passed ByVal since they are inherently
'pointers.  Also, functions with no return value, are called
'a "Sub" in VB, rather than a "Function", and when you call
'a "Sub" you don't put parentheses around the parameters.



Private Sub Form_Load()
    cboChannelA.ListIndex = 0
    cboChannelB.ListIndex = 1
    cboChannelC.ListIndex = 2
    cboChannelD.ListIndex = 3
    cboGainA.ListIndex = 0
    cboGainB.ListIndex = 0
    cboGainC.ListIndex = 0
    cboGainD.ListIndex = 0
End Sub

Private Sub Timer1_Timer()

    Dim lngErrorcode As Long
    Dim lngIDNum As Long
    Dim lngDemo As Long
    Dim lngUpdateDigital As Long
    Dim lngResetCounter As Long
    Dim lngTrisD As Long
    Dim lngTrisIO As Long
    Dim lngStateD As Long
    Dim lngStateIO As Long
    Dim lngCount As Long
    Dim sngAnalogOut0 As Single
    Dim sngAnalogOut1 As Single
    
    Dim lngOV As Long
    Dim lngUpdateIO As Long
    Dim lngNumChannels As Long
    Dim lngDisableCal As Long
    Dim alngChannels(4) As Long
    Dim alngGains(4) As Long
    Dim asngVoltages(4) As Single
    
    Dim strError As String * 50
        
        
    lngIDNum = -1
    lngDemo = 0
    lngUpdateDigital = 1
    lngResetCounter = chkResetCount.Value
    lngTrisD = 0
    lngTrisIO = chkTris0 + (chkTris1 * (2 ^ 1)) + (chkTris2 * (2 ^ 2)) + (chkTris3 * (2 ^ 3))
    lngStateIO = chkSet0 + (chkSet1 * (2 ^ 1)) + (chkSet2 * (2 ^ 2)) + (chkSet3 * (2 ^ 3))
    sngAnalogOut0 = Val(txtAO0)
    sngAnalogOut1 = Val(txtAO1)
    lngErrorcode = AOUpdate(lngIDNum, lngDemo, lngTrisD, lngTrisIO, lngStateD, lngStateIO, lngUpdateDigital, lngResetCounter, lngCount, sngAnalogOut0, sngAnalogOut1)
    chkRead0 = lngStateIO Mod 2
    lngStateIO = lngStateIO \ 2
    chkRead1 = lngStateIO Mod 2
    lngStateIO = lngStateIO \ 2
    chkRead2 = lngStateIO Mod 2
    lngStateIO = lngStateIO \ 2
    chkRead3 = lngStateIO Mod 2
    txtCount = Str(lngCount)
    GetErrorString lngErrorcode, strError
    txtAOError = strError
    

    lngUpdateIO = 0
    lngNumChannels = 4
    lngDisableCal = 0
    alngChannels(0) = cboChannelA.ListIndex
    alngChannels(1) = cboChannelB.ListIndex
    alngChannels(2) = cboChannelC.ListIndex
    alngChannels(3) = cboChannelD.ListIndex
    alngGains(0) = cboGainA.ListIndex
    alngGains(1) = cboGainB.ListIndex
    alngGains(2) = cboGainC.ListIndex
    alngGains(3) = cboGainD.ListIndex
    asngVoltages(0) = 0
    asngVoltages(1) = 0
    asngVoltages(2) = 0
    asngVoltages(3) = 0
    lngErrorcode = AISample(lngIDNum, lngDemo, lngStateIO, lngUpdateIO, chkLED, lngNumChannels, alngChannels(0), alngGains(0), lngDisableCal, lngOV, asngVoltages(0))
    txtVoltsA = Str(asngVoltages(0))
    txtVoltsB = Str(asngVoltages(1))
    txtVoltsC = Str(asngVoltages(2))
    txtVoltsD = Str(asngVoltages(3))
    GetErrorString lngErrorcode, strError
    txtAIError = strError
    
End Sub


