VERSION 5.00
Object = "{E46BCC02-8469-11D5-B00B-00008654A834}#1.0#0"; "ljackuwx.ocx"
Begin VB.Form Form1 
   Caption         =   "LabJack U12 VB Example"
   ClientHeight    =   8760
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8430
   LinkTopic       =   "Form1"
   ScaleHeight     =   8760
   ScaleWidth      =   8430
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtVoltsH 
      Height          =   285
      Left            =   6840
      TabIndex        =   58
      Top             =   6120
      Width           =   975
   End
   Begin VB.TextBox txtVoltsG 
      Height          =   285
      Left            =   6840
      TabIndex        =   57
      Top             =   5520
      Width           =   975
   End
   Begin VB.TextBox txtVoltsF 
      Height          =   285
      Left            =   6840
      TabIndex        =   56
      Top             =   4920
      Width           =   975
   End
   Begin VB.TextBox txtVoltsE 
      Height          =   285
      Left            =   6840
      TabIndex        =   55
      Top             =   4320
      Width           =   975
   End
   Begin VB.ComboBox cboChannelE 
      Height          =   315
      ItemData        =   "main.frx":0000
      Left            =   4680
      List            =   "main.frx":0028
      Style           =   2  'Dropdown List
      TabIndex        =   54
      Top             =   4320
      Width           =   1095
   End
   Begin VB.ComboBox cboChannelF 
      Height          =   315
      ItemData        =   "main.frx":0084
      Left            =   4680
      List            =   "main.frx":00AC
      Style           =   2  'Dropdown List
      TabIndex        =   53
      Top             =   4920
      Width           =   1095
   End
   Begin VB.ComboBox cboChannelG 
      Height          =   315
      ItemData        =   "main.frx":0108
      Left            =   4680
      List            =   "main.frx":0130
      Style           =   2  'Dropdown List
      TabIndex        =   52
      Top             =   5520
      Width           =   1095
   End
   Begin VB.ComboBox cboChannelH 
      Height          =   315
      ItemData        =   "main.frx":018C
      Left            =   4680
      List            =   "main.frx":01B4
      Style           =   2  'Dropdown List
      TabIndex        =   51
      Top             =   6120
      Width           =   1095
   End
   Begin VB.ComboBox cboGainE 
      Height          =   315
      ItemData        =   "main.frx":0210
      Left            =   5880
      List            =   "main.frx":022C
      Style           =   2  'Dropdown List
      TabIndex        =   50
      Top             =   4320
      Width           =   735
   End
   Begin VB.ComboBox cboGainF 
      Height          =   315
      ItemData        =   "main.frx":024B
      Left            =   5880
      List            =   "main.frx":0267
      Style           =   2  'Dropdown List
      TabIndex        =   49
      Top             =   4920
      Width           =   735
   End
   Begin VB.ComboBox cboGainG 
      Height          =   315
      ItemData        =   "main.frx":0286
      Left            =   5880
      List            =   "main.frx":02A2
      Style           =   2  'Dropdown List
      TabIndex        =   48
      Top             =   5520
      Width           =   735
   End
   Begin VB.ComboBox cboGainH 
      Height          =   315
      ItemData        =   "main.frx":02C1
      Left            =   5880
      List            =   "main.frx":02DD
      Style           =   2  'Dropdown List
      TabIndex        =   47
      Top             =   6120
      Width           =   735
   End
   Begin VB.TextBox txtOCXVersion 
      Height          =   285
      Left            =   6840
      TabIndex        =   44
      Top             =   960
      Width           =   975
   End
   Begin VB.TextBox txtDLLVersion 
      Height          =   285
      Left            =   6840
      TabIndex        =   43
      Top             =   360
      Width           =   975
   End
   Begin LJACKUWXLib.Ljackuwx Ljackuwx1 
      Height          =   735
      Left            =   360
      TabIndex        =   42
      Top             =   7800
      Width           =   1455
      _Version        =   65536
      _ExtentX        =   2566
      _ExtentY        =   1296
      _StockProps     =   0
   End
   Begin VB.CheckBox chkLED 
      Caption         =   "Status LED"
      Height          =   495
      Left            =   4680
      TabIndex        =   8
      Top             =   720
      Value           =   1  'Checked
      Width           =   1575
   End
   Begin VB.ComboBox cboGainD 
      Height          =   315
      ItemData        =   "main.frx":02FC
      Left            =   5880
      List            =   "main.frx":0318
      Style           =   2  'Dropdown List
      TabIndex        =   41
      Top             =   3360
      Width           =   735
   End
   Begin VB.ComboBox cboGainC 
      Height          =   315
      ItemData        =   "main.frx":0337
      Left            =   5880
      List            =   "main.frx":0353
      Style           =   2  'Dropdown List
      TabIndex        =   40
      Top             =   2760
      Width           =   735
   End
   Begin VB.ComboBox cboGainB 
      Height          =   315
      ItemData        =   "main.frx":0372
      Left            =   5880
      List            =   "main.frx":038E
      Style           =   2  'Dropdown List
      TabIndex        =   39
      Top             =   2160
      Width           =   735
   End
   Begin VB.ComboBox cboGainA 
      Height          =   315
      ItemData        =   "main.frx":03AD
      Left            =   5880
      List            =   "main.frx":03C9
      Style           =   2  'Dropdown List
      TabIndex        =   36
      Top             =   1560
      Width           =   735
   End
   Begin VB.ComboBox cboChannelD 
      Height          =   315
      ItemData        =   "main.frx":03E8
      Left            =   4680
      List            =   "main.frx":0410
      Style           =   2  'Dropdown List
      TabIndex        =   35
      Top             =   3360
      Width           =   1095
   End
   Begin VB.ComboBox cboChannelC 
      Height          =   315
      ItemData        =   "main.frx":046C
      Left            =   4680
      List            =   "main.frx":0494
      Style           =   2  'Dropdown List
      TabIndex        =   34
      Top             =   2760
      Width           =   1095
   End
   Begin VB.ComboBox cboChannelB 
      Height          =   315
      ItemData        =   "main.frx":04F0
      Left            =   4680
      List            =   "main.frx":0518
      Style           =   2  'Dropdown List
      TabIndex        =   33
      Top             =   2160
      Width           =   1095
   End
   Begin VB.ComboBox cboChannelA 
      Height          =   315
      ItemData        =   "main.frx":0574
      Left            =   4680
      List            =   "main.frx":059C
      Style           =   2  'Dropdown List
      TabIndex        =   32
      Top             =   1560
      Width           =   1095
   End
   Begin VB.TextBox txtAIError 
      BackColor       =   &H8000000B&
      Height          =   495
      Left            =   4680
      TabIndex        =   30
      Top             =   7200
      Width           =   3615
   End
   Begin VB.TextBox txtVoltsA 
      Height          =   285
      Left            =   6840
      TabIndex        =   25
      Top             =   1560
      Width           =   975
   End
   Begin VB.TextBox txtVoltsB 
      Height          =   285
      Left            =   6840
      TabIndex        =   24
      Top             =   2160
      Width           =   975
   End
   Begin VB.TextBox txtVoltsC 
      Height          =   285
      Left            =   6840
      TabIndex        =   23
      Top             =   2760
      Width           =   975
   End
   Begin VB.TextBox txtVoltsD 
      Height          =   285
      Left            =   6840
      TabIndex        =   22
      Top             =   3360
      Width           =   975
   End
   Begin VB.CheckBox chkSet2 
      Caption         =   "Set IO2"
      Height          =   495
      Left            =   1920
      TabIndex        =   21
      Top             =   2880
      Width           =   975
   End
   Begin VB.CheckBox chkSet3 
      Caption         =   "Set IO3"
      Height          =   495
      Left            =   1920
      TabIndex        =   20
      Top             =   3240
      Width           =   975
   End
   Begin VB.CheckBox chkTris2 
      Caption         =   "IO2 Output/(Input)"
      Height          =   495
      Left            =   120
      TabIndex        =   19
      Top             =   2880
      Width           =   1815
   End
   Begin VB.CheckBox chkTris3 
      Caption         =   "IO3 Output/(Input)"
      Height          =   495
      Left            =   120
      TabIndex        =   18
      Top             =   3240
      Width           =   1815
   End
   Begin VB.CheckBox chkRead2 
      Caption         =   "IO2 Read"
      Height          =   495
      Left            =   3000
      TabIndex        =   17
      Top             =   2880
      Width           =   1215
   End
   Begin VB.CheckBox chkRead3 
      Caption         =   "IO3 Read"
      Height          =   495
      Left            =   3000
      TabIndex        =   16
      Top             =   3240
      Width           =   1215
   End
   Begin VB.CheckBox chkRead1 
      Caption         =   "IO1 Read"
      Height          =   495
      Left            =   3000
      TabIndex        =   15
      Top             =   2520
      Width           =   1215
   End
   Begin VB.CheckBox chkRead0 
      Caption         =   "IO0 Read"
      Height          =   495
      Left            =   3000
      TabIndex        =   14
      Top             =   2160
      Width           =   1215
   End
   Begin VB.CheckBox chkTris1 
      Caption         =   "IO1 Output/(Input)"
      Height          =   495
      Left            =   120
      TabIndex        =   13
      Top             =   2520
      Width           =   1815
   End
   Begin VB.CheckBox chkTris0 
      Caption         =   "IO0 Output/(Input)"
      Height          =   495
      Left            =   120
      TabIndex        =   12
      Top             =   2160
      Width           =   1815
   End
   Begin VB.CheckBox chkResetCount 
      Caption         =   "Reset Counter"
      Height          =   495
      Left            =   2280
      TabIndex        =   11
      Top             =   1440
      Width           =   1575
   End
   Begin VB.CheckBox chkSet1 
      Caption         =   "Set IO1"
      Height          =   495
      Left            =   1920
      TabIndex        =   10
      Top             =   2520
      Width           =   975
   End
   Begin VB.CheckBox chkSet0 
      Caption         =   "Set IO0"
      Height          =   495
      Left            =   1920
      TabIndex        =   9
      Top             =   2160
      Width           =   975
   End
   Begin VB.TextBox txtCount 
      Height          =   285
      Left            =   2280
      TabIndex        =   6
      Top             =   1080
      Width           =   1695
   End
   Begin VB.TextBox txtAO1 
      Height          =   285
      Left            =   120
      TabIndex        =   4
      Text            =   "0.00"
      Top             =   1680
      Width           =   975
   End
   Begin VB.TextBox txtAOError 
      BackColor       =   &H8000000B&
      Height          =   495
      Left            =   120
      TabIndex        =   1
      Top             =   7200
      Width           =   3615
   End
   Begin VB.Timer Timer1 
      Interval        =   200
      Left            =   1920
      Top             =   7800
   End
   Begin VB.TextBox txtAO0 
      Height          =   285
      Left            =   120
      TabIndex        =   0
      Text            =   "0.00"
      Top             =   1080
      Width           =   975
   End
   Begin VB.Label Label9 
      Caption         =   "Voltage H"
      Height          =   495
      Left            =   6840
      TabIndex        =   64
      Top             =   5880
      Width           =   1215
   End
   Begin VB.Label Label8 
      Caption         =   "Voltage G"
      Height          =   495
      Left            =   6840
      TabIndex        =   63
      Top             =   5280
      Width           =   1215
   End
   Begin VB.Label Label7 
      Caption         =   "Voltage F"
      Height          =   495
      Left            =   6840
      TabIndex        =   62
      Top             =   4680
      Width           =   1215
   End
   Begin VB.Label Label6 
      Caption         =   "Voltage E"
      Height          =   495
      Left            =   6840
      TabIndex        =   61
      Top             =   4080
      Width           =   1215
   End
   Begin VB.Label Label5 
      Caption         =   "Channel"
      Height          =   495
      Left            =   4680
      TabIndex        =   60
      Top             =   4080
      Width           =   1095
   End
   Begin VB.Label Label4 
      Caption         =   "Gain"
      Height          =   495
      Left            =   5880
      TabIndex        =   59
      Top             =   4080
      Width           =   735
   End
   Begin VB.Label Label2 
      Caption         =   "OCX Version"
      Height          =   495
      Left            =   6840
      TabIndex        =   46
      Top             =   720
      Width           =   1215
   End
   Begin VB.Label Label1 
      Caption         =   "DLL Version"
      Height          =   495
      Left            =   6840
      TabIndex        =   45
      Top             =   120
      Width           =   1215
   End
   Begin VB.Label lblGain 
      Caption         =   "Gain"
      Height          =   495
      Left            =   5880
      TabIndex        =   38
      Top             =   1320
      Width           =   735
   End
   Begin VB.Label lblChannel 
      Caption         =   "Channel"
      Height          =   495
      Left            =   4680
      TabIndex        =   37
      Top             =   1320
      Width           =   1095
   End
   Begin VB.Label LabelAIError 
      Caption         =   "AISample Error Message"
      Height          =   495
      Left            =   4680
      TabIndex        =   31
      Top             =   6960
      Width           =   2175
   End
   Begin VB.Label LabelAIA 
      Caption         =   "Voltage A"
      Height          =   495
      Left            =   6840
      TabIndex        =   29
      Top             =   1320
      Width           =   1215
   End
   Begin VB.Label LabelAIB 
      Caption         =   "Voltage B"
      Height          =   495
      Left            =   6840
      TabIndex        =   28
      Top             =   1920
      Width           =   1215
   End
   Begin VB.Label LabelAIC 
      Caption         =   "Voltage C"
      Height          =   495
      Left            =   6840
      TabIndex        =   27
      Top             =   2520
      Width           =   1215
   End
   Begin VB.Label LabelAID 
      Caption         =   "Voltage D"
      Height          =   495
      Left            =   6840
      TabIndex        =   26
      Top             =   3120
      Width           =   1215
   End
   Begin VB.Label LabelCount 
      Caption         =   "Count"
      Height          =   495
      Left            =   2280
      TabIndex        =   7
      Top             =   840
      Width           =   1215
   End
   Begin VB.Label Label3 
      Caption         =   "AO1 Voltage"
      Height          =   495
      Left            =   120
      TabIndex        =   5
      Top             =   1440
      Width           =   1215
   End
   Begin VB.Label LabelAOError 
      Caption         =   "AOUpdate Error Message"
      Height          =   495
      Left            =   120
      TabIndex        =   3
      Top             =   6960
      Width           =   2175
   End
   Begin VB.Label LabelAO0 
      Caption         =   "AO0 Voltage"
      Height          =   495
      Left            =   120
      TabIndex        =   2
      Top             =   840
      Width           =   1215
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'VBLabJackOCX example:

'VB6 example that demonstrates calls to the command response functions AOUpdate
'and AISample.  AISample can read 4 analog inputs, while AOUpdate can write both
'analog outputs, writes/reads all digital I/O, and reads the counter.  To read
'more analog inputs, just add more calls to AISample.  For timing information,
'see the U12 data rates page linked from the U12 product page at labjack.com.
'Also uses the support functions GetDriverVersionX, GetErrorStringX, and FourPack.
'See Section 4 of the U12 User's Guide for function definitions.

'Mar 26, 2007
'support@labjack.com

Option Explicit


Private Sub Form_Load()
    cboChannelA.ListIndex = 0
    cboChannelB.ListIndex = 0
    cboChannelC.ListIndex = 0
    cboChannelD.ListIndex = 0
    cboChannelE.ListIndex = 0
    cboChannelF.ListIndex = 0
    cboChannelG.ListIndex = 0
    cboChannelH.ListIndex = 0
    cboGainA.ListIndex = 0
    cboGainB.ListIndex = 0
    cboGainC.ListIndex = 0
    cboGainD.ListIndex = 0
    cboGainE.ListIndex = 0
    cboGainF.ListIndex = 0
    cboGainG.ListIndex = 0
    cboGainH.ListIndex = 0
End Sub

Private Sub Timer1_Timer()

    Dim lngErrorcode As Long
    Dim lngIDNum As Long
    Dim lngDemo As Long
    Dim lngUpdateDigital As Long
    Dim lngTrisD As Long
    Dim lngTrisIO As Long
    Dim lngStateD As Long
    Dim lngStateIO As Long
    Dim dblCount As Double
    Dim sngAnalogOut0 As Single
    Dim sngAnalogOut1 As Single
    
    Dim lngOV As Long
    Dim lngUpdateIO As Long
    Dim lngNumChannels As Long
    Dim lngDisableCal As Long
    Dim sngVoltsA As Single
    Dim sngVoltsB As Single
    Dim sngVoltsC As Single
    Dim sngVoltsD As Single
    Dim sngVoltsE As Single
    Dim sngVoltsF As Single
    Dim sngVoltsG As Single
    Dim sngVoltsH As Single
    Dim lngCP As Long
    Dim lngGP As Long

    Dim sglDLLVersion As Single
    Dim sglOCXVersion As Single
    
    Ljackuwx1.GetDriverVersionX sglDLLVersion, sglOCXVersion
    txtDLLVersion = Str(sglDLLVersion)
    txtOCXVersion = Str(sglOCXVersion)
    
    lngIDNum = -1
    lngDemo = 0
    lngUpdateDigital = 1
    lngTrisD = 0
    lngStateD = 0
    lngTrisIO = chkTris0 + (chkTris1 * (2 ^ 1)) + (chkTris2 * (2 ^ 2)) + (chkTris3 * (2 ^ 3))
    lngStateIO = chkSet0 + (chkSet1 * (2 ^ 1)) + (chkSet2 * (2 ^ 2)) + (chkSet3 * (2 ^ 3))
    sngAnalogOut0 = Val(txtAO0)
    sngAnalogOut1 = Val(txtAO1)
    lngErrorcode = Ljackuwx1.AOUpdateX(lngIDNum, lngDemo, lngTrisD, lngTrisIO, lngStateD, lngStateIO, lngUpdateDigital, chkResetCount.Value, dblCount, sngAnalogOut0, sngAnalogOut1)
    chkRead0 = lngStateIO Mod 2
    lngStateIO = lngStateIO \ 2
    chkRead1 = lngStateIO Mod 2
    lngStateIO = lngStateIO \ 2
    chkRead2 = lngStateIO Mod 2
    lngStateIO = lngStateIO \ 2
    chkRead3 = lngStateIO Mod 2
    txtCount = Str(dblCount)
    txtAOError = Ljackuwx1.GetErrorStringX(lngErrorcode)
    'D lines are also written and read by AOUpdate, but we don't show them in this example.
    

    lngUpdateIO = 0
    lngNumChannels = 4
    lngDisableCal = 0
    lngCP = Ljackuwx1.FourPack(cboChannelA.ListIndex, cboChannelB.ListIndex, cboChannelC.ListIndex, cboChannelD.ListIndex)
    lngGP = Ljackuwx1.FourPack(cboGainA.ListIndex, cboGainB.ListIndex, cboGainC.ListIndex, cboGainD.ListIndex)
    lngErrorcode = Ljackuwx1.AISampleX(lngIDNum, lngDemo, lngStateIO, lngUpdateIO, chkLED, lngNumChannels, lngCP, lngGP, lngDisableCal, lngOV, sngVoltsA, sngVoltsB, sngVoltsC, sngVoltsD)
    txtVoltsA = Str(sngVoltsA)
    txtVoltsB = Str(sngVoltsB)
    txtVoltsC = Str(sngVoltsC)
    txtVoltsD = Str(sngVoltsD)
    txtAIError = Ljackuwx1.GetErrorStringX(lngErrorcode)
         
    lngCP = Ljackuwx1.FourPack(cboChannelE.ListIndex, cboChannelF.ListIndex, cboChannelG.ListIndex, cboChannelH.ListIndex)
    lngGP = Ljackuwx1.FourPack(cboGainE.ListIndex, cboGainF.ListIndex, cboGainG.ListIndex, cboGainH.ListIndex)
    lngErrorcode = Ljackuwx1.AISampleX(lngIDNum, lngDemo, lngStateIO, lngUpdateIO, chkLED, lngNumChannels, lngCP, lngGP, lngDisableCal, lngOV, sngVoltsE, sngVoltsF, sngVoltsG, sngVoltsH)
    txtVoltsE = Str(sngVoltsE)
    txtVoltsF = Str(sngVoltsF)
    txtVoltsG = Str(sngVoltsG)
    txtVoltsH = Str(sngVoltsH)
    txtAIError = Ljackuwx1.GetErrorStringX(lngErrorcode)
    
End Sub


'The following bit manipulation functions are from vbcity.com


'*----------------------------------------------------------*
'* Name       : BitSet                                      *
'*----------------------------------------------------------*
'* Purpose    : Sets a given Bit in Number                  *
'*----------------------------------------------------------*
Public Function BitSet(Number As Long, _
                       ByVal Bit As Long) As Long
  If Bit = 31 Then
    Number = &H80000000 Or Number
  Else
    Number = (2 ^ Bit) Or Number
  End If

  BitSet = Number
End Function


'*----------------------------------------------------------*
'* Name       : BitClear                                    *
'*----------------------------------------------------------*
'* Purpose    : Clears a given Bit in Number                *
'*----------------------------------------------------------*
Public Function BitClear(Number As Long, _
                         ByVal Bit As Long) As Long
  If Bit = 31 Then
    Number = &H7FFFFFFF And Number
  Else
    Number = ((2 ^ Bit) Xor &HFFFFFFFF) And Number
  End If

  BitClear = Number
End Function


'*----------------------------------------------------------*
'* Name       : BitIsSet                                    *
'*----------------------------------------------------------*
'* Purpose    : Test if bit 0 to bit 31 is set              *
'*----------------------------------------------------------*
Public Function BitIsSet(ByVal Number As Long, _
                         ByVal Bit As Long) As Boolean
  BitIsSet = False

  If Bit = 31 Then
    If Number And &H80000000 Then BitIsSet = True
  Else
    If Number And (2 ^ Bit) Then BitIsSet = True
  End If
End Function


