using System;
using System.Net.Sockets;
using System.Threading;

namespace ue9
{
	/// <summary>
	/// Summary description for ue9.
	/// </summary>
	public class ue9
	{
		public TcpClient tcpSock;
		public bool tcpOpen;
		public NetworkStream Stream;
		public int errorcode = 0;
		public string debugString = "";
		private string tcpServer;
		private int tcpPort;
		public  byte[] sendRecBuffer;	//buffer used with the void functions read and write
										//(needs to beinitialized and filled in)
		public int sendRecSize;			//size of sendRecBuffer
		public bool sendRecDone;		
		public object sendRecObject = new object();
 
		public ue9()
		{
			//
			// TODO: Add constructor logic here
			//
			tcpOpen = false;
		}

		public void normalChecksum(ref byte []b, int n)
		{
			/* Add checksum to a data packet for normal command format */
			b[0]=normalChecksum8(b,n);
		}

		public void extendedChecksum(ref byte []b, int n)
		{
			/* Add checksum to a data packet for extended command format */

			ushort a;

			a = extendedChecksum16(b,n);
			b[4] = (byte)(a & 0xff);
			b[5] = (byte)((a >> 8) & 0xff);
			b[0] = extendedChecksum8(b);
		}

		public byte normalChecksum8(byte []b, int n)
		{
			/* Sum bytes 1 to n-1 as ushort. Sum quotient and remainder of 256
			   division. Again, sum quotient and remainder of 256
			   division. Return result as byte.  */
			int i;
			ushort a, bb;
  
			for(i = 1, a = 0; i < n; i++) 
				a+=(ushort)b[i];

			bb = (ushort)(a/256);
			a = (ushort)((a-256*bb)+bb);
			bb = (ushort)(a/256);

			return ((byte)((a-256*bb)+bb));
		}

		public ushort extendedChecksum16(byte []b, int n)
		{
			/* Sum bytes 6 to n-1 as ushort. */

			int i;
			ushort a;

			for(i = 6, a = 0; i < n; i++)
				a += (ushort)b[i];

			return a;
		}

		public byte extendedChecksum8(byte []b)
		{
			/* Sum bytes 1 to 5. Sum quotient and remainder of 256
			   division. Again, sum quotient and remainder of 256
			   division. Return result as byte. */
			uint i, a, bb;

			for(i=1,a=0;i<6;i++)
				a += (ushort)b[i];
  
			bb = (ushort)(a/256);
			a = (ushort)((a-256*bb)+bb);
			bb = (ushort)(a/256);
  
			return ((byte)((a-256*bb)+bb));  
		}

		public int openTCPConnection(string server, int port)
		{
			/* Open a socket which connects to a specific port on
			   server. Returns a value <0 on failure. Returns the socket
			   descriptor on success.  An extra thread is used when connecting
			   so that a timeout of 4 seconds can be applied. */
			Thread openThread;// = new Thread(new ThreadStart(openTcpConnectionThread));
	
			try
			{
				tcpSock = new TcpClient();
				
				tcpServer = server;
				tcpPort = port;
				openThread = new Thread(new ThreadStart(connectThread));
				openThread.Start();

				int sleepCount = 0;

				while(sleepCount < 4250)
				{
					if(this.tcpOpen == true)
						break;
					
					Thread.Sleep(250);
					sleepCount += 250;
				}

				if(this.tcpOpen == false)
				{
					tcpSock.Close();
					throw new Exception();
				}
				Stream = tcpSock.GetStream();				
			}
			catch (System.Exception g)
			{
				tcpOpen = false;
				debugString = g.ToString();
				return -3;
			}
	
			return 0;
		}

		private void connectThread()
		{
			/* void function that connects the tcp socket.  tcpSock needs its
			   resources initialized before calling this function. */
			tcpOpen = false;
			try
			{
				tcpSock.Connect(new System.Net.IPEndPoint(System.Net.IPAddress.Parse(tcpServer), tcpPort));
			}
			catch(Exception)
			{
				return;
			}
			tcpOpen = true;	
		}

		public int closeTCPConnection()
		{
			try
			{
				if(tcpOpen == true)
				{
					Stream.Close();
					tcpSock.Close();
				}
			}
			catch (System.Exception)
			{
				tcpOpen = false;
				return -1;
			}

			tcpOpen = false;
			return 0;
		}

		public long getTickCount() 
		{
			/* retrieves the number 100 nanoseconds that has elasped 
			   since the system was started */
			return(System.DateTime.Now.Ticks); 
		}

		public int translateCalibratedVoltage(byte gainBip, ushort voltageBytes, ref double caliVoltage) 
		{
			/*  Translates the voltage bytes read from the ue9 to a voltage
				value (calibrated).  The getAnalogCalibrationInfo is called.  */

			double slope = 0;
			double offset = 0;

			if(tcpOpen == false)
				return -2;

			if(getAnalogCalibrationInfo(gainBip, ref slope, ref offset) != 0)
				return -5;
			
			caliVoltage = (slope*voltageBytes) + offset;  
			
			return 0;  
		}

		public int translateUncalibratedVoltage(byte gainBip, ushort voltageBytes, ref double uncaliVoltage) 
		{
			/*  Translates the voltage bytes read from the ue9 to 
				a voltage value (uncalibrated)  */

			switch( (uint)gainBip)
			{
				case 0: uncaliVoltage = ((double)voltageBytes/65536.0)*5.08;
					break;
				case 1: uncaliVoltage = ((double)voltageBytes/65536.0)*2.54;
					break;
				case 2: uncaliVoltage = ((double)voltageBytes/65536.0)*1.27;
					break;
				case 3: uncaliVoltage = ((double)voltageBytes/65536.0)*0.63;
					break;
				case 8: uncaliVoltage = ((double)voltageBytes/65536.0)*10.25;
					break;
				default:  return -6;
			}
			return 0;
		}

		public int getAnalogCalibrationInfo(byte gainBip, ref double slope, ref double offset) 
		{
			/*  Gets the slope and offset that are used to calculate the calibrated voltage.
				A TCP connection must be opened first to get the calibration information from the
				UE9's memory.  Uses a new thread for read and write so that a timeout can be used.*/
			//byte []buffer = new byte[8];
			Thread AINThread;
			sendRecBuffer = new byte[8];
			sendRecSize = 8;
			int sleepCount;

			if(tcpOpen == false)
				return -2;

			sendRecBuffer[1] = (byte)(0xF8);
			sendRecBuffer[2] = (byte)(0x01);
			sendRecBuffer[3] = (byte)(0x2A);
			sendRecBuffer[6] = (byte)(0x00);
  
			if(gainBip == 0 || gainBip == 1 || gainBip == 2 || gainBip == 3)
				sendRecBuffer[7] = (byte)(0x00);
			else if (gainBip == 8)
				sendRecBuffer[7] = (byte)(0x01);
			else
				return -7;
			
			extendedChecksum(ref sendRecBuffer, 8);

			try
			{
				sendRecDone = false;
				AINThread = new Thread(new ThreadStart(this.write));
				AINThread.Start();

				sleepCount = 0;
				while(sleepCount < 2000)
				{
					if(sendRecDone == true)
						break;
					Thread.Sleep(250);
					sleepCount += 250;
				}

				if(sendRecDone == false)
				{
					closeTCPConnection();
					throw new Exception();
				}
			}
			catch(System.Exception)
			{
				return -8;
			}

			sendRecBuffer = new byte[136];
			sendRecSize = 136;

			try
			{
				sendRecDone = false;
				AINThread = new Thread(new ThreadStart(this.read));
				AINThread.Start();

				sleepCount = 0;
				while(sleepCount < 2000)
				{
					if(sendRecDone == true)
						break;
					Thread.Sleep(250);
					sleepCount += 250;
				}

				if(sendRecDone == false)
				{
					closeTCPConnection();
					throw new Exception();
				}
			}
			catch(System.Exception)
			{
				return -9;
			}
			


			if(sendRecBuffer[1] != (byte)(0xF8) || sendRecBuffer[2] != (byte)(0x41) || sendRecBuffer[3] != (byte)(0x2A))
				return -10;
			
			switch( (uint)gainBip )
			{
				case 0: fpArrayTofpDouble(sendRecBuffer, 8, ref slope, ref offset);
					break;
				case 1: fpArrayTofpDouble(sendRecBuffer, 24, ref slope, ref offset); 	    
					break;
				case 2: fpArrayTofpDouble(sendRecBuffer, 40, ref slope, ref offset);	    
					break;
				case 3: fpArrayTofpDouble(sendRecBuffer, 56, ref slope, ref offset);
					break;
				case 8: fpArrayTofpDouble(sendRecBuffer, 8, ref slope, ref offset);	    
					break;
				default: return -7;
			}
    
			return 0;
		}

		public void fpArrayTofpDouble(byte []buffer, int startIndex, ref double slope, ref double offset)
		{ 
			uint slopeDec;
			int slopeWh;
			uint offsetDec;
			int offsetWh;
			int i;

			slopeWh = 0;
			offsetWh = 0;
			slopeDec = 0;
			offsetDec = 0;

			for(i = 0; i < 4; i++) 
			{
				slopeDec += (uint)(buffer[startIndex + i] << (i*8)); 			
				slopeWh += (buffer[startIndex + i + 4] << (i*8));
				offsetDec += (uint)(buffer[startIndex + i + 8] << (i*8)); 			
				offsetWh += (buffer[startIndex + i + 12] << (i*8));
			}

			slope = (double)slopeWh + (double)(slopeDec)/4294967296.0;
			offset = (double)offsetWh + (double)(offsetDec)/4294967296.0;
   
			return;
		}

		public int getDACCalibrationInfo(ref double slope0, ref double offset0, ref double slope1, ref double offset1)
		{
			/*  Gets the slopes and offsets that are used to calculate the calibrated voltage
				for the DAC outputs.  A CTP connection must be opened first to get the calibration 
				information from the UE9's memory.  Uses a new thread for read and write so that a 
				timeout can be used.*/
			//byte []buffer = new byte[8];
			Thread DACThread;
			sendRecBuffer = new byte[8];
			sendRecSize = 8;
			int sleepCount = 0;
		
			sendRecBuffer[1] = (byte)(0xF8);
			sendRecBuffer[2] = (byte)(0x01);
			sendRecBuffer[3] = (byte)(0x2A);
			sendRecBuffer[6] = (byte)(0x00);
			sendRecBuffer[7] = (byte)(0x02);
			
			extendedChecksum(ref sendRecBuffer, 8);

			try
			{
				sendRecDone = false;
				DACThread = new Thread(new ThreadStart(this.write));
				DACThread.Start();

				sleepCount = 0;
				while(sleepCount < 2000)
				{
					if(sendRecDone == true)
						break;
					Thread.Sleep(250);
					sleepCount += 250;
				}

				if(sendRecDone == false)
				{
					closeTCPConnection();
					throw new Exception();
				}
			}
			catch(System.Exception)
			{
				return -8;
			}

			sendRecBuffer = new byte[136];
			sendRecSize = 136;
			
			try
			{
				sendRecDone = false;
				DACThread = new Thread(new ThreadStart(this.read));
				DACThread.Start();
				
				sleepCount = 0;
				while(sleepCount < 3000)
				{
					if(sendRecDone == true)
						break;
					Thread.Sleep(250);
					sleepCount += 250;
				}

				if(sendRecDone == false)
				{
					closeTCPConnection();
					throw new Exception();
				}
			}
			catch(System.Exception)
			{
				return -9;
			}
			
			if(sendRecBuffer[1] != (byte)(0xF8) || sendRecBuffer[2] != (byte)(0x41) || sendRecBuffer[3] != (byte)(0x2A))
				return -10;
			
			fpArrayTofpDouble(sendRecBuffer, 8, ref slope0, ref offset0);
			fpArrayTofpDouble(sendRecBuffer, 24, ref slope1, ref offset1); 	    
	    
			return 0;
		}

		public static int IPToString(ref string ipStr, string ip3, string ip2, string ip1, string ip0)
		{
			try
			{
				ipStr = ip3 + "." + ip2 + "." + ip1 + "." + ip0;
			}
			catch(System.Exception)
			{
				return -11;
			}
			return 0;			
		}

		public void write()
		{
			/*  Write that can be used with a thread.  sendRecBuffer is the buffer 
			    that will be written (needs to be initialized and filled in).  
			    sendRecSize needs to be the size of the sendRecBuffer  */
			sendRecDone = false;
			try
			{
				Stream.Write(sendRecBuffer, 0, sendRecSize);
				sendRecDone = true;
			}
			catch(Exception)
			{}
		}

		public void read()
		{
			/*  Read that can be used with a thread.  sendRecBuffer is the buffer 
				that will be read (needs to be initialized).  sendRecSize needs to 
				be the size of the sendRecBuffer  */
			
			sendRecDone = false;
			try
			{
				Stream.Read(sendRecBuffer, 0, sendRecSize);
				sendRecDone = true;
			}
			catch(Exception)
			{}
		}
	}
}

