//Author: LabJack
//April 15, 2005
//This example program calls the SingleIO function and reads the 
//voltage (calibrated) from AI0.  Need control firmware version 1.03
//and above for the SingleIO function to work.

using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Data;

namespace ue9
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class SingleIOTCPForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label dot1;
		private System.Windows.Forms.Label ipLabel;
		private System.Windows.Forms.Label dot3;
		private System.Windows.Forms.Label dot2;
		private System.Windows.Forms.TextBox ip3;
		private System.Windows.Forms.TextBox ip0;
		private System.Windows.Forms.TextBox ip1;
		private System.Windows.Forms.TextBox ip2;
		private System.Windows.Forms.Label errorLabel;
		private System.Windows.Forms.TextBox errorBox;
		private System.Windows.Forms.Label singleIOVoltText;
		private System.Windows.Forms.Button singleIOButton;
		private System.Windows.Forms.TextBox AI0Box;
		private ue9 ue9Dev;
		private System.Windows.Forms.MainMenu mainMenu1;
		private const int ue9_port = 52360;

		public SingleIOTCPForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.dot1 = new System.Windows.Forms.Label();
			this.ipLabel = new System.Windows.Forms.Label();
			this.dot3 = new System.Windows.Forms.Label();
			this.dot2 = new System.Windows.Forms.Label();
			this.ip3 = new System.Windows.Forms.TextBox();
			this.ip0 = new System.Windows.Forms.TextBox();
			this.ip1 = new System.Windows.Forms.TextBox();
			this.ip2 = new System.Windows.Forms.TextBox();
			this.errorLabel = new System.Windows.Forms.Label();
			this.errorBox = new System.Windows.Forms.TextBox();
			this.singleIOVoltText = new System.Windows.Forms.Label();
			this.singleIOButton = new System.Windows.Forms.Button();
			this.AI0Box = new System.Windows.Forms.TextBox();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			// 
			// dot1
			// 
			this.dot1.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular);
			this.dot1.Location = new System.Drawing.Point(88, 200);
			this.dot1.Size = new System.Drawing.Size(16, 20);
			this.dot1.Text = ".";
			this.dot1.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// ipLabel
			// 
			this.ipLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ipLabel.Location = new System.Drawing.Point(8, 192);
			this.ipLabel.Size = new System.Drawing.Size(48, 32);
			this.ipLabel.Text = "UE9 IP Addr :";
			// 
			// dot3
			// 
			this.dot3.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular);
			this.dot3.Location = new System.Drawing.Point(184, 200);
			this.dot3.Size = new System.Drawing.Size(16, 20);
			this.dot3.Text = ".";
			this.dot3.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// dot2
			// 
			this.dot2.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular);
			this.dot2.Location = new System.Drawing.Point(136, 200);
			this.dot2.Size = new System.Drawing.Size(16, 20);
			this.dot2.Text = ".";
			this.dot2.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// ip3
			// 
			this.ip3.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular);
			this.ip3.Location = new System.Drawing.Point(56, 192);
			this.ip3.MaxLength = 3;
			this.ip3.Size = new System.Drawing.Size(32, 22);
			this.ip3.Text = "192";
			// 
			// ip0
			// 
			this.ip0.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular);
			this.ip0.Location = new System.Drawing.Point(200, 192);
			this.ip0.MaxLength = 3;
			this.ip0.Size = new System.Drawing.Size(32, 22);
			this.ip0.Text = "209";
			// 
			// ip1
			// 
			this.ip1.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular);
			this.ip1.Location = new System.Drawing.Point(152, 192);
			this.ip1.MaxLength = 3;
			this.ip1.Size = new System.Drawing.Size(32, 22);
			this.ip1.Text = "1";
			// 
			// ip2
			// 
			this.ip2.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular);
			this.ip2.Location = new System.Drawing.Point(104, 192);
			this.ip2.MaxLength = 3;
			this.ip2.Size = new System.Drawing.Size(32, 22);
			this.ip2.Text = "168";
			// 
			// errorLabel
			// 
			this.errorLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.errorLabel.Location = new System.Drawing.Point(8, 232);
			this.errorLabel.Size = new System.Drawing.Size(40, 20);
			this.errorLabel.Text = "Error:";
			// 
			// errorBox
			// 
			this.errorBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold);
			this.errorBox.Location = new System.Drawing.Point(56, 232);
			this.errorBox.ReadOnly = true;
			this.errorBox.Size = new System.Drawing.Size(176, 21);
			this.errorBox.Text = "";
			// 
			// singleIOVoltText
			// 
			this.singleIOVoltText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.singleIOVoltText.Location = new System.Drawing.Point(16, 72);
			this.singleIOVoltText.Size = new System.Drawing.Size(96, 20);
			this.singleIOVoltText.Text = "AIN0 Voltage:";
			// 
			// singleIOButton
			// 
			this.singleIOButton.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.singleIOButton.Location = new System.Drawing.Point(88, 128);
			this.singleIOButton.Size = new System.Drawing.Size(72, 24);
			this.singleIOButton.Text = "Run";
			this.singleIOButton.Click += new System.EventHandler(this.singleIOButton_Click);
			// 
			// AI0Box
			// 
			this.AI0Box.Location = new System.Drawing.Point(120, 72);
			this.AI0Box.ReadOnly = true;
			this.AI0Box.Text = "";
			// 
			// SingleIOTCPForm
			// 
			this.Controls.Add(this.singleIOVoltText);
			this.Controls.Add(this.singleIOButton);
			this.Controls.Add(this.AI0Box);
			this.Controls.Add(this.dot1);
			this.Controls.Add(this.ipLabel);
			this.Controls.Add(this.dot3);
			this.Controls.Add(this.dot2);
			this.Controls.Add(this.ip3);
			this.Controls.Add(this.ip0);
			this.Controls.Add(this.ip1);
			this.Controls.Add(this.ip2);
			this.Controls.Add(this.errorLabel);
			this.Controls.Add(this.errorBox);
			this.MaximizeBox = false;
			this.Menu = this.mainMenu1;
			this.MinimizeBox = false;
			this.Text = "ue9SingleIO TCP";
			this.Load += new System.EventHandler(this.Form1_Load);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>

		static void Main() 
		{
			Application.Run(new SingleIOTCPForm());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
		
		}

		private void singleIOButton_Click(object sender, System.EventArgs e)
		{
			int err = 0;
			string ipStr = null;
			Error errorText = new Error(); 
			ue9Dev = new ue9();
			errorBox.Text = "";
			AI0Box.Text = "";

			err = ue9.IPToString(ref ipStr, ip3.Text, ip2.Text, ip1.Text, ip0.Text);

			if(err <= -1)
			{
				errorBox.Text = errorText.getError(err);
				return;
			}

			err = ue9Dev.openTCPConnection(ipStr, ue9_port);
			
			if(err <= -1)
			{
				errorBox.Text = errorText.getError(err);
				return;
			}

			err = singleIO_AV_example();
			if(err <= -1)
			{
				errorBox.Text = errorText.getError(err);
				ue9Dev.closeTCPConnection();				
				return;
			}

			err = ue9Dev.closeTCPConnection();
			
			if(err <= -1)
			{
				errorBox.Text = errorText.getError(err);
				return;
			}
		}

		private int singleIO_AV_example()
		{
			byte []buff = new byte[8];
			double voltage = 0;
			ushort voltageBytes = 0;
			byte gainBip;
 
			buff[1] = (byte)(0xA3);
			buff[2] = (byte)(0x04);  //IOType = 4
			buff[3] = (byte)(0x00);  //Channel = 0 (AI0)
			buff[4] = (byte)(0x00);  //Bip = unipolar, Gain = 1
			buff[5] = (byte)(0x0C);  //Resolution = 12
			buff[6] = (byte)(0x00);  //Delay = 0
			buff[7] = (byte)(0x00);
			buff[0] = ue9Dev.normalChecksum8(buff, 8);

			try
			{
				ue9Dev.Stream.Write(buff, 0, 8);
			}
			catch(System.Exception)
			{
				return -14;
			}
  
			gainBip = buff[4];

			try
			{
				if(ue9Dev.Stream.Read(buff, 0, 8) != 8)
					throw(new Exception());
			}
			catch(System.Exception)
			{
				return -15;
			}
			
			if((byte)(ue9Dev.normalChecksum8(buff, 8)) != buff[0])
				return -12;
			
			if(buff[1] != (byte)(0xA3))
				return -10;

			if(buff[2] != (byte)(0x04))
				return -13; 
  
			voltageBytes = (ushort)((ushort)buff[5] + ( (ushort)buff[6] << 8 ));

			//if(ue9Dev.translateUncalibratedVoltage(gainBip, voltageBytes, ref voltage) != 0) 
			if(ue9Dev.translateCalibratedVoltage(gainBip, voltageBytes, ref voltage) != 0) 
				return -1;

			AI0Box.Text = string.Format("{0:f3}", voltage) + " V";
			return 0;
		}
	}
}
