//Author: LabJack
//April 15, 2005
//This example program reads analog inputs AI0 - AI3 using stream mode

using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Data;

namespace ue9
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class StreamTCPForm : System.Windows.Forms.Form
	{
		private const int ue9_port_a = 52360;
		private const int ue9_port_b = 52361;
		private ue9 ue9DevA;
		private ue9 ue9DevB;
		private System.Windows.Forms.Button StreamButton;
		private System.Windows.Forms.Label dot1;
		private System.Windows.Forms.Label ipLabel;
		private System.Windows.Forms.Label dot3;
		private System.Windows.Forms.Label dot2;
		private System.Windows.Forms.TextBox ip3;
		private System.Windows.Forms.TextBox ip0;
		private System.Windows.Forms.TextBox ip1;
		private System.Windows.Forms.TextBox ip2;
		private System.Windows.Forms.Label statusText;
		private System.Windows.Forms.Label ai3;
		private System.Windows.Forms.Label ai2;
		private System.Windows.Forms.Label ai1;
		private System.Windows.Forms.Label ai0;
		private System.Windows.Forms.TextBox aiV3;
		private System.Windows.Forms.TextBox aiV2;
		private System.Windows.Forms.TextBox aiV1;
		private System.Windows.Forms.TextBox aiV0;
		private System.Windows.Forms.Label aiVoltageText;
		private System.Windows.Forms.Label aiText;
		private System.Windows.Forms.Label noScansText;
		private System.Windows.Forms.TextBox noScansBox;
		private System.Windows.Forms.TextBox totPacketsBox;
		private System.Windows.Forms.Label TotPacketsText;
		private System.Windows.Forms.TextBox curPacketsBox;
		private System.Windows.Forms.Label curPacketsText;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.TextBox statusBox;
		

		public StreamTCPForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.StreamButton = new System.Windows.Forms.Button();
			this.dot1 = new System.Windows.Forms.Label();
			this.ipLabel = new System.Windows.Forms.Label();
			this.dot3 = new System.Windows.Forms.Label();
			this.dot2 = new System.Windows.Forms.Label();
			this.ip3 = new System.Windows.Forms.TextBox();
			this.ip0 = new System.Windows.Forms.TextBox();
			this.ip1 = new System.Windows.Forms.TextBox();
			this.ip2 = new System.Windows.Forms.TextBox();
			this.statusText = new System.Windows.Forms.Label();
			this.statusBox = new System.Windows.Forms.TextBox();
			this.ai3 = new System.Windows.Forms.Label();
			this.ai2 = new System.Windows.Forms.Label();
			this.ai1 = new System.Windows.Forms.Label();
			this.ai0 = new System.Windows.Forms.Label();
			this.aiV3 = new System.Windows.Forms.TextBox();
			this.aiV2 = new System.Windows.Forms.TextBox();
			this.aiV1 = new System.Windows.Forms.TextBox();
			this.aiV0 = new System.Windows.Forms.TextBox();
			this.aiVoltageText = new System.Windows.Forms.Label();
			this.aiText = new System.Windows.Forms.Label();
			this.noScansText = new System.Windows.Forms.Label();
			this.noScansBox = new System.Windows.Forms.TextBox();
			this.totPacketsBox = new System.Windows.Forms.TextBox();
			this.TotPacketsText = new System.Windows.Forms.Label();
			this.curPacketsBox = new System.Windows.Forms.TextBox();
			this.curPacketsText = new System.Windows.Forms.Label();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			// 
			// StreamButton
			// 
			this.StreamButton.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.StreamButton.Location = new System.Drawing.Point(152, 152);
			this.StreamButton.Size = new System.Drawing.Size(72, 24);
			this.StreamButton.Text = "Run";
			this.StreamButton.Click += new System.EventHandler(this.StreamButton_Click);
			// 
			// dot1
			// 
			this.dot1.Location = new System.Drawing.Point(88, 208);
			this.dot1.Size = new System.Drawing.Size(16, 20);
			this.dot1.Text = ".";
			this.dot1.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// ipLabel
			// 
			this.ipLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ipLabel.Location = new System.Drawing.Point(8, 200);
			this.ipLabel.Size = new System.Drawing.Size(48, 32);
			this.ipLabel.Text = "UE9 IP Addr :";
			// 
			// dot3
			// 
			this.dot3.Location = new System.Drawing.Point(184, 208);
			this.dot3.Size = new System.Drawing.Size(16, 20);
			this.dot3.Text = ".";
			this.dot3.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// dot2
			// 
			this.dot2.Location = new System.Drawing.Point(136, 208);
			this.dot2.Size = new System.Drawing.Size(16, 20);
			this.dot2.Text = ".";
			this.dot2.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// ip3
			// 
			this.ip3.Location = new System.Drawing.Point(56, 200);
			this.ip3.MaxLength = 3;
			this.ip3.Size = new System.Drawing.Size(32, 22);
			this.ip3.Text = "192";
			// 
			// ip0
			// 
			this.ip0.Location = new System.Drawing.Point(200, 200);
			this.ip0.MaxLength = 3;
			this.ip0.Size = new System.Drawing.Size(32, 22);
			this.ip0.Text = "209";
			// 
			// ip1
			// 
			this.ip1.Location = new System.Drawing.Point(152, 200);
			this.ip1.MaxLength = 3;
			this.ip1.Size = new System.Drawing.Size(32, 22);
			this.ip1.Text = "1";
			// 
			// ip2
			// 
			this.ip2.Location = new System.Drawing.Point(104, 200);
			this.ip2.MaxLength = 3;
			this.ip2.Size = new System.Drawing.Size(32, 22);
			this.ip2.Text = "168";
			// 
			// statusText
			// 
			this.statusText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.statusText.Location = new System.Drawing.Point(8, 240);
			this.statusText.Size = new System.Drawing.Size(56, 20);
			this.statusText.Text = "Status:";
			// 
			// statusBox
			// 
			this.statusBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold);
			this.statusBox.Location = new System.Drawing.Point(64, 240);
			this.statusBox.ReadOnly = true;
			this.statusBox.Size = new System.Drawing.Size(160, 21);
			this.statusBox.Text = "";
			// 
			// ai3
			// 
			this.ai3.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ai3.Location = new System.Drawing.Point(136, 104);
			this.ai3.Size = new System.Drawing.Size(16, 16);
			this.ai3.Text = "3";
			// 
			// ai2
			// 
			this.ai2.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ai2.Location = new System.Drawing.Point(136, 80);
			this.ai2.Size = new System.Drawing.Size(16, 16);
			this.ai2.Text = "2";
			// 
			// ai1
			// 
			this.ai1.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ai1.Location = new System.Drawing.Point(136, 56);
			this.ai1.Size = new System.Drawing.Size(16, 16);
			this.ai1.Text = "1";
			// 
			// ai0
			// 
			this.ai0.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ai0.Location = new System.Drawing.Point(136, 32);
			this.ai0.Size = new System.Drawing.Size(16, 16);
			this.ai0.Text = "0";
			// 
			// aiV3
			// 
			this.aiV3.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.aiV3.Location = new System.Drawing.Point(160, 104);
			this.aiV3.ReadOnly = true;
			this.aiV3.Size = new System.Drawing.Size(64, 21);
			this.aiV3.Text = "";
			// 
			// aiV2
			// 
			this.aiV2.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.aiV2.Location = new System.Drawing.Point(160, 80);
			this.aiV2.ReadOnly = true;
			this.aiV2.Size = new System.Drawing.Size(64, 21);
			this.aiV2.Text = "";
			// 
			// aiV1
			// 
			this.aiV1.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.aiV1.Location = new System.Drawing.Point(160, 56);
			this.aiV1.ReadOnly = true;
			this.aiV1.Size = new System.Drawing.Size(64, 21);
			this.aiV1.Text = "";
			// 
			// aiV0
			// 
			this.aiV0.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.aiV0.Location = new System.Drawing.Point(160, 32);
			this.aiV0.ReadOnly = true;
			this.aiV0.Size = new System.Drawing.Size(64, 21);
			this.aiV0.Text = "";
			// 
			// aiVoltageText
			// 
			this.aiVoltageText.Font = new System.Drawing.Font("Tahoma", 9F, ((System.Drawing.FontStyle)((System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline))));
			this.aiVoltageText.Location = new System.Drawing.Point(168, 8);
			this.aiVoltageText.Size = new System.Drawing.Size(56, 16);
			this.aiVoltageText.Text = "Voltage";
			this.aiVoltageText.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// aiText
			// 
			this.aiText.Font = new System.Drawing.Font("Tahoma", 9F, ((System.Drawing.FontStyle)((System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline))));
			this.aiText.Location = new System.Drawing.Point(128, 8);
			this.aiText.Size = new System.Drawing.Size(32, 16);
			this.aiText.Text = "AIN";
			this.aiText.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// noScansText
			// 
			this.noScansText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.noScansText.Location = new System.Drawing.Point(8, 8);
			this.noScansText.Size = new System.Drawing.Size(80, 16);
			this.noScansText.Text = "# of scans:";
			// 
			// noScansBox
			// 
			this.noScansBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.noScansBox.Location = new System.Drawing.Point(48, 24);
			this.noScansBox.ReadOnly = true;
			this.noScansBox.Size = new System.Drawing.Size(56, 21);
			this.noScansBox.Text = "";
			// 
			// totPacketsBox
			// 
			this.totPacketsBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.totPacketsBox.Location = new System.Drawing.Point(48, 72);
			this.totPacketsBox.ReadOnly = true;
			this.totPacketsBox.Size = new System.Drawing.Size(56, 21);
			this.totPacketsBox.Text = "";
			// 
			// TotPacketsText
			// 
			this.TotPacketsText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.TotPacketsText.Location = new System.Drawing.Point(8, 56);
			this.TotPacketsText.Size = new System.Drawing.Size(96, 16);
			this.TotPacketsText.Text = "Total packets:";
			// 
			// curPacketsBox
			// 
			this.curPacketsBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.curPacketsBox.Location = new System.Drawing.Point(48, 136);
			this.curPacketsBox.ReadOnly = true;
			this.curPacketsBox.Size = new System.Drawing.Size(56, 21);
			this.curPacketsBox.Text = "";
			// 
			// curPacketsText
			// 
			this.curPacketsText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.curPacketsText.Location = new System.Drawing.Point(8, 104);
			this.curPacketsText.Size = new System.Drawing.Size(104, 32);
			this.curPacketsText.Text = "Current PacketCounter:";
			// 
			// StreamTCPForm
			// 
			this.Controls.Add(this.curPacketsBox);
			this.Controls.Add(this.curPacketsText);
			this.Controls.Add(this.totPacketsBox);
			this.Controls.Add(this.TotPacketsText);
			this.Controls.Add(this.noScansBox);
			this.Controls.Add(this.noScansText);
			this.Controls.Add(this.ai3);
			this.Controls.Add(this.ai2);
			this.Controls.Add(this.ai1);
			this.Controls.Add(this.ai0);
			this.Controls.Add(this.aiV3);
			this.Controls.Add(this.aiV2);
			this.Controls.Add(this.aiV1);
			this.Controls.Add(this.aiV0);
			this.Controls.Add(this.aiVoltageText);
			this.Controls.Add(this.aiText);
			this.Controls.Add(this.statusText);
			this.Controls.Add(this.statusBox);
			this.Controls.Add(this.dot1);
			this.Controls.Add(this.ipLabel);
			this.Controls.Add(this.dot3);
			this.Controls.Add(this.dot2);
			this.Controls.Add(this.ip3);
			this.Controls.Add(this.ip0);
			this.Controls.Add(this.ip1);
			this.Controls.Add(this.ip2);
			this.Controls.Add(this.StreamButton);
			this.Menu = this.mainMenu1;
			this.MinimizeBox = false;
			this.Text = "ue9Stream TCP";
			this.Load += new System.EventHandler(this.StreamForm_Load);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>

		static void Main() 
		{
			Application.Run(new StreamTCPForm());
		}

		private void StreamForm_Load(object sender, System.EventArgs e)
		{
		
		}

		private void StreamButton_Click(object sender, System.EventArgs e)
		{
			int err = 0;
			string ipStr = null;
			Error errorText = new Error(); 
			ue9DevA = new ue9();
			ue9DevB = new ue9();
			statusBox.Text = "";
			noScansBox.Text = "";
			totPacketsBox.Text = "";
			curPacketsBox.Text = "";
			aiV0.Text = "";
			aiV1.Text = "";
			aiV2.Text = "";
			aiV3.Text = "";

			err = ue9.IPToString(ref ipStr, ip3.Text, ip2.Text, ip1.Text, ip0.Text);

			if( (err = ue9.IPToString(ref ipStr, ip3.Text, ip2.Text, ip1.Text, ip0.Text)) <= -1 )
			{
				statusBox.Text = errorText.getError(err);
				return;
			}

			if( (err = ue9DevA.openTCPConnection(ipStr, ue9_port_a)) <= -1 )
			{
				statusBox.Text = errorText.getError(err) + " (Port A)";
				return;
			}

			flushStream();

			if( (err = ue9DevB.openTCPConnection(ipStr, ue9_port_b)) <= -1)
			{				
				err = ue9DevA.closeTCPConnection();
				statusBox.Text = errorText.getError(err)  + " (Port B)";
				return;
			}

			if( (err = StreamConfig_example()) <= -1 )
			{			
				statusBox.Text = errorText.getError(err);
				if(err == -18)
					statusBox.Text += ue9DevA.errorcode;
				statusBox.Text += " (StreamConfig)";
				
				ue9DevA.closeTCPConnection();
				ue9DevB.closeTCPConnection();
				return;
			}

			if( (err = StreamStart()) <= -1)
			{
				statusBox.Text = errorText.getError(err);
				if(err == -18)
					statusBox.Text += ue9DevA.errorcode;
				statusBox.Text += " (StreamStart)";
				
				ue9DevA.closeTCPConnection();
				ue9DevB.closeTCPConnection();
				return;
			}

			statusBox.Text = "Reading Samples...";
			if((err = StreamData_example()) <= -1)
			{
				statusBox.Text = errorText.getError(err);
				if(err == -18)
					statusBox.Text += ue9DevB.errorcode;
				statusBox.Text += " (StreamData)";
				StreamStop();
				ue9DevA.closeTCPConnection();
				ue9DevB.closeTCPConnection();
				return;
			}

			statusBox.Text = "Done";

			if((err = StreamStop()) <= -1)
			{
				statusBox.Text = errorText.getError(err);
				if(err == -18)
					statusBox.Text += ue9DevB.errorcode;
				statusBox.Text += " (StreamStop)";
				ue9DevA.closeTCPConnection();
				ue9DevB.closeTCPConnection();
				return;
			}
	
			if( (err = ue9DevA.closeTCPConnection()) <= -1)
			{
				statusBox.Text = errorText.getError(err)  + " (Port A)";
				err = ue9DevB.closeTCPConnection();
				if(err <= -1)
					statusBox.Text += " and (Port B)";
					
				return;
			}
			
			if( (err = ue9DevB.closeTCPConnection()) <= -1)
				statusBox.Text = errorText.getError(err) + " (Port B)";
		}

		//stream is configured for reading only 4 analog inputs (AI0 - AI1)
		int StreamConfig_example()
		{
			byte []sendBuff = new byte[20];
			byte []recBuff = new byte[8];
			//int sendChars, recChars;
			ushort checksumTotal;

			sendBuff[1] = (byte)(0xF8);
			sendBuff[2] = (byte)(0x07);  //NumChannels + 3
			sendBuff[3] = (byte)(0x11);
			sendBuff[6] = (byte)(0x04);  //NumChannels = 4  
			sendBuff[7] = (byte)(0x0C);  //resolution = 12
			sendBuff[8] = (byte)(0x00);  //SettlingTime = 0
			sendBuff[9] = (byte)(0x00);  //ScanConfig: scan pulse and external scan trigger disabled
			//stream clock frequency = 4 MHz
			sendBuff[10] = (byte)(0xA0); 
			sendBuff[11] = (byte)(0x0F); //scan interval = 4000
			sendBuff[12] = (byte)(0x00); //channel # = 0
			sendBuff[13] = (byte)(0x00); //BipGain
			sendBuff[14] = (byte)(0x01); //channel # = 1
			sendBuff[15] = (byte)(0x00); //BipGain
			sendBuff[16] = (byte)(0x02); //channel # = 2
			sendBuff[17] = (byte)(0x00); //BipGain
			sendBuff[18] = (byte)(0x03); //channel # = 3
			sendBuff[19] = (byte)(0x00); //BipGain

			ue9DevA.extendedChecksum(ref sendBuff, 20);
			
			try
			{
				ue9DevA.Stream.Write(sendBuff, 0, 20);
			}
			catch(System.Exception)
			{
				return -14;
			}

			try
			{
				if(ue9DevA.Stream.Read(recBuff, 0, 8) != 8)
					throw(new Exception());
			}
			catch(System.Exception)
			{
				return -15;
			}

			checksumTotal = ue9DevA.extendedChecksum16(recBuff, 8);

			if( (byte)((checksumTotal >> 8) & 0xff) != recBuff[5])
				return -16;

			if( (byte)(checksumTotal & 0xff) != recBuff[4])
				return -16;

			if( ue9DevA.extendedChecksum8(recBuff) != recBuff[0])
				return -17;

			if( recBuff[1] != (byte)(0xF8) || recBuff[2] != (byte)(0x01) || recBuff[3] != (byte)(0x11) || recBuff[7] != (byte)(0x00))
				return -10;

			if(recBuff[6] != 0)
			{
				ue9DevA.errorcode = (int)recBuff[6];
				return -18;
			}

			return 0;
		}

		int StreamStart()
		{
			byte []sendBuff = new byte[2];
			byte []recBuff = new byte[4];
			//int sendChars, recChars;

			sendBuff[0] = (byte)(0xA8);
			sendBuff[1] = (byte)(0xA8);
  
			try
			{
				ue9DevA.Stream.Write(sendBuff, 0, 2);
			}
			catch(System.Exception)
			{
				return -14;
			}

			try
			{
				if(ue9DevA.Stream.Read(recBuff, 0, 4) != 4)
					throw(new Exception());
			}
			catch(System.Exception)
			{
				return -15;
			}

			if( recBuff[1] != (byte)(0xA9) || recBuff[3] != (byte)(0x00) )
				return -10;

			if(recBuff[2] != 0)
			{
				ue9DevA.errorcode = (int)recBuff[2];
				return -18;
			}

			return 0;
		}

		//The ue9 streamData function is called 125*timesDisplayed times.
		//All voltages from the sream are saved in the voltages 2D array
		int StreamData_example()
		{
			byte []recBuff = new byte[46];
			//int recChars;
			int packetCounter = 0, currChannel = 0, scanNumber = 0, totalPackets = 0;
			ushort checksumTotal = 0, voltageBytes;
			//union uShort readAI;
			double [ , ]voltages = new double[2500, 4];  //each packet contains 4 samples for each channel (4 channels)

			for (int i = 0; i < 5; i++)
			{
				for(int j = 0; j < 125; j++)	//reading 125 packets
				{
					try
					{
						if(ue9DevB.Stream.Read(recBuff, 0, 46) != 46)
							throw(new Exception());
					}
					catch(System.Exception)
					{
						return -15;
					}

					totalPackets++;
				
					checksumTotal = ue9DevB.extendedChecksum16(recBuff, 46);
					if( (byte)((checksumTotal >> 8) & 0xff) != recBuff[5])
						return -16;

					if( (byte)(checksumTotal & 0xff) != recBuff[4])
						return -16;

					checksumTotal = ue9DevB.extendedChecksum8(recBuff);
					if( checksumTotal != recBuff[0])
						return -17;
					
					if( recBuff[1] != (byte)(0xF9) || recBuff[2] != (byte)(0x14) || recBuff[3] != (byte)(0xC0) )
						return -10;
					
					if(recBuff[11] != 0)
					{
						ue9DevB.errorcode = (int)recBuff[11];
						return -18;
					}

					if(packetCounter != (int) recBuff[10])
						return -19;

					for(int k = 12; k <43; k+=2)
					{
						voltageBytes = (ushort)( (ushort)recBuff[k] + ((ushort)recBuff[k+1] << 8) );

						ue9DevB.translateUncalibratedVoltage((byte)(0x00), voltageBytes, ref (voltages[scanNumber, currChannel])); 
						currChannel++;
						if(currChannel > 3)
						{
							currChannel = 0;
							scanNumber++;
						}
					}

					if(packetCounter >= 255)
						packetCounter = 0;
					else
						packetCounter++;
				}
	
				noScansBox.Text = Convert.ToInt32(scanNumber).ToString();
				totPacketsBox.Text = Convert.ToInt32(totalPackets).ToString();
				curPacketsBox.Text = Convert.ToInt32(recBuff[10]).ToString();
	  
				aiV0.Text = string.Format("{0:f3}", voltages[scanNumber - 1, 0]);
				aiV1.Text = string.Format("{0:f3}", voltages[scanNumber - 1, 1]);
				aiV2.Text = string.Format("{0:f3}", voltages[scanNumber - 1, 2]);
				aiV3.Text = string.Format("{0:f3}", voltages[scanNumber - 1, 3]);
			}
			return 0;
		}

		int StreamStop()
		{
			byte []sendBuff = new byte[2];
			byte []recBuff = new byte[4];

			sendBuff[0] = (byte)(0xB0);
			sendBuff[1] = (byte)(0xB0);
  
			try
			{
				ue9DevA.Stream.Write(sendBuff, 0, 2);
			}
			catch(System.Exception)
			{
				return -14;
			}

			try
			{
				if(ue9DevA.Stream.Read(recBuff, 0, 4) != 4)
					throw(new Exception());
			}
			catch(System.Exception)
			{
				return -15;
			}

			if( recBuff[1] != (byte)(0xB1) || recBuff[3] != (byte)(0x00) )
				return -10;

			if(recBuff[2] != 0)
			{
				ue9DevA.errorcode = (int)recBuff[2];
				return -18;
			}

			return 0;
		}

		int flushStream()
		{
			byte []sendBuff = new byte[2];
			byte []recBuff = new byte[2];
			sendBuff[0] = (byte)(0x08);
			sendBuff[1] = (byte)(0x08);
   
			try
			{
				ue9DevA.Stream.Write(sendBuff, 0, 2);
			}
			catch(System.Exception)
			{
				return -14;
			}

			try
			{
				if(ue9DevA.Stream.Read(recBuff, 0, 2) != 2)
					throw(new Exception());
			}
			catch(System.Exception)
			{
				return -15;
			}

			if(recBuff[0] != (byte)(0x08) || recBuff[1] != (byte)(0x08))
				return -10;
			
			return 0;  
		}
	}
}
