//Author: LabJack
//October 10, 2005
//This example program calls the Feedback function in a continuous loop. 
//It will read the voltages from AIN0-AIN3, set and read the states  
//and directions from FIO0 - FIO3,  and set DAC0 and DAC1.  The first screen 
//to appear will get the IP address.   

using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Data;
using System.Threading;

namespace ue9
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class FeedbackTCPForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.TextBox errorBox;
		private System.Windows.Forms.Label fio3;
		private System.Windows.Forms.Label fio2;
		private System.Windows.Forms.Label fio1;
		private System.Windows.Forms.Label fioDirText;
		private System.Windows.Forms.Label fioStateText;
		private System.Windows.Forms.Label fioText;
		private System.Windows.Forms.Label dac0Text;
		private System.Windows.Forms.CheckBox dir0Check;
		private System.Windows.Forms.Label dac1Text;
		private System.Windows.Forms.CheckBox state3Check;
		private System.Windows.Forms.CheckBox state2Check;
		private System.Windows.Forms.CheckBox state1Check;
		private System.Windows.Forms.CheckBox state0Check;
		private System.Windows.Forms.CheckBox dir1Check;
		private System.Windows.Forms.CheckBox dir3Check;
		private System.Windows.Forms.CheckBox dir2Check;
		private System.Windows.Forms.TextBox dac0Box;
		private System.Windows.Forms.TextBox dac1Box;
		private System.Windows.Forms.Button decDAC0Button;
		private System.Windows.Forms.Button incDAC0Button;
		private System.Windows.Forms.Button incDAC1Button;
		private System.Windows.Forms.Button decDAC1Button;
		private System.Windows.Forms.Label ain3;
		private System.Windows.Forms.Label ain2;
		private System.Windows.Forms.Label ain1;
		private System.Windows.Forms.Label ain0;
		private System.Windows.Forms.Label ainVoltageText;
		private System.Windows.Forms.Label ainText;
		private System.Windows.Forms.Label fio0;
		private System.Windows.Forms.TextBox ain3V;
		private System.Windows.Forms.TextBox ain2V;
		private System.Windows.Forms.TextBox ain1V;
		private System.Windows.Forms.TextBox ain0V;
		
		private Mutex dac0Mut = new Mutex();
		private Mutex dac1Mut = new Mutex();
		private Thread fbThread;
		private ue9 ue9Dev;
		private bool close = false;
		private bool done = false;
		private bool openDevice = true;
		private bool state0Value;
		private bool state1Value;
		private bool state2Value;
		private bool state3Value;
		private double ainSlope = 0;
		private double ainOffset = 0;
		private double dac0Slope = 0;
		private double dac0Offset = 0;
		private double dac1Slope = 0;
		private double dac1Offset = 0;		
		private double dac0Value = 0;
		private double dac1Value = 0;
		private string errorBoxText;
		private string ain0VoltText;
		private string ain1VoltText;
		private string ain2VoltText;
		private System.Windows.Forms.Panel dacPanel;
		private System.Windows.Forms.Panel ainPanel;
		private System.Windows.Forms.Panel fioPanel;
		private string ain3VoltText;
		private const int ue9_port = 52360;
		private IPPopUp ipPop = new IPPopUp();
		private System.Windows.Forms.Label statusLabel;
		private string IPAddress = "";

		public FeedbackTCPForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			
		}
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.statusLabel = new System.Windows.Forms.Label();
			this.errorBox = new System.Windows.Forms.TextBox();
			this.fio3 = new System.Windows.Forms.Label();
			this.fio2 = new System.Windows.Forms.Label();
			this.fio1 = new System.Windows.Forms.Label();
			this.fio0 = new System.Windows.Forms.Label();
			this.fioDirText = new System.Windows.Forms.Label();
			this.fioStateText = new System.Windows.Forms.Label();
			this.fioText = new System.Windows.Forms.Label();
			this.ain3 = new System.Windows.Forms.Label();
			this.ain2 = new System.Windows.Forms.Label();
			this.ain1 = new System.Windows.Forms.Label();
			this.ain0 = new System.Windows.Forms.Label();
			this.ain3V = new System.Windows.Forms.TextBox();
			this.ain2V = new System.Windows.Forms.TextBox();
			this.ain1V = new System.Windows.Forms.TextBox();
			this.ain0V = new System.Windows.Forms.TextBox();
			this.ainVoltageText = new System.Windows.Forms.Label();
			this.ainText = new System.Windows.Forms.Label();
			this.dac0Text = new System.Windows.Forms.Label();
			this.dac1Text = new System.Windows.Forms.Label();
			this.dir0Check = new System.Windows.Forms.CheckBox();
			this.dir1Check = new System.Windows.Forms.CheckBox();
			this.dir3Check = new System.Windows.Forms.CheckBox();
			this.dir2Check = new System.Windows.Forms.CheckBox();
			this.state3Check = new System.Windows.Forms.CheckBox();
			this.state2Check = new System.Windows.Forms.CheckBox();
			this.state1Check = new System.Windows.Forms.CheckBox();
			this.state0Check = new System.Windows.Forms.CheckBox();
			this.dac0Box = new System.Windows.Forms.TextBox();
			this.dac1Box = new System.Windows.Forms.TextBox();
			this.decDAC0Button = new System.Windows.Forms.Button();
			this.incDAC0Button = new System.Windows.Forms.Button();
			this.incDAC1Button = new System.Windows.Forms.Button();
			this.decDAC1Button = new System.Windows.Forms.Button();
			this.dacPanel = new System.Windows.Forms.Panel();
			this.ainPanel = new System.Windows.Forms.Panel();
			this.fioPanel = new System.Windows.Forms.Panel();
			// 
			// statusLabel
			// 
			this.statusLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.statusLabel.Location = new System.Drawing.Point(8, 232);
			this.statusLabel.Size = new System.Drawing.Size(48, 20);
			this.statusLabel.Text = "Error:";
			// 
			// errorBox
			// 
			this.errorBox.BackColor = System.Drawing.Color.Silver;
			this.errorBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold);
			this.errorBox.Location = new System.Drawing.Point(56, 232);
			this.errorBox.Size = new System.Drawing.Size(176, 21);
			this.errorBox.Text = "";
			// 
			// fio3
			// 
			this.fio3.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.fio3.Location = new System.Drawing.Point(16, 104);
			this.fio3.Size = new System.Drawing.Size(16, 16);
			this.fio3.Text = "3";
			// 
			// fio2
			// 
			this.fio2.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.fio2.Location = new System.Drawing.Point(16, 80);
			this.fio2.Size = new System.Drawing.Size(16, 16);
			this.fio2.Text = "2";
			// 
			// fio1
			// 
			this.fio1.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.fio1.Location = new System.Drawing.Point(16, 56);
			this.fio1.Size = new System.Drawing.Size(16, 16);
			this.fio1.Text = "1";
			// 
			// fio0
			// 
			this.fio0.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.fio0.Location = new System.Drawing.Point(16, 32);
			this.fio0.Size = new System.Drawing.Size(16, 16);
			this.fio0.Text = "0";
			// 
			// fioDirText
			// 
			this.fioDirText.Font = new System.Drawing.Font("Tahoma", 9F, ((System.Drawing.FontStyle)((System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline))));
			this.fioDirText.Location = new System.Drawing.Point(32, 8);
			this.fioDirText.Size = new System.Drawing.Size(24, 16);
			this.fioDirText.Text = "Dir";
			this.fioDirText.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// fioStateText
			// 
			this.fioStateText.Font = new System.Drawing.Font("Tahoma", 9F, ((System.Drawing.FontStyle)((System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline))));
			this.fioStateText.Location = new System.Drawing.Point(56, 8);
			this.fioStateText.Size = new System.Drawing.Size(40, 16);
			this.fioStateText.Text = "State";
			this.fioStateText.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// fioText
			// 
			this.fioText.Font = new System.Drawing.Font("Tahoma", 9F, ((System.Drawing.FontStyle)((System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline))));
			this.fioText.Location = new System.Drawing.Point(8, 8);
			this.fioText.Size = new System.Drawing.Size(28, 16);
			this.fioText.Text = "FIO";
			// 
			// ain3
			// 
			this.ain3.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ain3.Location = new System.Drawing.Point(16, 104);
			this.ain3.Size = new System.Drawing.Size(16, 16);
			this.ain3.Text = "3";
			// 
			// ain2
			// 
			this.ain2.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ain2.Location = new System.Drawing.Point(16, 80);
			this.ain2.Size = new System.Drawing.Size(16, 16);
			this.ain2.Text = "2";
			// 
			// ain1
			// 
			this.ain1.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ain1.Location = new System.Drawing.Point(16, 56);
			this.ain1.Size = new System.Drawing.Size(16, 16);
			this.ain1.Text = "1";
			// 
			// ain0
			// 
			this.ain0.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ain0.Location = new System.Drawing.Point(16, 32);
			this.ain0.Size = new System.Drawing.Size(16, 16);
			this.ain0.Text = "0";
			// 
			// ain3V
			// 
			this.ain3V.Location = new System.Drawing.Point(40, 104);
			this.ain3V.Size = new System.Drawing.Size(64, 22);
			this.ain3V.Text = "";
			// 
			// ain2V
			// 
			this.ain2V.Location = new System.Drawing.Point(40, 80);
			this.ain2V.Size = new System.Drawing.Size(64, 22);
			this.ain2V.Text = "";
			// 
			// ain1V
			// 
			this.ain1V.Location = new System.Drawing.Point(40, 56);
			this.ain1V.Size = new System.Drawing.Size(64, 22);
			this.ain1V.Text = "";
			// 
			// ain0V
			// 
			this.ain0V.Location = new System.Drawing.Point(40, 32);
			this.ain0V.Size = new System.Drawing.Size(64, 22);
			this.ain0V.Text = "";
			// 
			// ainVoltageText
			// 
			this.ainVoltageText.Font = new System.Drawing.Font("Tahoma", 9F, ((System.Drawing.FontStyle)((System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline))));
			this.ainVoltageText.Location = new System.Drawing.Point(32, 8);
			this.ainVoltageText.Size = new System.Drawing.Size(78, 16);
			this.ainVoltageText.Text = "Voltage";
			this.ainVoltageText.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// ainText
			// 
			this.ainText.Font = new System.Drawing.Font("Tahoma", 9F, ((System.Drawing.FontStyle)((System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline))));
			this.ainText.Location = new System.Drawing.Point(8, 8);
			this.ainText.Size = new System.Drawing.Size(28, 16);
			this.ainText.Text = "AIN";
			this.ainText.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// dac0Text
			// 
			this.dac0Text.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.dac0Text.Location = new System.Drawing.Point(8, 8);
			this.dac0Text.Size = new System.Drawing.Size(72, 16);
			this.dac0Text.Text = "DAC0 (V): ";
			// 
			// dac1Text
			// 
			this.dac1Text.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.dac1Text.Location = new System.Drawing.Point(8, 40);
			this.dac1Text.Size = new System.Drawing.Size(72, 16);
			this.dac1Text.Text = "DAC1 (V): ";
			// 
			// dir0Check
			// 
			this.dir0Check.Location = new System.Drawing.Point(40, 32);
			this.dir0Check.Size = new System.Drawing.Size(16, 20);
			// 
			// dir1Check
			// 
			this.dir1Check.Location = new System.Drawing.Point(40, 56);
			this.dir1Check.Size = new System.Drawing.Size(16, 20);
			// 
			// dir3Check
			// 
			this.dir3Check.Location = new System.Drawing.Point(40, 104);
			this.dir3Check.Size = new System.Drawing.Size(16, 20);
			// 
			// dir2Check
			// 
			this.dir2Check.Location = new System.Drawing.Point(40, 80);
			this.dir2Check.Size = new System.Drawing.Size(16, 20);
			// 
			// state3Check
			// 
			this.state3Check.Location = new System.Drawing.Point(72, 104);
			this.state3Check.Size = new System.Drawing.Size(16, 20);
			// 
			// state2Check
			// 
			this.state2Check.Location = new System.Drawing.Point(72, 80);
			this.state2Check.Size = new System.Drawing.Size(16, 20);
			// 
			// state1Check
			// 
			this.state1Check.Location = new System.Drawing.Point(72, 56);
			this.state1Check.Size = new System.Drawing.Size(16, 20);
			// 
			// state0Check
			// 
			this.state0Check.Location = new System.Drawing.Point(72, 32);
			this.state0Check.Size = new System.Drawing.Size(16, 20);
			// 
			// dac0Box
			// 
			this.dac0Box.AcceptsReturn = true;
			this.dac0Box.Location = new System.Drawing.Point(80, 8);
			this.dac0Box.Size = new System.Drawing.Size(64, 22);
			this.dac0Box.Text = "0.000";
			this.dac0Box.Validating += new System.ComponentModel.CancelEventHandler(this.dac0Box_Validating);
			// 
			// dac1Box
			// 
			this.dac1Box.AcceptsReturn = true;
			this.dac1Box.Location = new System.Drawing.Point(80, 40);
			this.dac1Box.Size = new System.Drawing.Size(64, 22);
			this.dac1Box.Text = "0.000";
			this.dac1Box.Validating += new System.ComponentModel.CancelEventHandler(this.dac1Box_Validating);
			// 
			// decDAC0Button
			// 
			this.decDAC0Button.Font = new System.Drawing.Font("Tahoma", 9.75F, System.Drawing.FontStyle.Bold);
			this.decDAC0Button.Location = new System.Drawing.Point(184, 8);
			this.decDAC0Button.Size = new System.Drawing.Size(24, 24);
			this.decDAC0Button.Text = "-";
			this.decDAC0Button.Click += new System.EventHandler(this.decDAC0Button_Click);
			// 
			// incDAC0Button
			// 
			this.incDAC0Button.Font = new System.Drawing.Font("Tahoma", 9.75F, System.Drawing.FontStyle.Bold);
			this.incDAC0Button.Location = new System.Drawing.Point(152, 8);
			this.incDAC0Button.Size = new System.Drawing.Size(24, 24);
			this.incDAC0Button.Text = "+";
			this.incDAC0Button.Click += new System.EventHandler(this.incDAC0Button_Click);
			// 
			// incDAC1Button
			// 
			this.incDAC1Button.Font = new System.Drawing.Font("Tahoma", 9.75F, System.Drawing.FontStyle.Bold);
			this.incDAC1Button.Location = new System.Drawing.Point(152, 40);
			this.incDAC1Button.Size = new System.Drawing.Size(24, 24);
			this.incDAC1Button.Text = "+";
			this.incDAC1Button.Click += new System.EventHandler(this.incDAC1Button_Click);
			// 
			// decDAC1Button
			// 
			this.decDAC1Button.Font = new System.Drawing.Font("Tahoma", 9.75F, System.Drawing.FontStyle.Bold);
			this.decDAC1Button.Location = new System.Drawing.Point(184, 40);
			this.decDAC1Button.Size = new System.Drawing.Size(24, 24);
			this.decDAC1Button.Text = "-";
			this.decDAC1Button.Click += new System.EventHandler(this.decDAC1Button_Click);
			// 
			// dacPanel
			// 
			this.dacPanel.BackColor = System.Drawing.Color.White;
			this.dacPanel.Controls.Add(this.dac0Text);
			this.dacPanel.Controls.Add(this.dac1Text);
			this.dacPanel.Controls.Add(this.decDAC1Button);
			this.dacPanel.Controls.Add(this.incDAC1Button);
			this.dacPanel.Controls.Add(this.incDAC0Button);
			this.dacPanel.Controls.Add(this.decDAC0Button);
			this.dacPanel.Controls.Add(this.dac1Box);
			this.dacPanel.Controls.Add(this.dac0Box);
			this.dacPanel.Location = new System.Drawing.Point(8, 8);
			this.dacPanel.Size = new System.Drawing.Size(224, 72);
			// 
			// ainPanel
			// 
			this.ainPanel.BackColor = System.Drawing.Color.White;
			this.ainPanel.Controls.Add(this.ainText);
			this.ainPanel.Controls.Add(this.ainVoltageText);
			this.ainPanel.Controls.Add(this.ain2);
			this.ainPanel.Controls.Add(this.ain1V);
			this.ainPanel.Controls.Add(this.ain2V);
			this.ainPanel.Controls.Add(this.ain3V);
			this.ainPanel.Controls.Add(this.ain0);
			this.ainPanel.Controls.Add(this.ain1);
			this.ainPanel.Controls.Add(this.ain0V);
			this.ainPanel.Controls.Add(this.ain3);
			this.ainPanel.Location = new System.Drawing.Point(120, 88);
			this.ainPanel.Size = new System.Drawing.Size(112, 136);
			// 
			// fioPanel
			// 
			this.fioPanel.BackColor = System.Drawing.Color.White;
			this.fioPanel.Controls.Add(this.dir2Check);
			this.fioPanel.Controls.Add(this.dir0Check);
			this.fioPanel.Controls.Add(this.fio2);
			this.fioPanel.Controls.Add(this.fio1);
			this.fioPanel.Controls.Add(this.fio0);
			this.fioPanel.Controls.Add(this.dir3Check);
			this.fioPanel.Controls.Add(this.state1Check);
			this.fioPanel.Controls.Add(this.fioText);
			this.fioPanel.Controls.Add(this.fioStateText);
			this.fioPanel.Controls.Add(this.fioDirText);
			this.fioPanel.Controls.Add(this.dir1Check);
			this.fioPanel.Controls.Add(this.state0Check);
			this.fioPanel.Controls.Add(this.fio3);
			this.fioPanel.Controls.Add(this.state2Check);
			this.fioPanel.Controls.Add(this.state3Check);
			this.fioPanel.Location = new System.Drawing.Point(8, 88);
			this.fioPanel.Size = new System.Drawing.Size(104, 136);
			// 
			// FeedbackTCPForm
			// 
			this.BackColor = System.Drawing.Color.Silver;
			this.Controls.Add(this.fioPanel);
			this.Controls.Add(this.ainPanel);
			this.Controls.Add(this.dacPanel);
			this.Controls.Add(this.statusLabel);
			this.Controls.Add(this.errorBox);
			this.Menu = this.mainMenu1;
			this.MinimizeBox = false;
			this.Text = "ue9Feedback TCP";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FeedbackUSBForm_Closing);
			this.Load += new System.EventHandler(this.FeedbackForm_Load);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>

		static void Main() 
		{
			Application.Run(new FeedbackTCPForm());
		}

		private void FeedbackForm_Load(object sender, System.EventArgs e)
		{
			this.Show();
			Application.DoEvents();

			ipPop.ShowDialog();
			
			if(ipPop.DialogResult == DialogResult.No)
			{
				done = true;
				this.Close();
				return;
			}

			IPAddress = ipPop.IPAddress;

			fbThread = new Thread(new ThreadStart(feedbackLoop));
			fbThread.Start();
		}

		private void feedbackLoop()
		{
			int err = 0;
			Error errorText = new Error(); 
			ue9Dev = new ue9();
			openDevice = true;

			

			while(close == false)
			{
				try
				{
					Thread.Sleep(1000);
					if(openDevice == true)
					{
						if((err = ue9Dev.openTCPConnection(IPAddress, ue9_port)) < 0)
						{
							errorBoxText = errorText.getError(err);
							this.Invoke(new EventHandler(UpdateErrorBoxText));
							continue;
						}
					
						try
						{
							if((err = ue9Dev.getAnalogCalibrationInfo((byte)(0x08), ref ainSlope, ref ainOffset)) < 0)
								throw new Exception();

							if((err = ue9Dev.getDACCalibrationInfo(ref dac0Slope, ref dac0Offset, ref dac1Slope, ref dac1Offset)) < 0)
								throw new Exception();
						}
						catch(Exception)
						{
							openDevice = true;
							errorBoxText = "Error getting analog calibration info ";//:" + err;
							this.Invoke(new EventHandler(UpdateErrorBoxText));
							ue9Dev.closeTCPConnection();
							continue;
						}

						openDevice = false;
						errorBoxText = "";
						this.Invoke(new EventHandler(UpdateErrorBoxText));
					}

					if( (err = feedback_example()) <= -1)
					{
						openDevice = true;
						errorBoxText = errorText.getError(err);
						this.Invoke(new EventHandler(UpdateErrorBoxText));
						ue9Dev.closeTCPConnection();	
					}
				}
				catch(Exception n)
				{
					openDevice = true;
					errorBoxText = n.ToString();
					this.Invoke(new EventHandler(UpdateErrorBoxText));
					ue9Dev.closeTCPConnection();					
				}
				
			}

			if(openDevice == false)
			{
				ue9Dev.closeTCPConnection();
			}
		
			done = true;
			this.Invoke(new EventHandler(CloseForm));
		}	

		private int feedback_example()
		{
			Thread feedbackRWThread;
			int sleepCount;
			//byte []sendBuff = new byte[34];
			//byte []recBuff = new byte[64];
			ushort checksumTotal = 0;
			ushort voltageBitsS = 0;
			double voltageBitsD = 0;

			ue9Dev.sendRecBuffer = new byte[34];	//Using this buffer to use a seperate
													//thread for write
			ue9Dev.sendRecSize = 34;

			ue9Dev.sendRecBuffer[1] = (byte)(0xF8);
			ue9Dev.sendRecBuffer[2] = (byte)(0x0E);  
			ue9Dev.sendRecBuffer[3] = (byte)(0x00);  
			ue9Dev.sendRecBuffer[6] = (byte)(0x0f);  //set direction and state for FIO0-FIO4

			//set directions of FIO0-FIO4
			ue9Dev.sendRecBuffer[7] = Convert.ToByte(
				Convert.ToByte(dir0Check.Checked) + 
				(Convert.ToByte(dir1Check.Checked) << 1) + 
				(Convert.ToByte(dir2Check.Checked) << 2) + 
				(Convert.ToByte(dir3Check.Checked) << 3));
			
			//set states of FIO0-FIO4
			ue9Dev.sendRecBuffer[8] = Convert.ToByte(
				Convert.ToByte(state0Check.Checked) + 
				(Convert.ToByte(state1Check.Checked) << 1) + 
				(Convert.ToByte(state2Check.Checked) << 2) + 
				(Convert.ToByte(state3Check.Checked) << 3));
			
			for(int i = 9; i <= 15; i++)
				ue9Dev.sendRecBuffer[i] = (byte)(0x00);

			//Enabling, updating and setting the voltage for DAC0
			dac0Mut.WaitOne();
			voltageBitsD = dac0Slope*dac0Value + dac0Offset;
			checkVoltageBitsDouble(ref voltageBitsD);
			voltageBitsS = Convert.ToUInt16(voltageBitsD);
			ue9Dev.sendRecBuffer[16] = (byte)(voltageBitsS & (ushort)0xff);
			ue9Dev.sendRecBuffer[17] = Convert.ToByte( ((voltageBitsS >> 8) & (ushort)0xff) + (ushort)0xc0);
			dac0Mut.ReleaseMutex();

			//Enabling, updating and setting the voltage for DAC1
			dac1Mut.WaitOne();
			voltageBitsD = dac1Slope*dac1Value + dac1Offset;
			checkVoltageBitsDouble(ref voltageBitsD);
			voltageBitsS = Convert.ToUInt16(voltageBitsD);
			ue9Dev.sendRecBuffer[18] = (byte)(voltageBitsS & (ushort)0xff);
			ue9Dev.sendRecBuffer[19] = Convert.ToByte( ((voltageBitsS >> 8) & (ushort)0xff) + (ushort)0xc0);
			dac1Mut.ReleaseMutex();

			ue9Dev.sendRecBuffer[20] = (byte)(0x0f);  //read AI0 - AI3
			ue9Dev.sendRecBuffer[21] = (byte)(0x00);
			ue9Dev.sendRecBuffer[22] = (byte)(0x00);
			ue9Dev.sendRecBuffer[23] = (byte)(0x00);
			ue9Dev.sendRecBuffer[24] = (byte)(0x11);  //resolution = 17
			ue9Dev.sendRecBuffer[25] = (byte)(0x00);
			ue9Dev.sendRecBuffer[26] = (byte)(0x88);
			ue9Dev.sendRecBuffer[27] = (byte)(0x88);

			for(int i = 28; i < 34; i++)
				ue9Dev.sendRecBuffer[i] = (byte)(0x00);

			ue9Dev.extendedChecksum(ref ue9Dev.sendRecBuffer, 34);
  
			try
			{
				//Using a new thread to write to UE9.  This is done so that a
				//timeout can be applied, otherwise the TcpClient.Write command
				//takes around 40 seconds to timeout.
				ue9Dev.sendRecDone = false;
				feedbackRWThread = new Thread(new ThreadStart(ue9Dev.write));
				feedbackRWThread.Start();

				sleepCount = 0;
				
				while(sleepCount < 2000)
				{
					if(ue9Dev.sendRecDone == true)
						break;
					Thread.Sleep(250);
					sleepCount += 250;
				}

				if(ue9Dev.sendRecDone == false)
				{
					ue9Dev.closeTCPConnection();
					throw new Exception();
				}
			}
			catch(System.Exception)
			{
				return -14;
			}

			ue9Dev.sendRecBuffer = new byte[64];	//Using this buffer to use a seperate
													//thread for read
			ue9Dev.sendRecSize = 64;

			try
			{
				//Using a new thread to read from the UE9.  This is done so that a
				//timeout can be applied, otherwise the TcpClient.Write command
				//takes around 40 seconds to timeout.
				ue9Dev.sendRecDone = false;
				feedbackRWThread = new Thread(new ThreadStart(ue9Dev.read));
				feedbackRWThread.Start();

				sleepCount = 0;
				while(sleepCount < 2000)
				{					
					if(ue9Dev.sendRecDone == true)
						break;

					Thread.Sleep(250);
					sleepCount += 250;
				}

				if(ue9Dev.sendRecDone == false)
				{
					ue9Dev.closeTCPConnection();
					throw new Exception();
				}
			}
			catch(System.Exception)
			{
				return -15;
			}

			checksumTotal = ue9Dev.extendedChecksum16(ue9Dev.sendRecBuffer, 64);
			
			if( (byte)((checksumTotal >> 8) & 0xff) != ue9Dev.sendRecBuffer[5])
				return -16;

			if( (byte)(checksumTotal & 0xff) != ue9Dev.sendRecBuffer[4])
				return -16;

			if( ue9Dev.extendedChecksum8(ue9Dev.sendRecBuffer) != ue9Dev.sendRecBuffer[0])
				return -17;

			if(ue9Dev.sendRecBuffer[1] != (byte)(0xF8) || ue9Dev.sendRecBuffer[2] != (byte)(0x1D) || ue9Dev.sendRecBuffer[3] != (byte)(0x00))
				return -10;
		
			state0Value = Convert.ToBoolean( ue9Dev.sendRecBuffer[7] & (0x01));
			state1Value = Convert.ToBoolean( (ue9Dev.sendRecBuffer[7] >> 1) & (0x01));
			state2Value = Convert.ToBoolean( (ue9Dev.sendRecBuffer[7] >> 2) & (0x01));
			state3Value = Convert.ToBoolean( (ue9Dev.sendRecBuffer[7] >> 3) & (0x01));

			this.Invoke(new EventHandler(this.UpdateStateValues));

			ain0VoltText = string.Format("{0:f4}", (ainSlope * ( (ushort)( (ushort)ue9Dev.sendRecBuffer[12] + ((ushort)ue9Dev.sendRecBuffer[13] << 8) ) ) + ainOffset)) + " V";
			ain1VoltText = string.Format("{0:f4}", (ainSlope * ( (ushort)( (ushort)ue9Dev.sendRecBuffer[14] + ((ushort)ue9Dev.sendRecBuffer[15] << 8) ) ) + ainOffset)) + " V";
			ain2VoltText = string.Format("{0:f4}", (ainSlope * ( (ushort)( (ushort)ue9Dev.sendRecBuffer[16] + ((ushort)ue9Dev.sendRecBuffer[17] << 8) ) ) + ainOffset)) + " V";
			ain3VoltText = string.Format("{0:f4}", (ainSlope * ( (ushort)( (ushort)ue9Dev.sendRecBuffer[18] + ((ushort)ue9Dev.sendRecBuffer[19] << 8) ) ) + ainOffset)) + " V";
			
			this.Invoke(new EventHandler(this.UpdateAINVoltBoxText));

			return 0;
		}

		

		private void checkVoltageBitsDouble(ref double voltageBits)
		{
			if(voltageBits < 0)
				voltageBits = 0.0;
			
			if(voltageBits > 4095)
				voltageBits = 4095.0;
		}

		private void incDAC0Button_Click(object sender, System.EventArgs e)
		{			
			try
			{
		
				if(dac0Value == 5)
				{}
				else if(dac0Value + 0.2 > 5.0)
				{
					dac0Value = 5.0;
					dac0Box.Text = string.Format("{0:f3}", dac0Value);
					dac0Box.Update();
				}
				else
				{
					dac0Value += 0.2;
					dac0Box.Text = string.Format("{0:f3}", dac0Value);
					dac0Box.Update();
				}
			}
			catch
			{}
		}

		private void decDAC0Button_Click(object sender, System.EventArgs e)
		{
			try
			{
				if(dac0Value == 0)
				{}
				else if(dac0Value - 0.2 < 0.0)
				{
					dac0Value = 0.0;
					dac0Box.Text = string.Format("{0:f3}", dac0Value);
					dac0Box.Update();
				}
				else
				{
					dac0Value -= 0.2;
					dac0Box.Text = string.Format("{0:f3}", dac0Value);
					dac0Box.Update();
				}
			}
			catch
			{}
		}

		private void incDAC1Button_Click(object sender, System.EventArgs e)
		{
			try
			{
				if(dac1Value == 5)
				{}
				else if(dac1Value + 0.2 > 5.0)
				{
					dac1Value = 5.0;
					dac1Box.Text = string.Format("{0:f3}", dac1Value);
					dac1Box.Update();
				}
				else
				{
					dac1Value += 0.2;
					dac1Box.Text = string.Format("{0:f3}", dac1Value);
					dac1Box.Update();
				}
			}
			catch{}
		}

		private void decDAC1Button_Click(object sender, System.EventArgs e)
		{
			try
			{
				if(dac1Value == 0)
				{
					return;
				}
				else if(dac1Value - 0.2 < 0.0)
				{
					dac1Value = 0.0;
					dac1Box.Text = string.Format("{0:f3}", dac1Value);
					dac1Box.Update();
				}
				else
				{
					dac1Value -= 0.2;
					dac1Box.Text = string.Format("{0:f3}", dac1Value);
					dac1Box.Update();
				}
			}
			catch{}
		}

		private void dac0Box_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			double dac0Conv = 0;
			dac0Mut.WaitOne();
			try
			{
				if((dac0Conv = Convert.ToDouble(dac0Box.Text)) != dac0Value)
				{
					if(dac0Conv > 5.0 || dac0Conv < 0.0)
						throw new Exception();

					dac0Value = dac0Conv;
					dac0Box.Text = string.Format("{0:f3}", dac0Value);
				}
			}
			catch
			{
				dac0Box.Text = string.Format("{0:f3}", dac0Value);
			}
			dac0Mut.ReleaseMutex();
		}

		private void dac1Box_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			double dac1Conv = 0;
		
			dac1Mut.WaitOne();
			try
			{
				if((dac1Conv = Convert.ToDouble(dac1Box.Text)) != dac1Value)
				{
					if(dac1Conv > 5.0 || dac1Conv < 0.0)
						throw new Exception();

					dac1Value = dac1Conv;
					dac1Box.Text = string.Format("{0:f3}", dac1Value);
				}
			}
			catch
			{
				dac1Box.Text = string.Format("{0:f3}", dac1Value);
			}
			dac1Mut.ReleaseMutex();
			
		}	
	
		private void UpdateErrorBoxText(object sender, System.EventArgs e)
		{
			errorBox.Text = errorBoxText;
			errorBox.Update();
		}

		private void UpdateAINVoltBoxText(object sender, System.EventArgs e)
		{
			ain0V.Text = ain0VoltText;
			ain1V.Text = ain1VoltText;
			ain2V.Text = ain2VoltText;
			ain3V.Text = ain3VoltText;
			ain0.Update();
			ain1.Update();
			ain2.Update();
			ain3.Update();
		}

		private void UpdateStateValues(object sender, System.EventArgs e)
		{
			state0Check.Checked = state0Value;
			state1Check.Checked = state1Value;
			state2Check.Checked = state2Value;
			state3Check.Checked = state3Value;
			state0Check.Update();
			state1Check.Update();
			state2Check.Update();
			state3Check.Update();
		}

		private void CloseForm(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void FeedbackUSBForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			close = true;
			
			if(done != true)
				e.Cancel = true;
		}
	}
}
