//Author: LabJack
//July 18, 2007
//This example program reads analog inputs AI0 - AI3 using stream mode.
//(Tested with Comm. Firmware 1.36 and above)

using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using LabJack;

namespace ue9Stream
{
	public class StreamForm : System.Windows.Forms.Form
	{
		private UE9 ue9Dev;
		private System.Windows.Forms.Button StreamButton;
		private System.Windows.Forms.Label statusText;
		private System.Windows.Forms.Label ai3;
		private System.Windows.Forms.Label ai2;
		private System.Windows.Forms.Label ai1;
		private System.Windows.Forms.Label ai0;
		private System.Windows.Forms.TextBox aiV3;
		private System.Windows.Forms.TextBox aiV2;
		private System.Windows.Forms.TextBox aiV1;
		private System.Windows.Forms.TextBox aiV0;
		private System.Windows.Forms.Label aiVoltageText;
		private System.Windows.Forms.Label aiText;
		private System.Windows.Forms.Label noScansText;
		private System.Windows.Forms.TextBox noScansBox;
		private System.Windows.Forms.TextBox totPacketsBox;
		private System.Windows.Forms.Label TotPacketsText;
		private System.Windows.Forms.TextBox curPacketsBox;
		private System.Windows.Forms.Label curPacketsText;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.Label idLabel;
		private System.Windows.Forms.NumericUpDown idBox;
		private System.Windows.Forms.TextBox statusBox;		
		private bool flushDone;
		private byte resolution = 12;
		
		public StreamForm()
		{
			InitializeComponent();
		}
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.StreamButton = new System.Windows.Forms.Button();
			this.idLabel = new System.Windows.Forms.Label();
			this.statusText = new System.Windows.Forms.Label();
			this.statusBox = new System.Windows.Forms.TextBox();
			this.ai3 = new System.Windows.Forms.Label();
			this.ai2 = new System.Windows.Forms.Label();
			this.ai1 = new System.Windows.Forms.Label();
			this.ai0 = new System.Windows.Forms.Label();
			this.aiV3 = new System.Windows.Forms.TextBox();
			this.aiV2 = new System.Windows.Forms.TextBox();
			this.aiV1 = new System.Windows.Forms.TextBox();
			this.aiV0 = new System.Windows.Forms.TextBox();
			this.aiVoltageText = new System.Windows.Forms.Label();
			this.aiText = new System.Windows.Forms.Label();
			this.noScansText = new System.Windows.Forms.Label();
			this.noScansBox = new System.Windows.Forms.TextBox();
			this.totPacketsBox = new System.Windows.Forms.TextBox();
			this.TotPacketsText = new System.Windows.Forms.Label();
			this.curPacketsBox = new System.Windows.Forms.TextBox();
			this.curPacketsText = new System.Windows.Forms.Label();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.idBox = new System.Windows.Forms.NumericUpDown();
			// 
			// StreamButton
			// 
			this.StreamButton.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.StreamButton.Location = new System.Drawing.Point(152, 168);
			this.StreamButton.Size = new System.Drawing.Size(72, 24);
			this.StreamButton.Text = "Run";
			this.StreamButton.Click += new System.EventHandler(this.StreamButton_Click);
			// 
			// idLabel
			// 
			this.idLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.idLabel.Location = new System.Drawing.Point(8, 208);
			this.idLabel.Size = new System.Drawing.Size(96, 16);
			this.idLabel.Text = "UE9 Local ID :";
			// 
			// statusText
			// 
			this.statusText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.statusText.Location = new System.Drawing.Point(8, 240);
			this.statusText.Size = new System.Drawing.Size(56, 20);
			this.statusText.Text = "Status:";
			// 
			// statusBox
			// 
			this.statusBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold);
			this.statusBox.Location = new System.Drawing.Point(64, 240);
			this.statusBox.ReadOnly = true;
			this.statusBox.Size = new System.Drawing.Size(160, 21);
			this.statusBox.Text = "";
			// 
			// ai3
			// 
			this.ai3.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ai3.Location = new System.Drawing.Point(136, 112);
			this.ai3.Size = new System.Drawing.Size(16, 16);
			this.ai3.Text = "3";
			// 
			// ai2
			// 
			this.ai2.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ai2.Location = new System.Drawing.Point(136, 88);
			this.ai2.Size = new System.Drawing.Size(16, 16);
			this.ai2.Text = "2";
			// 
			// ai1
			// 
			this.ai1.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ai1.Location = new System.Drawing.Point(136, 64);
			this.ai1.Size = new System.Drawing.Size(16, 16);
			this.ai1.Text = "1";
			// 
			// ai0
			// 
			this.ai0.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.ai0.Location = new System.Drawing.Point(136, 40);
			this.ai0.Size = new System.Drawing.Size(16, 16);
			this.ai0.Text = "0";
			// 
			// aiV3
			// 
			this.aiV3.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.aiV3.Location = new System.Drawing.Point(160, 112);
			this.aiV3.ReadOnly = true;
			this.aiV3.Size = new System.Drawing.Size(64, 21);
			this.aiV3.Text = "";
			// 
			// aiV2
			// 
			this.aiV2.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.aiV2.Location = new System.Drawing.Point(160, 88);
			this.aiV2.ReadOnly = true;
			this.aiV2.Size = new System.Drawing.Size(64, 21);
			this.aiV2.Text = "";
			// 
			// aiV1
			// 
			this.aiV1.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.aiV1.Location = new System.Drawing.Point(160, 64);
			this.aiV1.ReadOnly = true;
			this.aiV1.Size = new System.Drawing.Size(64, 21);
			this.aiV1.Text = "";
			// 
			// aiV0
			// 
			this.aiV0.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.aiV0.Location = new System.Drawing.Point(160, 40);
			this.aiV0.ReadOnly = true;
			this.aiV0.Size = new System.Drawing.Size(64, 21);
			this.aiV0.Text = "";
			// 
			// aiVoltageText
			// 
			this.aiVoltageText.Font = new System.Drawing.Font("Tahoma", 9F, ((System.Drawing.FontStyle)((System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline))));
			this.aiVoltageText.Location = new System.Drawing.Point(168, 16);
			this.aiVoltageText.Size = new System.Drawing.Size(56, 16);
			this.aiVoltageText.Text = "Voltage";
			this.aiVoltageText.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// aiText
			// 
			this.aiText.Font = new System.Drawing.Font("Tahoma", 9F, ((System.Drawing.FontStyle)((System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline))));
			this.aiText.Location = new System.Drawing.Point(128, 16);
			this.aiText.Size = new System.Drawing.Size(24, 16);
			this.aiText.Text = "AI";
			this.aiText.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// noScansText
			// 
			this.noScansText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.noScansText.Location = new System.Drawing.Point(8, 16);
			this.noScansText.Size = new System.Drawing.Size(80, 16);
			this.noScansText.Text = "# of scans:";
			// 
			// noScansBox
			// 
			this.noScansBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.noScansBox.Location = new System.Drawing.Point(48, 32);
			this.noScansBox.ReadOnly = true;
			this.noScansBox.Size = new System.Drawing.Size(56, 21);
			this.noScansBox.Text = "";
			// 
			// totPacketsBox
			// 
			this.totPacketsBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.totPacketsBox.Location = new System.Drawing.Point(48, 80);
			this.totPacketsBox.ReadOnly = true;
			this.totPacketsBox.Size = new System.Drawing.Size(56, 21);
			this.totPacketsBox.Text = "";
			// 
			// TotPacketsText
			// 
			this.TotPacketsText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.TotPacketsText.Location = new System.Drawing.Point(8, 64);
			this.TotPacketsText.Size = new System.Drawing.Size(96, 16);
			this.TotPacketsText.Text = "Total packets:";
			// 
			// curPacketsBox
			// 
			this.curPacketsBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.curPacketsBox.Location = new System.Drawing.Point(48, 144);
			this.curPacketsBox.ReadOnly = true;
			this.curPacketsBox.Size = new System.Drawing.Size(56, 21);
			this.curPacketsBox.Text = "";
			// 
			// curPacketsText
			// 
			this.curPacketsText.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.curPacketsText.Location = new System.Drawing.Point(8, 112);
			this.curPacketsText.Size = new System.Drawing.Size(104, 32);
			this.curPacketsText.Text = "Current PacketCounter:";
			// 
			// idBox
			// 
			this.idBox.Location = new System.Drawing.Point(112, 208);
			this.idBox.Maximum = new System.Decimal(new int[] {
																  255,
																  0,
																  0,
																  0});
			this.idBox.Minimum = new System.Decimal(new int[] {
																  1,
																  0,
																  0,
																  -2147483648});
			this.idBox.Size = new System.Drawing.Size(56, 20);
			this.idBox.Value = new System.Decimal(new int[] {
																1,
																0,
																0,
																-2147483648});
			// 
			// StreamForm
			// 
			this.Controls.Add(this.idBox);
			this.Controls.Add(this.curPacketsBox);
			this.Controls.Add(this.curPacketsText);
			this.Controls.Add(this.totPacketsBox);
			this.Controls.Add(this.TotPacketsText);
			this.Controls.Add(this.noScansBox);
			this.Controls.Add(this.noScansText);
			this.Controls.Add(this.ai3);
			this.Controls.Add(this.ai2);
			this.Controls.Add(this.ai1);
			this.Controls.Add(this.ai0);
			this.Controls.Add(this.aiV3);
			this.Controls.Add(this.aiV2);
			this.Controls.Add(this.aiV1);
			this.Controls.Add(this.aiV0);
			this.Controls.Add(this.aiVoltageText);
			this.Controls.Add(this.aiText);
			this.Controls.Add(this.statusText);
			this.Controls.Add(this.statusBox);
			this.Controls.Add(this.idLabel);
			this.Controls.Add(this.StreamButton);
			this.Menu = this.mainMenu1;
			this.MinimizeBox = false;
			this.Text = "ue9Stream USB";
			this.Load += new System.EventHandler(this.StreamForm_Load);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>

		static void Main() 
		{
			Application.Run(new StreamForm());
		}

		private void StreamForm_Load(object sender, System.EventArgs e)
		{
		
		}

		private void StreamButton_Click(object sender, System.EventArgs e)
		{
			int err = 0;
			Error errorText = new Error(); 
			Thread streamDataThread;
			ue9Dev = new UE9();
			statusBox.Text = "";
			noScansBox.Text = "";
			totPacketsBox.Text = "";
			curPacketsBox.Text = "";
			aiV0.Text = "";
			aiV1.Text = "";
			aiV2.Text = "";
			aiV3.Text = "";
			flushDone = false;
			
			if( (err = ue9Dev.openUSBConnection(Convert.ToInt32(idBox.Value))) < 0)
			{
				statusBox.Text = errorText.getError(err);
				return;
			}

			if( (err = ue9Dev.getCalibrationInfo()) < 0)
			{
				statusBox.Text = errorText.getError(err);
				ue9Dev.closeUSBConnection();				
				return;
			}

			//flushing the stream
			if(flushStream() <= -1)
			{
				statusBox.Text = errorText.getError(-20);
				ue9Dev.closeUSBConnection();
				return;
			}

			//reading from the stream to remove left over data
			streamDataThread = new Thread(new ThreadStart(streamData));
			streamDataThread.Start();

			while(flushDone == false)
			{
				try
				{
					Thread.Sleep(250);
					if(UE9.LJUSB_AbortPipe(ue9Dev.handle, UE9.UE9_PIPE_EP2_IN) == true)
						break;
				}
				catch(Exception k)
				{
					this.statusBox.Text = k.ToString();
					return;
				}				
			}
			
			if( (err = StreamConfig_example()) < 0 )
			{			
				statusBox.Text = errorText.getError(err);
				if(err == -18)
					statusBox.Text += ue9Dev.errorcode;
				statusBox.Text += " (StreamConfig)";
				
				ue9Dev.closeUSBConnection();
				return;
			}

			if( (err = StreamStart()) < 0)
			{
				statusBox.Text = errorText.getError(err);
				if(err == -18)
					statusBox.Text += ue9Dev.errorcode;
				statusBox.Text += " (StreamStart)";
				
				ue9Dev.closeUSBConnection();
				return;
			}

			statusBox.Text = "Reading Samples...";
			if( (err = StreamData_example()) < 0)
			{
				if(err != -19)
				{				
					statusBox.Text = errorText.getError(err);
					if(err == -18)
						statusBox.Text += ue9Dev.errorcode;
					statusBox.Text += " (StreamData)";
				}

				StreamStop();
				ue9Dev.closeUSBConnection();
				return;
			}

			if( (err = StreamStop()) < 0)
			{
				statusBox.Text = errorText.getError(err);
				if(err == -18)
					statusBox.Text += ue9Dev.errorcode;
				statusBox.Text += " (StreamStop)";
				ue9Dev.closeUSBConnection();
				return;
			}
	
			if( (err = ue9Dev.closeUSBConnection()) < 0)
			{
				statusBox.Text = errorText.getError(err);					
				return;
			}

			statusBox.Text = "Done";

		}

		//stream is configured for reading only 4 analog inputs (AI0 - AI1)
		int StreamConfig_example()
		{
			byte []sendBuff = new byte[20];
			byte []recBuff = new byte[8];
			ushort checksumTotal;
			
			sendBuff[1] = (byte)(0xF8);  //command byte
			sendBuff[2] = (byte)(0x07);  //number of data words = NumChannels + 3
			sendBuff[3] = (byte)(0x11);  //extended command number
			sendBuff[6] = (byte)(0x04);  //NumChannels = 4  
			sendBuff[7] = resolution;	 //Resolution = 12 (default)
			sendBuff[8] = (byte)(0x00);  //SettlingTime = 0
			sendBuff[9] = (byte)(0x00);  //ScanConfig: scan pulse and external scan trigger disabled
			
			//stream clock frequency = 4 MHz, Scan Interval = 4000
			sendBuff[10] = (byte)(0xA0); //Scan Interval (low byte)
			sendBuff[11] = (byte)(0x0F); //Scan Interval (high byte)
			sendBuff[12] = (byte)(0x00); //ChannelNumber = 0
			sendBuff[13] = (byte)(0x08); //BipGain = bipolar (0x08)
			sendBuff[14] = (byte)(0x01); //ChannelNumber = 1
			sendBuff[15] = (byte)(0x08); //BipGain = bipolar (0x08)
			sendBuff[16] = (byte)(0x02); //ChannelNumber = 2
			sendBuff[17] = (byte)(0x08); //BipGain = bipolar (0x08)
			sendBuff[18] = (byte)(0x03); //ChannelNumber = 3
			sendBuff[19] = (byte)(0x08); //BipGain = bipolar (0x08)

			UE9.extendedChecksum(ref sendBuff, 20);
			
			try
			{
				if(UE9.LJUSB_BulkWrite(ue9Dev.handle, UE9.UE9_PIPE_EP1_OUT, sendBuff, 20) != 20)
					throw new Exception();
			}
			catch(System.Exception)
			{
				return -14;
			}

			try
			{
				if(UE9.LJUSB_BulkRead(ue9Dev.handle, UE9.UE9_PIPE_EP1_IN, recBuff, 8) != 8)
					throw new Exception();
			}
			catch(System.Exception)
			{
				return -15;
			}

			checksumTotal = UE9.extendedChecksum16(recBuff, 8);

			if( (byte)((checksumTotal / 256) & 0xff) != recBuff[5])
				return -16;

			if( (byte)(checksumTotal & 0xff) != recBuff[4])
				return -16;

			if( UE9.extendedChecksum8(recBuff) != recBuff[0])
				return -17;

			if( recBuff[1] != (byte)(0xF8) || recBuff[2] != (byte)(0x01) || recBuff[3] != (byte)(0x11) || recBuff[7] != (byte)(0x00))
				return -10;

			if(recBuff[6] != 0)
			{
				ue9Dev.errorcode = (int)recBuff[6];
				return -18;
			}

			return 0;
		}

		int StreamStart()
		{
			byte []sendBuff = new byte[2];
			byte []recBuff = new byte[4];
			
			sendBuff[0] = (byte)(0xA8);  //checksum8
			sendBuff[1] = (byte)(0xA8);  //command byte
  
			try
			{
				if(UE9.LJUSB_BulkWrite(ue9Dev.handle, UE9.UE9_PIPE_EP1_OUT, sendBuff, 2) != 2)
					throw new Exception();
			}
			catch(System.Exception)
			{
				return -14;
			}

			try
			{
				if(UE9.LJUSB_BulkRead(ue9Dev.handle, UE9.UE9_PIPE_EP1_IN, recBuff, 4) != 4)
					throw new Exception();
			}
			catch(System.Exception)
			{
				return -15;
			}

			if( recBuff[1] != (byte)(0xA9) || recBuff[3] != (byte)(0x00) )
				return -10;

			if(recBuff[2] != 0)
			{
				ue9Dev.errorcode = (int)recBuff[2];
				return -18;
			}

			return 0;
		}

		//The ue9 streamData function is called 124*timesDisplayed times.
		//All voltages from the sream are saved in the voltages 2D array
		int StreamData_example()
		{
			byte []recBuff = new byte[192];
			int packetCounter = 0, currChannel = 0, scanNumber = 0, totalPackets = 0;
			ushort checksumTotal = 0;
			double [ , ]voltages = new double[2480, 4];  //each packet contains 4 samples for each channel (4 channels)
			byte []streamData = new byte[46];

			for (int i = 0; i < 5; i++)
			{
				for(int j = 0; j < 31; j++)	//reading 124 packets
				{
					//For usb read 192 bytes instead of the 46.  The 192 bytes 
					//response is 4 StreamData packet responses of 48 bytes.
					try
					{
						if(UE9.LJUSB_BulkRead(ue9Dev.handle, UE9.UE9_PIPE_EP2_IN, recBuff, 192) != 192)
							throw new Exception();
					}
					catch(System.Exception)
					{
						return -15;
					}

					for (int m = 0; m < 4; m++)
					{
						totalPackets++;
				
						Array.Copy(recBuff, m*48, streamData, 0, 46);
						checksumTotal = UE9.extendedChecksum16(streamData, 46);
						if( (byte)((checksumTotal >> 8) & 0xff) != recBuff[m*48 + 5])
							return -16;

						if( (byte)(checksumTotal & 0xff) != streamData[4])
							return -16;

						checksumTotal = UE9.extendedChecksum8(streamData);

						if( checksumTotal != streamData[0])
							return -17;
					
						if( streamData[1] != (byte)(0xF9) || streamData[2] != (byte)(0x14) || streamData[3] != (byte)(0xC0) )
							return -10;
					
						if(streamData[11] != 0)
						{
							ue9Dev.errorcode = (int)streamData[11];
							return -18;
						}

						if(packetCounter != (int) streamData[10])
						{
							statusBox.Text = "Error : packet cnt. = " + packetCounter + ", received packet cnt. = " + (int) streamData[10];
							return -19;
						}

						for(int k = 12; k < 43; k+=2)
						{
							ue9Dev.binaryToCalibratedAnalogVoltage(0x08, resolution, (ushort)(streamData[k] + streamData[k+1] * 256), ref (voltages[scanNumber, currChannel])); 
							currChannel++;
							if(currChannel > 3)
							{
								currChannel = 0;
								scanNumber++;
							}
						}

						if(packetCounter >= 255)
							packetCounter = 0;
						else
							packetCounter++;
					}
				}

				noScansBox.Text = Convert.ToInt32(scanNumber).ToString();
				totPacketsBox.Text = Convert.ToInt32(totalPackets).ToString();
				curPacketsBox.Text = Convert.ToInt32(recBuff[10]).ToString();
	  
				aiV0.Text = string.Format("{0:f3}", voltages[scanNumber - 1, 0]);
				aiV1.Text = string.Format("{0:f3}", voltages[scanNumber - 1, 1]);
				aiV2.Text = string.Format("{0:f3}", voltages[scanNumber - 1, 2]);
				aiV3.Text = string.Format("{0:f3}", voltages[scanNumber - 1, 3]);
			}
			return 0;
		}

		int StreamStop()
		{
			byte []sendBuff = new byte[2];
			byte []recBuff = new byte[4];
			
			sendBuff[0] = (byte)(0xB0);  //checksum8
			sendBuff[1] = (byte)(0xB0);  //command byte
  
			try
			{
				if(UE9.LJUSB_BulkWrite(ue9Dev.handle, UE9.UE9_PIPE_EP1_OUT, sendBuff, 2) != 2)
					throw new Exception();
			}
			catch(System.Exception)
			{
				return -14;
			}

			try
			{
				if(UE9.LJUSB_BulkRead(ue9Dev.handle, UE9.UE9_PIPE_EP1_IN, recBuff, 4) != 4)
					throw new Exception();
			}
			catch(System.Exception)
			{
				return -15;
			}

			if( recBuff[1] != (byte)(0xB1) || recBuff[3] != (byte)(0x00) )
				return -10;

			if(recBuff[2] != 0)
			{
				ue9Dev.errorcode = (int)recBuff[2];
				return -18;
			}

			return 0;
		}

		int flushStream()
		{
			byte []sendBuff = new byte[2];
			byte []recBuff = new byte[2];

			sendBuff[0] = (byte)(0x08);  //checksum8
			sendBuff[1] = (byte)(0x08);  //command byte
   
			try
			{
				if(UE9.LJUSB_BulkWrite(ue9Dev.handle, UE9.UE9_PIPE_EP1_OUT, sendBuff, 2) != 2)
					throw new Exception();
			}
			catch(System.Exception)
			{
				return -14;
			}

			try
			{
				if(UE9.LJUSB_BulkRead(ue9Dev.handle, UE9.UE9_PIPE_EP1_IN, recBuff, 2) != 2)
					throw new Exception();
			}
			catch(System.Exception)
			{
				return -15;
			}

			if(recBuff[0] != (byte)(0x08) || recBuff[1] != (byte)(0x08))
				return -10;
		
			return 0;  
		}

		void streamData()
		{
			byte []recStreamBuff = new byte[192];
		
			try
			{
				if(UE9.LJUSB_BulkRead(ue9Dev.handle, UE9.UE9_PIPE_EP2_IN, recStreamBuff, 192) != 192)
					throw new Exception();
			}
			catch(System.Exception)
			{
				this.flushDone = true;
				return;
			}

			this.flushDone = true;
			return;
		}
	}
}

