//Author: LabJack
//April 29, 2008
//This example calls the ConfigU3 low-level function and reads back
//configuration settings.

using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Data;
using LabJack;

namespace u3ConfigU3
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class u3ConfigU3 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button runButton;
		private System.Windows.Forms.TabControl tabControl1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.NumericUpDown locIDBox;
		private System.Windows.Forms.TabPage tabPage1;
		private System.Windows.Forms.TabPage tabPage2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label hwLabel;
		private System.Windows.Forms.Label locIDLabel;
		private System.Windows.Forms.Label prodIDLabel;
		private System.Windows.Forms.Label serialLabel;
		private System.Windows.Forms.Label fwLabel;
		private System.Windows.Forms.Label blLabel;
		private System.Windows.Forms.TextBox errorBox;
		private System.Windows.Forms.TabPage tabPage3;
		private System.Windows.Forms.Label fioAnalogLabel;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.Label fioDirLabel;
		private System.Windows.Forms.Label label12;
		private System.Windows.Forms.Label fioStateLabel;
		private System.Windows.Forms.Label label14;
		private System.Windows.Forms.Label eioStateLabel;
		private System.Windows.Forms.Label label11;
		private System.Windows.Forms.Label eioDirLabel;
		private System.Windows.Forms.Label label15;
		private System.Windows.Forms.Label eioAnalogLabel;
		private System.Windows.Forms.Label label17;
		private System.Windows.Forms.Label cioStateLabel;
		private System.Windows.Forms.Label label13;
		private System.Windows.Forms.Label cioDirLabel;
		private System.Windows.Forms.Label label18;
		private System.Windows.Forms.Label label16;
		private System.Windows.Forms.Label label20;
		private System.Windows.Forms.Label label22;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.Label dac0Label;
		private System.Windows.Forms.Label dac1EnableLabel;
		private System.Windows.Forms.Label dac1Label;
		private System.Windows.Forms.TabPage tabPage4;
		private System.Windows.Forms.Label label26;
		private System.Windows.Forms.Label label30;
		private System.Windows.Forms.Label label31;
		private System.Windows.Forms.Label label21;
		private System.Windows.Forms.Label label19;
		private System.Windows.Forms.Label label27;
		private System.Windows.Forms.Label label29;
		private System.Windows.Forms.Label label33;
		private System.Windows.Forms.Label label34;
		private System.Windows.Forms.Label u3bLabel;
		private System.Windows.Forms.Label u3cLabel;
		private System.Windows.Forms.Label hvLabel;
		private System.Windows.Forms.Label tccsLabel;
		private System.Windows.Forms.Label tccdLabel;
		private System.Windows.Forms.Label disableTCPOLabel;

		private U3 u3Dev;
		public u3ConfigU3()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.runButton = new System.Windows.Forms.Button();
			this.tabControl1 = new System.Windows.Forms.TabControl();
			this.tabPage1 = new System.Windows.Forms.TabPage();
			this.hwLabel = new System.Windows.Forms.Label();
			this.locIDLabel = new System.Windows.Forms.Label();
			this.prodIDLabel = new System.Windows.Forms.Label();
			this.serialLabel = new System.Windows.Forms.Label();
			this.fwLabel = new System.Windows.Forms.Label();
			this.blLabel = new System.Windows.Forms.Label();
			this.label8 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.tabPage2 = new System.Windows.Forms.TabPage();
			this.eioStateLabel = new System.Windows.Forms.Label();
			this.label11 = new System.Windows.Forms.Label();
			this.eioDirLabel = new System.Windows.Forms.Label();
			this.label15 = new System.Windows.Forms.Label();
			this.eioAnalogLabel = new System.Windows.Forms.Label();
			this.label17 = new System.Windows.Forms.Label();
			this.fioStateLabel = new System.Windows.Forms.Label();
			this.label14 = new System.Windows.Forms.Label();
			this.fioDirLabel = new System.Windows.Forms.Label();
			this.label12 = new System.Windows.Forms.Label();
			this.fioAnalogLabel = new System.Windows.Forms.Label();
			this.label10 = new System.Windows.Forms.Label();
			this.tabPage3 = new System.Windows.Forms.TabPage();
			this.dac1Label = new System.Windows.Forms.Label();
			this.label22 = new System.Windows.Forms.Label();
			this.dac0Label = new System.Windows.Forms.Label();
			this.label16 = new System.Windows.Forms.Label();
			this.dac1EnableLabel = new System.Windows.Forms.Label();
			this.label20 = new System.Windows.Forms.Label();
			this.cioStateLabel = new System.Windows.Forms.Label();
			this.label13 = new System.Windows.Forms.Label();
			this.cioDirLabel = new System.Windows.Forms.Label();
			this.label18 = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.locIDBox = new System.Windows.Forms.NumericUpDown();
			this.errorBox = new System.Windows.Forms.TextBox();
			this.tabPage4 = new System.Windows.Forms.TabPage();
			this.u3bLabel = new System.Windows.Forms.Label();
			this.label26 = new System.Windows.Forms.Label();
			this.label30 = new System.Windows.Forms.Label();
			this.label31 = new System.Windows.Forms.Label();
			this.label21 = new System.Windows.Forms.Label();
			this.u3cLabel = new System.Windows.Forms.Label();
			this.hvLabel = new System.Windows.Forms.Label();
			this.label19 = new System.Windows.Forms.Label();
			this.tccsLabel = new System.Windows.Forms.Label();
			this.label27 = new System.Windows.Forms.Label();
			this.tccdLabel = new System.Windows.Forms.Label();
			this.label29 = new System.Windows.Forms.Label();
			this.disableTCPOLabel = new System.Windows.Forms.Label();
			this.label33 = new System.Windows.Forms.Label();
			this.label34 = new System.Windows.Forms.Label();
			// 
			// runButton
			// 
			this.runButton.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.runButton.Location = new System.Drawing.Point(152, 200);
			this.runButton.Size = new System.Drawing.Size(72, 24);
			this.runButton.Text = "Run";
			this.runButton.Click += new System.EventHandler(this.runButton_Click);
			// 
			// tabControl1
			// 
			this.tabControl1.Controls.Add(this.tabPage1);
			this.tabControl1.Controls.Add(this.tabPage2);
			this.tabControl1.Controls.Add(this.tabPage3);
			this.tabControl1.Controls.Add(this.tabPage4);
			this.tabControl1.SelectedIndex = 0;
			this.tabControl1.Size = new System.Drawing.Size(240, 192);
			// 
			// tabPage1
			// 
			this.tabPage1.Controls.Add(this.hwLabel);
			this.tabPage1.Controls.Add(this.locIDLabel);
			this.tabPage1.Controls.Add(this.prodIDLabel);
			this.tabPage1.Controls.Add(this.serialLabel);
			this.tabPage1.Controls.Add(this.fwLabel);
			this.tabPage1.Controls.Add(this.blLabel);
			this.tabPage1.Controls.Add(this.label8);
			this.tabPage1.Controls.Add(this.label7);
			this.tabPage1.Controls.Add(this.label6);
			this.tabPage1.Controls.Add(this.label5);
			this.tabPage1.Controls.Add(this.label4);
			this.tabPage1.Controls.Add(this.label3);
			this.tabPage1.Location = new System.Drawing.Point(4, 4);
			this.tabPage1.Size = new System.Drawing.Size(232, 166);
			this.tabPage1.Text = "Info";
			// 
			// hwLabel
			// 
			this.hwLabel.Location = new System.Drawing.Point(128, 64);
			this.hwLabel.Size = new System.Drawing.Size(88, 16);
			// 
			// locIDLabel
			// 
			this.locIDLabel.Location = new System.Drawing.Point(128, 136);
			this.locIDLabel.Size = new System.Drawing.Size(88, 16);
			// 
			// prodIDLabel
			// 
			this.prodIDLabel.Location = new System.Drawing.Point(128, 112);
			this.prodIDLabel.Size = new System.Drawing.Size(88, 16);
			// 
			// serialLabel
			// 
			this.serialLabel.Location = new System.Drawing.Point(128, 88);
			this.serialLabel.Size = new System.Drawing.Size(88, 16);
			// 
			// fwLabel
			// 
			this.fwLabel.Location = new System.Drawing.Point(128, 16);
			this.fwLabel.Size = new System.Drawing.Size(88, 16);
			// 
			// blLabel
			// 
			this.blLabel.Location = new System.Drawing.Point(128, 40);
			this.blLabel.Size = new System.Drawing.Size(88, 16);
			// 
			// label8
			// 
			this.label8.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label8.Location = new System.Drawing.Point(8, 64);
			this.label8.Size = new System.Drawing.Size(112, 16);
			this.label8.Text = "Hardware Ver. :";
			this.label8.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// label7
			// 
			this.label7.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label7.Location = new System.Drawing.Point(8, 136);
			this.label7.Size = new System.Drawing.Size(112, 16);
			this.label7.Text = "Local ID :";
			this.label7.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// label6
			// 
			this.label6.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label6.Location = new System.Drawing.Point(8, 112);
			this.label6.Size = new System.Drawing.Size(112, 16);
			this.label6.Text = "Product ID :";
			this.label6.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// label5
			// 
			this.label5.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label5.Location = new System.Drawing.Point(8, 88);
			this.label5.Size = new System.Drawing.Size(112, 16);
			this.label5.Text = "Serial # :";
			this.label5.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// label4
			// 
			this.label4.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label4.Location = new System.Drawing.Point(8, 16);
			this.label4.Size = new System.Drawing.Size(112, 16);
			this.label4.Text = "Firmware Ver. :";
			this.label4.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// label3
			// 
			this.label3.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label3.Location = new System.Drawing.Point(8, 40);
			this.label3.Size = new System.Drawing.Size(112, 16);
			this.label3.Text = "Bootloader Ver. :";
			this.label3.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// tabPage2
			// 
			this.tabPage2.Controls.Add(this.eioStateLabel);
			this.tabPage2.Controls.Add(this.label11);
			this.tabPage2.Controls.Add(this.eioDirLabel);
			this.tabPage2.Controls.Add(this.label15);
			this.tabPage2.Controls.Add(this.eioAnalogLabel);
			this.tabPage2.Controls.Add(this.label17);
			this.tabPage2.Controls.Add(this.fioStateLabel);
			this.tabPage2.Controls.Add(this.label14);
			this.tabPage2.Controls.Add(this.fioDirLabel);
			this.tabPage2.Controls.Add(this.label12);
			this.tabPage2.Controls.Add(this.fioAnalogLabel);
			this.tabPage2.Controls.Add(this.label10);
			this.tabPage2.Location = new System.Drawing.Point(4, 4);
			this.tabPage2.Size = new System.Drawing.Size(232, 166);
			this.tabPage2.Text = "FIO, EIO";
			// 
			// eioStateLabel
			// 
			this.eioStateLabel.Location = new System.Drawing.Point(128, 136);
			this.eioStateLabel.Size = new System.Drawing.Size(64, 16);
			// 
			// label11
			// 
			this.label11.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label11.Location = new System.Drawing.Point(32, 136);
			this.label11.Size = new System.Drawing.Size(88, 16);
			this.label11.Text = "EIO State :";
			this.label11.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// eioDirLabel
			// 
			this.eioDirLabel.Location = new System.Drawing.Point(128, 112);
			this.eioDirLabel.Size = new System.Drawing.Size(64, 16);
			// 
			// label15
			// 
			this.label15.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label15.Location = new System.Drawing.Point(32, 112);
			this.label15.Size = new System.Drawing.Size(88, 16);
			this.label15.Text = "EIO Dir. :";
			this.label15.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// eioAnalogLabel
			// 
			this.eioAnalogLabel.Location = new System.Drawing.Point(128, 88);
			this.eioAnalogLabel.Size = new System.Drawing.Size(64, 16);
			// 
			// label17
			// 
			this.label17.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label17.Location = new System.Drawing.Point(32, 88);
			this.label17.Size = new System.Drawing.Size(88, 16);
			this.label17.Text = "EIO Analog :";
			this.label17.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// fioStateLabel
			// 
			this.fioStateLabel.Location = new System.Drawing.Point(128, 64);
			this.fioStateLabel.Size = new System.Drawing.Size(64, 16);
			// 
			// label14
			// 
			this.label14.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label14.Location = new System.Drawing.Point(32, 64);
			this.label14.Size = new System.Drawing.Size(88, 16);
			this.label14.Text = "FIO State :";
			this.label14.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// fioDirLabel
			// 
			this.fioDirLabel.Location = new System.Drawing.Point(128, 40);
			this.fioDirLabel.Size = new System.Drawing.Size(64, 16);
			// 
			// label12
			// 
			this.label12.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label12.Location = new System.Drawing.Point(32, 40);
			this.label12.Size = new System.Drawing.Size(88, 16);
			this.label12.Text = "FIO Dir. :";
			this.label12.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// fioAnalogLabel
			// 
			this.fioAnalogLabel.Location = new System.Drawing.Point(128, 16);
			this.fioAnalogLabel.Size = new System.Drawing.Size(64, 16);
			// 
			// label10
			// 
			this.label10.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label10.Location = new System.Drawing.Point(32, 16);
			this.label10.Size = new System.Drawing.Size(88, 16);
			this.label10.Text = "FIO Analog :";
			this.label10.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// tabPage3
			// 
			this.tabPage3.Controls.Add(this.dac1Label);
			this.tabPage3.Controls.Add(this.label22);
			this.tabPage3.Controls.Add(this.dac0Label);
			this.tabPage3.Controls.Add(this.label16);
			this.tabPage3.Controls.Add(this.dac1EnableLabel);
			this.tabPage3.Controls.Add(this.label20);
			this.tabPage3.Controls.Add(this.cioStateLabel);
			this.tabPage3.Controls.Add(this.label13);
			this.tabPage3.Controls.Add(this.cioDirLabel);
			this.tabPage3.Controls.Add(this.label18);
			this.tabPage3.Location = new System.Drawing.Point(4, 4);
			this.tabPage3.Size = new System.Drawing.Size(232, 166);
			this.tabPage3.Text = "CIO, DAC";
			// 
			// dac1Label
			// 
			this.dac1Label.Location = new System.Drawing.Point(128, 112);
			this.dac1Label.Size = new System.Drawing.Size(80, 16);
			// 
			// label22
			// 
			this.label22.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label22.Location = new System.Drawing.Point(16, 112);
			this.label22.Size = new System.Drawing.Size(104, 16);
			this.label22.Text = "DAC1 :";
			this.label22.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// dac0Label
			// 
			this.dac0Label.Location = new System.Drawing.Point(128, 88);
			this.dac0Label.Size = new System.Drawing.Size(80, 16);
			// 
			// label16
			// 
			this.label16.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label16.Location = new System.Drawing.Point(16, 88);
			this.label16.Size = new System.Drawing.Size(104, 16);
			this.label16.Text = "DAC0 :";
			this.label16.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// dac1EnableLabel
			// 
			this.dac1EnableLabel.Location = new System.Drawing.Point(128, 64);
			this.dac1EnableLabel.Size = new System.Drawing.Size(80, 16);
			// 
			// label20
			// 
			this.label20.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label20.Location = new System.Drawing.Point(16, 64);
			this.label20.Size = new System.Drawing.Size(104, 16);
			this.label20.Text = "DAC1 Enable :";
			this.label20.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// cioStateLabel
			// 
			this.cioStateLabel.Location = new System.Drawing.Point(128, 40);
			this.cioStateLabel.Size = new System.Drawing.Size(80, 16);
			// 
			// label13
			// 
			this.label13.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label13.Location = new System.Drawing.Point(16, 40);
			this.label13.Size = new System.Drawing.Size(104, 16);
			this.label13.Text = "CIO State :";
			this.label13.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// cioDirLabel
			// 
			this.cioDirLabel.Location = new System.Drawing.Point(128, 16);
			this.cioDirLabel.Size = new System.Drawing.Size(80, 16);
			// 
			// label18
			// 
			this.label18.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label18.Location = new System.Drawing.Point(16, 16);
			this.label18.Size = new System.Drawing.Size(104, 16);
			this.label18.Text = "CIO Dir. :";
			this.label18.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label1.Location = new System.Drawing.Point(8, 200);
			this.label1.Size = new System.Drawing.Size(56, 16);
			this.label1.Text = "Local ID";
			// 
			// label2
			// 
			this.label2.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label2.Location = new System.Drawing.Point(8, 232);
			this.label2.Size = new System.Drawing.Size(40, 16);
			this.label2.Text = "Error";
			// 
			// locIDBox
			// 
			this.locIDBox.Location = new System.Drawing.Point(72, 200);
			this.locIDBox.Maximum = new System.Decimal(new int[] {
																	 255,
																	 0,
																	 0,
																	 0});
			this.locIDBox.Minimum = new System.Decimal(new int[] {
																	 1,
																	 0,
																	 0,
																	 -2147483648});
			this.locIDBox.Size = new System.Drawing.Size(56, 20);
			this.locIDBox.Value = new System.Decimal(new int[] {
																   1,
																   0,
																   0,
																   -2147483648});
			// 
			// errorBox
			// 
			this.errorBox.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular);
			this.errorBox.Location = new System.Drawing.Point(56, 232);
			this.errorBox.Multiline = true;
			this.errorBox.ReadOnly = true;
			this.errorBox.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.errorBox.Size = new System.Drawing.Size(176, 32);
			this.errorBox.Text = "";
			// 
			// tabPage4
			// 
			this.tabPage4.Controls.Add(this.label34);
			this.tabPage4.Controls.Add(this.disableTCPOLabel);
			this.tabPage4.Controls.Add(this.label33);
			this.tabPage4.Controls.Add(this.tccdLabel);
			this.tabPage4.Controls.Add(this.label29);
			this.tabPage4.Controls.Add(this.tccsLabel);
			this.tabPage4.Controls.Add(this.label27);
			this.tabPage4.Controls.Add(this.label19);
			this.tabPage4.Controls.Add(this.hvLabel);
			this.tabPage4.Controls.Add(this.u3cLabel);
			this.tabPage4.Controls.Add(this.label21);
			this.tabPage4.Controls.Add(this.u3bLabel);
			this.tabPage4.Controls.Add(this.label26);
			this.tabPage4.Controls.Add(this.label30);
			this.tabPage4.Controls.Add(this.label31);
			this.tabPage4.Location = new System.Drawing.Point(4, 4);
			this.tabPage4.Size = new System.Drawing.Size(232, 166);
			this.tabPage4.Text = "Info 2";
			// 
			// u3bLabel
			// 
			this.u3bLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular);
			this.u3bLabel.Location = new System.Drawing.Point(72, 24);
			this.u3bLabel.Size = new System.Drawing.Size(40, 16);
			// 
			// label26
			// 
			this.label26.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label26.Location = new System.Drawing.Point(120, 24);
			this.label26.Size = new System.Drawing.Size(64, 32);
			this.label26.Text = "High Voltage :";
			// 
			// label30
			// 
			this.label30.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label30.Location = new System.Drawing.Point(8, 8);
			this.label30.Size = new System.Drawing.Size(216, 16);
			this.label30.Text = "HW Variations (HW Ver. >= 1.21):";
			// 
			// label31
			// 
			this.label31.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label31.Location = new System.Drawing.Point(24, 24);
			this.label31.Size = new System.Drawing.Size(40, 16);
			this.label31.Text = "U3b :";
			this.label31.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// label21
			// 
			this.label21.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label21.Location = new System.Drawing.Point(24, 40);
			this.label21.Size = new System.Drawing.Size(40, 16);
			this.label21.Text = "U3c :";
			this.label21.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// u3cLabel
			// 
			this.u3cLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular);
			this.u3cLabel.Location = new System.Drawing.Point(72, 40);
			this.u3cLabel.Size = new System.Drawing.Size(40, 16);
			// 
			// hvLabel
			// 
			this.hvLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular);
			this.hvLabel.Location = new System.Drawing.Point(184, 32);
			this.hvLabel.Size = new System.Drawing.Size(40, 16);
			// 
			// label19
			// 
			this.label19.Font = new System.Drawing.Font("Tahoma", 9F, ((System.Drawing.FontStyle)((System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline))));
			this.label19.Location = new System.Drawing.Point(8, 64);
			this.label19.Size = new System.Drawing.Size(216, 16);
			this.label19.Text = "For HW Ver. 1.30";
			this.label19.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// tccsLabel
			// 
			this.tccsLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular);
			this.tccsLabel.Location = new System.Drawing.Point(136, 80);
			this.tccsLabel.Size = new System.Drawing.Size(40, 16);
			// 
			// label27
			// 
			this.label27.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label27.Location = new System.Drawing.Point(8, 80);
			this.label27.Size = new System.Drawing.Size(120, 16);
			this.label27.Text = "TC Clock Source :";
			// 
			// tccdLabel
			// 
			this.tccdLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular);
			this.tccdLabel.Location = new System.Drawing.Point(136, 96);
			this.tccdLabel.Size = new System.Drawing.Size(40, 16);
			// 
			// label29
			// 
			this.label29.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label29.Location = new System.Drawing.Point(8, 96);
			this.label29.Size = new System.Drawing.Size(120, 16);
			this.label29.Text = "TC Clock Divisor :";
			// 
			// disableTCPOLabel
			// 
			this.disableTCPOLabel.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular);
			this.disableTCPOLabel.Location = new System.Drawing.Point(136, 136);
			this.disableTCPOLabel.Size = new System.Drawing.Size(40, 16);
			// 
			// label33
			// 
			this.label33.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label33.Location = new System.Drawing.Point(8, 112);
			this.label33.Size = new System.Drawing.Size(160, 16);
			this.label33.Text = "Compatibility Options :";
			// 
			// label34
			// 
			this.label34.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Bold);
			this.label34.Location = new System.Drawing.Point(24, 128);
			this.label34.Size = new System.Drawing.Size(104, 32);
			this.label34.Text = "Disable TC Pin Offset Errors :";
			// 
			// u3ConfigU3
			// 
			this.Controls.Add(this.errorBox);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.runButton);
			this.Controls.Add(this.locIDBox);
			this.Controls.Add(this.tabControl1);
			this.Controls.Add(this.label2);
			this.Menu = this.mainMenu1;
			this.MinimizeBox = false;
			this.Text = "U3 ConfigU3 Example";

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>

		static void Main() 
		{
			Application.Run(new u3ConfigU3());
		}

		private void runButton_Click(object sender, System.EventArgs e)
		{
			try
			{
				clearLabels();
				u3Dev = new U3();

				//Opening U3 over USB
				if(u3Dev.openUSBConnection(Convert.ToInt32(locIDBox.Value)) != 0)
				{
					errorBox.Text = u3Dev.errorText;
					throw new Exception();
				}
			
				errorBox.Text = getError(configU3_example());

				if(u3Dev.closeUSBConnection() != 0)
					errorBox.Text = u3Dev.errorText;
			}
			catch(Exception excep)
			{
				errorBox.Text += excep.ToString();
			}
		}

		
		/// <summary>
		/// Sends a ConfigU3 low-level command to read back configuration settings.
		/// </summary>
		/// <returns>Negative number on error, 0 on success.</returns>
		private int configU3_example()
		{
			byte []sendBuff = new byte[26];
			byte []recBuff = new byte[38];
			ushort checksumTotal;

			sendBuff[1] = (byte)(0xF8);  //Command byte
			sendBuff[2] = (byte)(0x0A);  //Number of data words
			sendBuff[3] = (byte)(0x08);  //Extended command number

			//Not setting any write masks or changing any values since we
			//are only going to read back the configuration settings.
			for(int i = 6; i < 26; i++)
				sendBuff[i] = 0;

			/* The code below changes the U3's local id to 2.  The device will
			 * needs to be reset for this change to take effect.
			 * 
			 * sendBuff[6] += 8;  //WriteMask0 : setting bit 3 (LocalID)
			 * sendBuff[8] = 2;  //LocalID : setting to 2
			 * */

			U3.extendedChecksum(ref sendBuff, 26);
  
			if(U3.LJUSB_BulkWrite(u3Dev.handle, U3.U3_PIPE_EP1_OUT, sendBuff, 26) != 26)
				return -1;
			
			if(U3.LJUSB_BulkRead(u3Dev.handle, U3.U3_PIPE_EP1_IN, recBuff, 38) != 38)
				return -2;
			
			checksumTotal = U3.extendedChecksum16(recBuff, 38);
			if( (byte)((checksumTotal/256) & 0xff) != recBuff[5]
				|| (byte)(checksumTotal & 0xff) != recBuff[4])
				return -4;

			if( U3.extendedChecksum8(recBuff) != recBuff[0])
				return -3;

			if( recBuff[1] != (byte)(0xF8) || recBuff[2] != (byte)(0x10) || recBuff[3] != (byte)(0x08) )
				return -6;

			if( recBuff[6] != 0)
			{
				u3Dev.errorcode = (int)recBuff[6];
				return -200;
			}

			fwLabel.Text = string.Format("{0:f3}", (uint)recBuff[10]  + (double)recBuff[9]/100.0);
			blLabel.Text = string.Format("{0:f3}", (uint)recBuff[12]  + (double)recBuff[11]/100.0);
			hwLabel.Text = string.Format("{0:f3}", (uint)recBuff[14]  + (double)recBuff[13]/100.0);
			serialLabel.Text = Convert.ToString((uint)recBuff[15] + (uint)recBuff[16]*256 + (uint)recBuff[17]*65536 + (uint)recBuff[18]*16777216);
			prodIDLabel.Text = Convert.ToString((uint)recBuff[19] + (uint)recBuff[20]*256);
			locIDLabel.Text = recBuff[21].ToString();
			fioAnalogLabel.Text = recBuff[23].ToString(); 
			fioDirLabel.Text = recBuff[24].ToString(); 
			fioStateLabel.Text = recBuff[25].ToString();
			eioAnalogLabel.Text = recBuff[26].ToString(); 
			eioDirLabel.Text = recBuff[27].ToString(); 
			eioStateLabel.Text = recBuff[28].ToString();
			cioDirLabel.Text = recBuff[29].ToString(); 
			cioStateLabel.Text = recBuff[30].ToString();
			dac1EnableLabel.Text = recBuff[31].ToString();
			dac0Label.Text = recBuff[32].ToString();
			dac1Label.Text = recBuff[33].ToString();
			u3bLabel.Text = ((byte)(recBuff[37]&1)).ToString();
			u3cLabel.Text = ((byte)((recBuff[37]/2)&1)).ToString();
			hvLabel.Text = ((byte)((recBuff[37]/16)&1)).ToString();
			tccsLabel.Text = recBuff[34].ToString();
			tccdLabel.Text = recBuff[36].ToString();
			disableTCPOLabel.Text = ((byte)(recBuff[36]&1)).ToString();

			return 0;
		}

		private void clearLabels()
		{
			//clearing all the info labels
			fwLabel.Text = ""; blLabel.Text = "";
			hwLabel.Text = ""; serialLabel.Text = "";
			prodIDLabel.Text = ""; locIDLabel.Text = "";  
			fioAnalogLabel.Text = ""; fioDirLabel.Text = ""; 
			fioStateLabel.Text = ""; eioAnalogLabel.Text = ""; 
			eioDirLabel.Text = ""; eioStateLabel.Text = "";
			cioDirLabel.Text = ""; cioStateLabel.Text = "";
			dac1EnableLabel.Text = ""; dac0Label.Text = "";
			dac1Label.Text = "";
			u3bLabel.Text = "";
			u3cLabel.Text = "";
			hvLabel.Text = "";
			tccsLabel.Text = "";
			tccdLabel.Text = "";
			disableTCPOLabel.Text = "";
		}

		private string getError(int error)
		{
			switch(error)
			{
				case 0: return("");  //no errors
				case -1: return("Error : send failed");
				case -2: return("Error : receive failed");
				case -3: return("Error : received bad checksum8");
				case -4: return("Error : received bad checksum16");
				case -5: return("Error : received bad checksum");
				case -6: return("Error : received wrong command bytes");
				case -7: return("Error : received buffer has wrong IOType");
				case -200: return("Error : received error code # " + u3Dev.errorcode + " from the response");
				default: errorBox.Text = "Error"; break;
			}
			return("");
		}

	}
}
