#ifndef _LABJACK_H_
#define _LABJACK_H_

const WCHAR gcszRegisterClientDriverId[] = L"RegisterClientDriverID";
const WCHAR gcszRegisterClientSettings[] = L"RegisterClientSettings";

const WCHAR gcszUnRegisterClientDriverId[] = L"UnRegisterClientDriverID";
const WCHAR gcszUnRegisterClientSettings[] = L"UnRegisterClientSettings";

const WCHAR gcszDriverIdUE9[] = L"labjackusb_driver";
const WCHAR gcszDriverIdU3[] = L"labjackusb_u3_driver";

static LPCTSTR lpsLogName = TEXT("\\labjackusb_log.txt");

const ULONG LABJACK_VENDOR_ID = (ULONG)(0x0cd5);

//context for UE9 and U3
typedef struct _LABJACKUSB_CONTEXT {
	USB_HANDLE hDevice;
	LPCUSB_INTERFACE lpInterface;
	USB_PIPE hPipe[4];
	CRITICAL_SECTION csLock;
	BOOL bIsLocked;
	LPTSTR  ActivePath;
	LPCUSB_FUNCS   UsbFuncs;
	HANDLE hStreamDevice;
	USHORT VendorID;
	USHORT ProductID;
} LABJACKUSB_CONTEXT, *PLABJACKUSB_CONTEXT;

#endif