//
// labjackusb.h
//
// Version History:
// 
// 1.00 - Initial release
//
// 1.01 - U3 support added
//

#ifndef _LABJACKUSB_H_
#define _LABJACKUSB_H_

#define LJUSB_DRIVER_VERSION 1.01

#ifdef __cplusplus
extern "C"{
#endif

//Product IDs	
const ULONG UE9_PRODUCT_ID	= 9;
const ULONG U3_PRODUCT_ID	= 3;

//The max number of devices that the driver can support.
const ULONG UE9_MAX_DEVICES = 9;
const ULONG U3_MAX_DEVICES = 9;

//UE9 pipes to read/write through
const ULONG UE9_PIPE_EP1_OUT = 0;
const ULONG UE9_PIPE_EP1_IN = 1;
const ULONG UE9_PIPE_EP2_OUT = 2;
const ULONG UE9_PIPE_EP2_IN = 3;

//U3 pipes to read/write through
const ULONG U3_PIPE_EP1_OUT = 0;
const ULONG U3_PIPE_EP1_IN = 1;
const ULONG U3_PIPE_EP2_IN = 3;

ULONG __stdcall LJUSB_GetDevCount(ULONG ProductID);
//Returns the total number of LabJack USB devices connected.
//ProductID = The product ID of the devices you want to get the count of.  


HANDLE __stdcall LJUSB_OpenDevice(UINT DevNum, DWORD dwReserved, ULONG ProductID);
//Obtains a handle for a LabJack USB device.  Returns INVALID_HANDLE_VALUE if there is an error.
//DevNum = The device number of the LabJack USB device you want to open.  For example, if there
//         is one device connected, set DevNum = 1.  If you have two devices connected, then set 
//         DevNum = 1, or DevNum = 2.
//dwReserved = Not used, set to 0.
//ProductID = The product ID of the LabJack USB device.  Currently only the UE9 is supported.


ULONG __stdcall LJUSB_BulkRead(HANDLE hDevice, ULONG Pipe, BYTE *pBuff, ULONG Count);
//Reads from a bulk endpoint.  Returns the count of the number of bytes read, or 0 on 
//error.  Note: This is a blocking call that returns under the following conditions: 
//The requested amount of data has been received, the device is unplugged from the system, 
//abort pipe is issued on the blocked pipe, or a short packet is received.
//hDevice = Handle of the LabJack USB device.
//Pipe = The pipe you want to read your data through (PIPE_EP1_IN or PIPE_EP2_IN).
//*pBuff = Pointer a buffer that will be read from the device.
//Count = The size of the buffer to be read from the device.


ULONG __stdcall LJUSB_BulkWrite(HANDLE hDevice, ULONG Pipe, BYTE *pBuff, ULONG Count);
//Writes to a bulk endpoint.  Returns the count of the number of bytes wrote, or 0 on 
//error.  Note: This is a blocking call that returns under the following conditions: 
//The requested amount of data has been sent, the device is unplugged from the system or 
//abort pipe is issued on the blocked pipe.
//hDevice = Handle of the LabJack USB device.
//Pipe = The pipe you want to write your data through (PIPE_EP1_OUT or PIPE_EP2_OUT).
//*pBuff = Pointer to the buffer that will be written to the device.
//Count = The size of the buffer to be written to the device.


void __stdcall LJUSB_CloseDevice(HANDLE hDevice);
//Closes the handle of a LabJack USB device.


BOOL __stdcall LJUSB_AbortPipe(HANDLE hDevice, ULONG Pipe);
//Aborts pipe transfers of a LabJack USB device.
//hDevice = Handle of the LabJack USB device.
//Pipe = The pipe you want to abort the transfers of.

#ifdef __cplusplus
}
#endif

#endif
