//------------------------------------------------------------------------------------------
// File: DAC7611.cpp
// Written by: LabJack Support <support@labjack.com>
// Date Written: Nov 2003
// Goal: This program demonstrates how to control a DAC7611 D/A converter via the LabJack
//		 U12's SPI feature. 
//
// Necessary Resource files:	ljackuw.lib
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
#include<iostream.h>
#include"ljackuw.h" 
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
//==========================================================================================
// Function to set the Analog output voltage to bVolts*0.001 V using Synch
long set_DAC(long bVolts);
//==========================================================================================
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
const long demo = 0;			// Demo mode off
const long SPImode = 0;			// SPI Mode A
const long msDelay = 0;			// no delay
const long husDelay = 0;		// no delay
const long controlCS = 1;		// use synch to controll CS.
const long csLine = 0;			// CS line is D0
const long csState = 0;			// use standard !CS
const long configD = 1;			// Allow synch to set direction of D lines
const long numWriteRead = 2;	// Number of bytes to write.

void main()
{
	long voltage = 0;
	long errorcode = 0;
	long IDnum = -1;
	
	errorcode = EDigitalOut(&IDnum,demo,1,1,1);					// LD line is normally high
	if(errorcode) 
		cout << "Errorcode =" << errorcode << '\n';
	else
		do{
			cout << "Enter a binary voltage between 0 and 4095: ";
			cin >> voltage;
			if(voltage < 0 || voltage > 4095)
				cout << "Invalid voltage" << endl;
			else
			{
				errorcode = set_DAC(voltage);
				if(errorcode) cout << "Errorcode =" << errorcode << '\n';
			}
		}while(voltage >= 0);
}
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
long set_DAC(long bVolts)
{
	long data[18] = {0};
	long errorcode = 0;
	long IDnum = -1;

	data[0] = bVolts / 256;
	data[1] = bVolts % 256;
	
	errorcode = Synch(&IDnum,demo,SPImode,msDelay,husDelay,controlCS,csLine,csState,
				  configD,numWriteRead,data);

	if(!errorcode)
	{
		//Strobe !LD to load the DAC
		errorcode = EDigitalOut(&IDnum,demo,1,1,0); 
		if(!errorcode)
		{
			errorcode = EDigitalOut(&IDnum,demo,1,1,1);
		}
	}

	return errorcode;
}
//------------------------------------------------------------------------------------------
