//------------------------------------------------------------------------------------------
// File: ADS7813_synch.cpp
// Written by: LabJack Support <support@labjack.com>
// Date Written: Nov 2003
// Goal: Demonsration of SPI communication with a ADS7813 analog to digital converter.
//
// Necessary Resource files:	ljackuw.lib
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
#include<iostream.h>
#include"ljackuw.h"
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
const long demo = 0;			// Demo mode off
const long SPImode = 3;			// SPI Mode D
const long msDelay = 0;			// no delay
const long husDelay = 0;		// no delay
const long controlCS = 1;		// use synch to controll CS.
const long csLine = 1;			// CS line is D1
const long csState = 0;			// use standard !CS
const long configD = 1;			// Allow synch to set direction of D lines
const long numWriteRead = 2;	// Number of bytes to read/write.
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
//==========================================================================================
// set_bit:				This functino will set the state of a single D line and output error
//						information.
//
//	inputs:			
//		Dline:			The D line to set: 0-15
//		state:			The desired state of the D line.
//
void set_bit(long Dline, long state);
//==========================================================================================
//==========================================================================================
// SPI:					The function will call The LabJack U12's Synch function and output
//						error information.
//
//	input:				
//		data:			An array of 18 longs which contain the data to be sent. The Array 
//						will be filled with data recieved.
//	
void SPI(long* data);
//==========================================================================================
//------------------------------------------------------------------------------------------

const bDC_offset = 24;		// binary representation of the dc offset.

//------------------------------------------------------------------------------------------
void main()
{
	char resp = 'y';
	long i;
	long result = 0;
	double voltage;
	long data[18] = {0};

	set_bit(0,1);				// start with conv line high
	set_bit(1,1);				// start with CS line high

	cout.precision(4);
	
	do{
		set_bit(0,0);			// start a conversion. conversion takes ~20 us
		set_bit(0,1);

		for(i=0; i<18; ++i)		// clear array.
			data[i] = 0;
				
		SPI(data);				// get data from ADS7813

		result = data[0] * 256 + data[1];
		if(result < 32768)
			voltage = (double) (result+bDC_offset)*5/32768;
		else
			voltage = (double) ((result+bDC_offset)-65535)*5/32768;
		cout << " Value = " << result <<" "<<voltage <<endl;
		//cout << "Another conversion? " ;
		//cin >> resp;
	}while(resp == 'y' || resp == 'Y');
}
//------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------
void SPI(long* data)
{
	long IDnum = -1;
	long errorcode = 0;
	char error[50];

	errorcode = Synch(&IDnum,demo,SPImode,msDelay,husDelay,controlCS,csLine,csState,
					configD,numWriteRead,data);

	if(errorcode) 
	{
		GetErrorString(errorcode, error);
		cout << "Error: " << error << endl;
	}
}

void set_bit(long Dline, long state)
{
	long errorcode = 0;
	long IDnum = -1;
	char error[50];

	errorcode = EDigitalOut(&IDnum,demo,Dline,1,state);

	if(errorcode) 
	{
		GetErrorString(errorcode, error);
		cout << "Error: " << error << endl;
	}
}
//------------------------------------------------------------------------------------------