/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class FastByteArrayOutputStream
extends OutputStream {
    public static final int DEFAULT_INIT_SIZE = 100;
    public static final int DEFAULT_BUMP_SIZE = 100;
    protected int count;
    protected int bumpLen;
    protected byte[] buf;

    public FastByteArrayOutputStream() {
        this.buf = new byte[100];
        this.bumpLen = 100;
    }

    public FastByteArrayOutputStream(int initialSize) {
        this.buf = new byte[initialSize];
        this.bumpLen = 100;
    }

    public FastByteArrayOutputStream(int initialSize, int bumpSize) {
        this.buf = new byte[initialSize];
        this.bumpLen = bumpSize;
    }

    public FastByteArrayOutputStream(byte[] buffer) {
        this.buf = buffer;
        this.bumpLen = 100;
    }

    public FastByteArrayOutputStream(byte[] buffer, int bumpSize) {
        this.buf = buffer;
        this.bumpLen = bumpSize;
    }

    public int size() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
    }

    public void write(int b) throws IOException {
        if (this.count + 1 > this.buf.length) {
            this.bump(1);
        }
        this.buf[this.count++] = (byte)b;
    }

    public void write(byte[] fromBuf) throws IOException {
        int needed = this.count + fromBuf.length - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
        for (int i = 0; i < fromBuf.length; ++i) {
            this.buf[this.count++] = fromBuf[i];
        }
    }

    public void write(byte[] fromBuf, int offset, int length) throws IOException {
        int needed = this.count + length - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
        int fromLen = offset + length;
        for (int i = offset; i < fromLen; ++i) {
            this.buf[this.count++] = fromBuf[i];
        }
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, encoding);
    }

    public byte[] toByteArray() {
        byte[] toBuf = new byte[this.count];
        System.arraycopy(this.buf, 0, toBuf, 0, this.count);
        return toBuf;
    }

    public void toByteArray(byte[] toBuf, int offset) {
        int toLen = toBuf.length > this.count ? this.count : toBuf.length;
        for (int i = offset; i < toLen; ++i) {
            toBuf[i] = this.buf[i];
        }
    }

    public byte[] getBufferBytes() {
        return this.buf;
    }

    public int getBufferOffset() {
        return 0;
    }

    public int getBufferLength() {
        return this.count;
    }

    public void makeSpace(int sizeNeeded) {
        int needed = this.count + sizeNeeded - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
    }

    public void addSize(int sizeAdded) {
        this.count += sizeAdded;
    }

    private void bump(int needed) {
        byte[] toBuf = new byte[this.buf.length + needed + this.bumpLen];
        for (int i = 0; i < this.count; ++i) {
            toBuf[i] = this.buf[i];
        }
        this.buf = toBuf;
    }
}

