/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.ASCIIInputStream;
import net.wimpi.modbus.io.ASCIIOutputStream;
import net.wimpi.modbus.io.BytesInputStream;
import net.wimpi.modbus.io.BytesOutputStream;
import net.wimpi.modbus.io.ModbusSerialTransport;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.util.ModbusUtil;

public class ModbusASCIITransport
extends ModbusSerialTransport {
    private DataInputStream m_InputStream;
    private ASCIIOutputStream m_OutputStream;
    private byte[] m_InBuffer;
    private BytesInputStream m_ByteIn;
    private BytesOutputStream m_ByteInOut;
    private BytesOutputStream m_ByteOut;
    public static final int FRAME_START = 1000;
    public static final int FRAME_END = 2000;

    public void close() throws IOException {
        this.m_InputStream.close();
        this.m_OutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessage(ModbusMessage msg) throws ModbusIOException {
        try {
            BytesOutputStream bytesOutputStream = this.m_ByteOut;
            synchronized (bytesOutputStream) {
                msg.setHeadless();
                msg.writeTo(this.m_ByteOut);
                byte[] buf = this.m_ByteOut.getBuffer();
                int len = this.m_ByteOut.size();
                this.m_OutputStream.write(1000);
                this.m_OutputStream.write(buf, 0, len);
                System.out.println("Writing: " + ModbusUtil.toHex(buf, 0, len));
                this.m_OutputStream.write(ModbusASCIITransport.calculateLRC(buf, 0, len));
                this.m_OutputStream.write(2000);
                this.m_OutputStream.flush();
                this.m_ByteOut.reset();
                if (this.m_Echo) {
                    this.readEcho(len + 3);
                }
            }
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O failed to write");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ModbusRequest readRequest() throws ModbusIOException {
        boolean done = false;
        ModbusRequest request = null;
        int in = -1;
        try {
            while (true) {
                if ((in = this.m_InputStream.read()) != 1000) {
                    continue;
                }
                byte[] byArray = this.m_InBuffer;
                // MONITORENTER : this.m_InBuffer
                this.m_ByteInOut.reset();
                while ((in = this.m_InputStream.read()) != 2000) {
                    if (in == -1) {
                        throw new IOException("I/O exception - Serial port timeout.");
                    }
                    this.m_ByteInOut.writeByte(in);
                }
                if (this.m_InBuffer[this.m_ByteInOut.size() - 1] != this.calculateLRC(this.m_InBuffer, 0, this.m_ByteInOut.size(), 1)) {
                    // MONITOREXIT : byArray
                } else {
                    this.m_ByteIn.reset(this.m_InBuffer, this.m_ByteInOut.size());
                    in = this.m_ByteIn.readUnsignedByte();
                    if (in != ModbusCoupler.getReference().getUnitID()) {
                        // MONITOREXIT : byArray
                    } else {
                        in = this.m_ByteIn.readUnsignedByte();
                        request = ModbusRequest.createModbusRequest(in);
                        request.setHeadless();
                        this.m_ByteIn.reset(this.m_InBuffer, this.m_ByteInOut.size());
                        request.readFrom(this.m_ByteIn);
                        // MONITOREXIT : byArray
                        done = true;
                    }
                }
                if (done) return request;
            }
        }
        catch (Exception ex) {
            if (!Modbus.debug) throw new ModbusIOException("I/O exception - failed to read.");
            System.out.println(ex.getMessage());
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ModbusResponse readResponse() throws ModbusIOException {
        boolean done = false;
        ModbusResponse response = null;
        int in = -1;
        try {
            while (true) {
                if ((in = this.m_InputStream.read()) != 1000) {
                    if (in != -1) continue;
                    throw new IOException("I/O exception - Serial port timeout.");
                }
                byte[] byArray = this.m_InBuffer;
                // MONITORENTER : this.m_InBuffer
                this.m_ByteInOut.reset();
                while ((in = this.m_InputStream.read()) != 2000) {
                    if (in == -1) {
                        throw new IOException("I/O exception - Serial port timeout.");
                    }
                    this.m_ByteInOut.writeByte(in);
                }
                int len = this.m_ByteInOut.size();
                if (Modbus.debug) {
                    System.out.println("Received: " + ModbusUtil.toHex(this.m_InBuffer, 0, len));
                }
                if (this.m_InBuffer[len - 1] != this.calculateLRC(this.m_InBuffer, 0, len, 1)) {
                    // MONITOREXIT : byArray
                } else {
                    this.m_ByteIn.reset(this.m_InBuffer, this.m_ByteInOut.size());
                    in = this.m_ByteIn.readUnsignedByte();
                    in = this.m_ByteIn.readUnsignedByte();
                    response = ModbusResponse.createModbusResponse(in);
                    response.setHeadless();
                    this.m_ByteIn.reset(this.m_InBuffer, this.m_ByteInOut.size());
                    response.readFrom(this.m_ByteIn);
                    // MONITOREXIT : byArray
                    done = true;
                }
                if (done) return response;
            }
        }
        catch (Exception ex) {
            if (!Modbus.debug) throw new ModbusIOException("I/O exception - failed to read.");
            System.out.println(ex.getMessage());
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    public void prepareStreams(InputStream in, OutputStream out) throws IOException {
        this.m_InputStream = new DataInputStream(new ASCIIInputStream(in));
        this.m_OutputStream = new ASCIIOutputStream(out);
        this.m_ByteOut = new BytesOutputStream(256);
        this.m_InBuffer = new byte[256];
        this.m_ByteIn = new BytesInputStream(this.m_InBuffer);
        this.m_ByteInOut = new BytesOutputStream(this.m_InBuffer);
    }

    private static final int calculateLRC(byte[] data, int off, int len) {
        int lrc = 0;
        for (int i = off; i < len; ++i) {
            lrc += data[i];
        }
        return (byte)lrc & 0xFF;
    }

    private final byte calculateLRC(byte[] data, int off, int length, int tailskip) {
        int lrc = 0;
        for (int i = off; i < length - tailskip; ++i) {
            lrc += data[i];
        }
        return (byte)lrc;
    }
}

