/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.TCPSlaveConnection;

public class TCPConnectionHandler
implements Runnable {
    private TCPSlaveConnection m_Connection;
    private ModbusTransport m_Transport;

    public TCPConnectionHandler(TCPSlaveConnection con) {
        this.setConnection(con);
    }

    public void setConnection(TCPSlaveConnection con) {
        this.m_Connection = con;
        this.m_Transport = this.m_Connection.getModbusTransport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                while (true) {
                    ModbusRequest request = this.m_Transport.readRequest();
                    ModbusResponse response = null;
                    response = ModbusCoupler.getReference().getProcessImage() == null ? request.createExceptionResponse(1) : request.createResponse();
                    if (Modbus.debug) {
                        System.out.println("Request:" + request.getHexMessage());
                    }
                    if (Modbus.debug) {
                        System.out.println("Response:" + response.getHexMessage());
                    }
                    this.m_Transport.writeMessage(response);
                }
            }
            catch (ModbusIOException ex) {
                if (!ex.isEOF()) {
                    ex.printStackTrace();
                }
                try {
                    this.m_Connection.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            try {
                this.m_Connection.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

