/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.util.BitVector;

public final class ReadCoilsResponse
extends ModbusResponse {
    private BitVector m_Coils;

    public ReadCoilsResponse() {
    }

    public ReadCoilsResponse(int count) {
        this.m_Coils = new BitVector(count);
        this.setDataLength(this.m_Coils.byteSize() + 1);
    }

    public int getBitCount() {
        if (this.m_Coils == null) {
            return 0;
        }
        return this.m_Coils.size();
    }

    public BitVector getCoils() {
        return this.m_Coils;
    }

    public boolean getCoilStatus(int index) throws IndexOutOfBoundsException {
        return this.m_Coils.getBit(index);
    }

    public void setCoilStatus(int index, boolean b) {
        this.m_Coils.setBit(index, b);
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.writeByte(this.m_Coils.byteSize());
        dout.write(this.m_Coils.getBytes(), 0, this.m_Coils.byteSize());
    }

    public void readData(DataInput din) throws IOException {
        int count = din.readUnsignedByte();
        byte[] data = new byte[count];
        for (int k = 0; k < count; ++k) {
            data[k] = din.readByte();
        }
        this.m_Coils = BitVector.createBitVector(data);
        this.setDataLength(count + 1);
    }
}

