/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.procimg;

import java.util.Vector;
import net.wimpi.modbus.procimg.DigitalIn;
import net.wimpi.modbus.procimg.DigitalOut;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.InputRegister;
import net.wimpi.modbus.procimg.ProcessImageImplementation;
import net.wimpi.modbus.procimg.Register;

public class SimpleProcessImage
implements ProcessImageImplementation {
    protected Vector m_DigitalInputs = new Vector();
    protected Vector m_DigitalOutputs = new Vector();
    protected Vector m_InputRegisters = new Vector();
    protected Vector m_Registers = new Vector();
    protected boolean m_Locked = false;

    public boolean isLocked() {
        return this.m_Locked;
    }

    public void setLocked(boolean locked) {
        this.m_Locked = locked;
    }

    public void addDigitalIn(DigitalIn di) {
        if (!this.isLocked()) {
            this.m_DigitalInputs.addElement(di);
        }
    }

    public void removeDigitalIn(DigitalIn di) {
        if (!this.isLocked()) {
            this.m_DigitalInputs.removeElement(di);
        }
    }

    public void setDigitalIn(int ref, DigitalIn di) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                this.m_DigitalInputs.setElementAt(di, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    public DigitalIn getDigitalIn(int ref) throws IllegalAddressException {
        try {
            return (DigitalIn)this.m_DigitalInputs.elementAt(ref);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    public int getDigitalInCount() {
        return this.m_DigitalInputs.size();
    }

    public DigitalIn[] getDigitalInRange(int ref, int count) {
        if (ref < 0 || ref + count > this.m_DigitalInputs.size()) {
            throw new IllegalAddressException();
        }
        DigitalIn[] dins = new DigitalIn[count];
        for (int i = 0; i < dins.length; ++i) {
            dins[i] = this.getDigitalIn(ref + i);
        }
        return dins;
    }

    public void addDigitalOut(DigitalOut _do) {
        if (!this.isLocked()) {
            this.m_DigitalOutputs.addElement(_do);
        }
    }

    public void removeDigitalOut(DigitalOut _do) {
        if (!this.isLocked()) {
            this.m_DigitalOutputs.removeElement(_do);
        }
    }

    public void setDigitalOut(int ref, DigitalOut _do) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                this.m_DigitalOutputs.setElementAt(_do, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    public DigitalOut getDigitalOut(int ref) throws IllegalAddressException {
        try {
            return (DigitalOut)this.m_DigitalOutputs.elementAt(ref);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    public int getDigitalOutCount() {
        return this.m_DigitalOutputs.size();
    }

    public DigitalOut[] getDigitalOutRange(int ref, int count) {
        if (ref < 0 || ref + count > this.m_DigitalOutputs.size()) {
            throw new IllegalAddressException();
        }
        DigitalOut[] douts = new DigitalOut[count];
        for (int i = 0; i < douts.length; ++i) {
            douts[i] = this.getDigitalOut(ref + i);
        }
        return douts;
    }

    public void addInputRegister(InputRegister reg) {
        if (!this.isLocked()) {
            this.m_InputRegisters.addElement(reg);
        }
    }

    public void removeInputRegister(InputRegister reg) {
        if (!this.isLocked()) {
            this.m_InputRegisters.removeElement(reg);
        }
    }

    public void setInputRegister(int ref, InputRegister reg) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                this.m_InputRegisters.setElementAt(reg, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    public InputRegister getInputRegister(int ref) throws IllegalAddressException {
        try {
            return (InputRegister)this.m_InputRegisters.elementAt(ref);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    public int getInputRegisterCount() {
        return this.m_InputRegisters.size();
    }

    public InputRegister[] getInputRegisterRange(int ref, int count) {
        if (ref < 0 || ref + count > this.m_InputRegisters.size()) {
            throw new IllegalAddressException();
        }
        InputRegister[] iregs = new InputRegister[count];
        for (int i = 0; i < iregs.length; ++i) {
            iregs[i] = this.getInputRegister(ref + i);
        }
        return iregs;
    }

    public void addRegister(Register reg) {
        if (!this.isLocked()) {
            this.m_Registers.addElement(reg);
        }
    }

    public void removeRegister(Register reg) {
        if (!this.isLocked()) {
            this.m_Registers.removeElement(reg);
        }
    }

    public void setRegister(int ref, Register reg) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                this.m_Registers.setElementAt(reg, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    public Register getRegister(int ref) throws IllegalAddressException {
        try {
            return (Register)this.m_Registers.elementAt(ref);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    public int getRegisterCount() {
        return this.m_Registers.size();
    }

    public Register[] getRegisterRange(int ref, int count) {
        if (ref < 0 || ref + count > this.m_Registers.size()) {
            throw new IllegalAddressException();
        }
        Register[] iregs = new Register[count];
        for (int i = 0; i < iregs.length; ++i) {
            iregs[i] = this.getRegister(ref + i);
        }
        return iregs;
    }
}

