/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import net.wimpi.modbus.io.FastByteArrayInputStream;

public class BytesInputStream
extends FastByteArrayInputStream
implements DataInput {
    DataInputStream m_Din = new DataInputStream(this);

    public BytesInputStream(int size) {
        super(new byte[size]);
    }

    public BytesInputStream(byte[] data) {
        super(data);
    }

    public void reset(byte[] data) {
        this.pos = 0;
        this.mark = 0;
        this.buf = data;
        this.count = data.length;
    }

    public void reset(byte[] data, int length) {
        this.pos = 0;
        this.mark = 0;
        this.count = length;
        this.buf = data;
    }

    public void reset(int length) {
        this.pos = 0;
        this.count = length;
    }

    public int skip(int n) {
        this.mark(this.pos);
        this.pos += n;
        return n;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getBufferLength() {
        return this.buf.length;
    }

    public void readFully(byte[] b) throws IOException {
        this.m_Din.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.m_Din.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.m_Din.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.m_Din.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.m_Din.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.m_Din.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.m_Din.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.m_Din.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.m_Din.readChar();
    }

    public int readInt() throws IOException {
        return this.m_Din.readInt();
    }

    public long readLong() throws IOException {
        return this.m_Din.readLong();
    }

    public float readFloat() throws IOException {
        return this.m_Din.readFloat();
    }

    public double readDouble() throws IOException {
        return this.m_Din.readDouble();
    }

    public String readLine() throws IOException {
        throw new IOException("Not supported.");
    }

    public String readUTF() throws IOException {
        return this.m_Din.readUTF();
    }
}

