/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.IOException;
import java.io.InputStream;

public class FastByteArrayInputStream
extends InputStream {
    protected int count;
    protected int pos;
    protected int mark;
    protected byte[] buf;

    public FastByteArrayInputStream(byte[] buffer) {
        this.buf = buffer;
        this.count = buffer.length;
        this.pos = 0;
        this.mark = 0;
    }

    public FastByteArrayInputStream(byte[] buffer, int offset, int length) {
        this.buf = buffer;
        this.pos = offset;
        this.count = length;
    }

    public int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readlimit) {
        this.mark = this.pos;
    }

    public void reset() {
        this.pos = this.mark;
    }

    public long skip(long count) {
        int myCount = (int)count;
        if (myCount + this.pos > this.count) {
            myCount = this.count - this.pos;
        }
        this.pos += myCount;
        return myCount;
    }

    public int read() throws IOException {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] toBuf) throws IOException {
        return this.read(toBuf, 0, toBuf.length);
    }

    public int read(byte[] toBuf, int offset, int length) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            return -1;
        }
        if (length > avail) {
            length = avail;
        }
        for (int i = 0; i < length; ++i) {
            toBuf[offset++] = this.buf[this.pos++];
        }
        return length;
    }

    public byte[] getBufferBytes() {
        return this.buf;
    }

    public int getBufferOffset() {
        return this.pos;
    }

    public int getBufferLength() {
        return this.count;
    }
}

